/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.tilecache;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.CachedTile;

public final class DiskCachedTile
implements CachedTile {
    private static final Logger LOGGER = Logger.getLogger("org.jaitools.tilecache");
    public static final String FILE_PREFIX = "tile";
    public static final String FILE_SUFFIX = ".tmp";
    private static File cacheFolder = null;
    private static final Object folderLock = new Object();
    private final Object id;
    private final WeakReference<RenderedImage> ownerRef;
    private final int tileX;
    private final int tileY;
    private final Object tileCacheMetric;
    private long timeStamp;
    private final int numBanks;
    private final int dataLen;
    private final long memorySize;
    private File file;
    private final Point location;
    private final boolean isWritable;
    private TileAction action = TileAction.getDefault();

    public static File getCacheFolder() {
        File file = null;
        if (cacheFolder != null) {
            file = new File(cacheFolder.toURI());
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCacheFolder(File folder) {
        Object object = folderLock;
        synchronized (object) {
            cacheFolder = folder == null ? null : new File(folder.toURI());
        }
    }

    DiskCachedTile(Object id, RenderedImage owner, int tileX, int tileY, Raster raster, boolean writeToFile, Object tileCacheMetric) throws IOException {
        if (owner == null || raster == null) {
            throw new IllegalArgumentException("All of owner, tile and file args must be non-null");
        }
        this.id = id;
        this.ownerRef = new WeakReference<RenderedImage>(owner);
        this.tileX = tileX;
        this.tileY = tileY;
        this.tileCacheMetric = tileCacheMetric;
        this.location = raster.getBounds().getLocation();
        this.isWritable = raster instanceof WritableRaster;
        DataBuffer db = raster.getDataBuffer();
        this.numBanks = db.getNumBanks();
        this.dataLen = db.getSize();
        this.memorySize = (long)DataBuffer.getDataTypeSize(db.getDataType()) / 8L * (long)this.dataLen * (long)this.numBanks;
        if (writeToFile) {
            this.writeData(raster);
        }
        this.setTileTimeStamp(System.currentTimeMillis());
    }

    public String toString() {
        RenderedImage o = this.getOwner();
        String ostring = o == null ? "null" : o.toString();
        Raster t = this.getTile();
        String tstring = t == null ? "null" : t.toString();
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + ostring + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + tstring + " id = " + (this.id instanceof Long ? Long.toHexString((Long)this.id) : this.id.toString()) + " memorySize = " + Long.toString(this.memorySize) + " timeStamp = " + Long.toString(this.timeStamp) + " file = " + this.file.getPath();
    }

    public Raster getTile() {
        throw new UnsupportedOperationException("Can't get a tile directly from a DiskCachedTile object");
    }

    public RenderedImage getOwner() {
        return (RenderedImage)this.ownerRef.get();
    }

    public long getTileTimeStamp() {
        return this.timeStamp;
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public long getTileSize() {
        return this.memorySize;
    }

    public int getAction() {
        return this.action.ordinal();
    }

    public boolean cachedToDisk() {
        return this.file != null;
    }

    public File getFile() {
        return this.file;
    }

    public void deleteDiskCopy() {
        if (this.file != null && !this.file.delete()) {
            LOGGER.log(Level.WARNING, "Unable to delete cached image tile file: {0}", this.file.getPath());
        }
    }

    public Object getTileId() {
        return this.id;
    }

    public Point getLocation() {
        return new Point(this.location);
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    void setAction(TileAction action) {
        this.action = action;
    }

    void setTileTimeStamp(long time) {
        this.timeStamp = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    Raster readData() {
        strm = null;
        dataBuf /* !! */  = null;
        img = (RenderedImage)this.ownerRef.get();
        raster /* !! */  = null;
        if (this.file != null && img != null) {
            try {
                strm = ImageIO.createImageInputStream(this.file);
                switch (img.getSampleModel().getDataType()) {
                    case 0: {
                        bankData = new byte[this.numBanks][this.dataLen];
                        for (i = 0; i < this.numBanks; ++i) {
                            numRead = strm.read(bankData[i], 0, this.dataLen);
                            if (numRead >= this.numBanks) continue;
                            throw new RuntimeException("Cached tile file appears to be truncated");
                        }
                        dataBuf /* !! */  = new DataBufferByte(bankData, this.dataLen);
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        bankData = new double[this.numBanks][this.dataLen];
                        for (i = 0; i < this.numBanks; ++i) {
                            strm.readFully(bankData[i], 0, this.dataLen);
                        }
                        dataBuf /* !! */  = new DataBufferDouble(bankData, this.dataLen);
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        bankData = new float[this.numBanks][this.dataLen];
                        for (i = 0; i < this.numBanks; ++i) {
                            strm.readFully(bankData[i], 0, this.dataLen);
                        }
                        dataBuf /* !! */  = new DataBufferFloat(bankData, this.dataLen);
                        ** break;
lbl33:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        bankData = new int[this.numBanks][this.dataLen];
                        for (i = 0; i < this.numBanks; ++i) {
                            strm.readFully(bankData[i], 0, this.dataLen);
                        }
                        dataBuf /* !! */  = new DataBufferInt(bankData, this.dataLen);
                        ** break;
lbl41:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        bankData = new short[this.numBanks][this.dataLen];
                        for (i = 0; i < this.numBanks; ++i) {
                            strm.readFully(bankData[i], 0, this.dataLen);
                        }
                        dataBuf /* !! */  = new DataBufferShort(bankData, this.dataLen);
                        ** break;
lbl49:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        bankData = new short[this.numBanks][this.dataLen];
                        for (i = 0; i < this.numBanks; ++i) {
                            strm.readFully(bankData[i], 0, this.dataLen);
                        }
                        dataBuf /* !! */  = new DataBufferUShort(bankData, this.dataLen);
                        ** break;
lbl57:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported image data type");
                    }
                }
            }
            catch (FileNotFoundException ex) {
                DiskCachedTile.LOGGER.log(Level.SEVERE, "Failed to read image tile data", ex);
                var6_20 = null;
                return var6_20;
            }
            catch (IOException ex) {
                DiskCachedTile.LOGGER.log(Level.SEVERE, "Failed to read image tile data", ex);
                var6_21 = null;
                return var6_21;
            }
            finally {
                if (strm != null) {
                    try {
                        strm.close();
                    }
                    catch (Throwable var7_23) {}
                }
            }
        }
        if (dataBuf /* !! */  != null) {
            raster /* !! */  = this.isWritable != false ? Raster.createWritableRaster(img.getSampleModel(), dataBuf /* !! */ , this.location) : Raster.createRaster(img.getSampleModel(), dataBuf /* !! */ , this.location);
        }
        return raster /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeData(Raster raster) throws IOException {
        ImageOutputStream strm = null;
        DataBuffer dataBuf = raster.getDataBuffer();
        if (this.file == null) {
            this.file = this.createFile();
        }
        try {
            strm = ImageIO.createImageOutputStream(this.file);
            switch (dataBuf.getDataType()) {
                case 0: {
                    for (int i = 0; i < this.numBanks; ++i) {
                        byte[] bankData = ((DataBufferByte)dataBuf).getData(i);
                        strm.write(bankData);
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < this.numBanks; ++i) {
                        double[] bankData = ((DataBufferDouble)dataBuf).getData(i);
                        strm.writeDoubles(bankData, 0, this.dataLen);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.numBanks; ++i) {
                        float[] bankData = ((DataBufferFloat)dataBuf).getData(i);
                        strm.writeFloats(bankData, 0, this.dataLen);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.numBanks; ++i) {
                        int[] bankData = ((DataBufferInt)dataBuf).getData(i);
                        strm.writeInts(bankData, 0, this.dataLen);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.numBanks; ++i) {
                        short[] bankData = ((DataBufferShort)dataBuf).getData(i);
                        strm.writeShorts(bankData, 0, this.dataLen);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.numBanks; ++i) {
                        short[] bankData = ((DataBufferUShort)dataBuf).getData(i);
                        strm.writeShorts(bankData, 0, this.dataLen);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported image data type");
                }
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, "Failed to write image tile data", ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to write image tile data", ex);
        }
        finally {
            if (strm != null) {
                try {
                    strm.close();
                }
                catch (Throwable ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile() throws IOException {
        Object object = folderLock;
        synchronized (object) {
            return File.createTempFile(FILE_PREFIX, FILE_SUFFIX, cacheFolder);
        }
    }

    public static enum TileAction {
        ACTION_ADDED(0, "added to cache"),
        ACTION_ADDED_RESIDENT(1, "added to cache and placed into memory"),
        ACTION_RESIDENT(2, "placed into memory"),
        ACTION_NON_RESIDENT(3, "removed from memory"),
        ACTION_REMOVED(4, "removed from the cache"),
        ACTION_ACCESSED(5, "accessed"),
        ACTION_GARBAGE_COLLECTED(6, "garbage collected");

        private static final Map<Integer, TileAction> lookup;
        private final int action;
        private final String desc;

        private TileAction(int action, String desc) {
            this.action = action;
            this.desc = desc;
        }

        public int getAction() {
            return this.action;
        }

        public String getDescription() {
            return this.desc;
        }

        public static TileAction get(int actionValue) {
            return lookup.get(actionValue);
        }

        public static TileAction getDefault() {
            return ACTION_ACCESSED;
        }

        static {
            lookup = new HashMap<Integer, TileAction>();
            for (TileAction t : EnumSet.allOf(TileAction.class)) {
                lookup.put(t.getAction(), t);
            }
        }
    }
}

