/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.text.MessageFormat;
import javax.measure.Unit;
import org.geotools.util.Utilities;

public class Range<T extends Comparable<? super T>>
implements Serializable {
    private static final long serialVersionUID = -5393896130562660517L;
    final Class<T> elementClass;
    final T minValue;
    final T maxValue;
    private final boolean isMinIncluded;
    private final boolean isMaxIncluded;

    public Range(Class<T> elementClass, T value) {
        this(elementClass, value, true, value, true);
    }

    public Range(Class<T> elementClass, T minValue, T maxValue) {
        this(elementClass, minValue, true, maxValue, true);
    }

    public Range(Class<T> elementClass, T minValue, boolean isMinIncluded, T maxValue, boolean isMaxIncluded) {
        Range.ensureNonNull("elementClass", elementClass);
        this.elementClass = elementClass;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.isMinIncluded = isMinIncluded && minValue != null;
        this.isMaxIncluded = isMaxIncluded && maxValue != null;
        this.checkElementClass();
        if (minValue != null) {
            this.ensureCompatible(minValue.getClass());
        }
        if (maxValue != null) {
            this.ensureCompatible(maxValue.getClass());
        }
    }

    Range<T> create(T minValue, boolean isMinIncluded, T maxValue, boolean isMaxIncluded) {
        return new Range<T>(this.elementClass, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    static void ensureNonNull(String name, Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", name));
        }
    }

    private Range<? extends T> ensureCompatible(Range<?> range) throws IllegalArgumentException {
        Range.ensureNonNull("range", range);
        this.ensureCompatible(range.elementClass);
        return range;
    }

    private void ensureCompatible(Class<?> type) throws IllegalArgumentException {
        if (!this.elementClass.isAssignableFrom(type)) {
            throw new IllegalArgumentException(MessageFormat.format("Class '{0}' is illegal. It must be '{1}' or a derivated class.", type, this.elementClass));
        }
    }

    void checkElementClass() throws IllegalArgumentException {
    }

    Range<T>[] newArray(int length) {
        return new Range[length];
    }

    public Class<T> getElementClass() {
        return this.elementClass;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public boolean isMinIncluded() {
        return this.isMinIncluded;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public boolean isMaxIncluded() {
        return this.isMaxIncluded;
    }

    public boolean isEmpty() {
        if (this.minValue == null || this.maxValue == null) {
            return false;
        }
        int c = this.minValue.compareTo(this.maxValue);
        if (c < 0) {
            return false;
        }
        return c != 0 || !this.isMinIncluded || !this.isMaxIncluded;
    }

    public boolean contains(Comparable<?> value) throws IllegalArgumentException {
        if (value == null) {
            return false;
        }
        this.ensureCompatible(value.getClass());
        return this.containsNC(value);
    }

    final boolean containsNC(Comparable<T> value) {
        int c;
        if (!(this.minValue == null || (c = this.minValue.compareTo(value)) < 0 || c == 0 && this.isMinIncluded)) {
            return false;
        }
        return this.maxValue == null || (c = this.maxValue.compareTo(value)) > 0 || c == 0 && this.isMaxIncluded;
    }

    public boolean contains(Range<?> range) throws IllegalArgumentException {
        return this.containsNC(this.ensureCompatible(range));
    }

    final boolean containsNC(Range<? extends T> range) {
        return !(this.minValue != null && this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) > 0 || this.maxValue != null && this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) < 0);
    }

    public boolean intersects(Range<?> range) throws IllegalArgumentException {
        return this.intersectsNC(this.ensureCompatible(range));
    }

    final boolean intersectsNC(Range<? extends T> range) {
        return !this.isEmpty() && !range.isEmpty() && this.compareMinTo(range.maxValue, range.isMaxIncluded ? 0 : -1) <= 0 && this.compareMaxTo(range.minValue, range.isMinIncluded ? 0 : 1) >= 0;
    }

    public Range<?> intersect(Range<?> range) throws IllegalArgumentException {
        return this.intersectNC(this.ensureCompatible(range));
    }

    final Range<? extends T> intersectNC(Range<? extends T> range) throws IllegalArgumentException {
        Range<T> min = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) < 0 ? range : this;
        Range<T> max = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) > 0 ? range : this;
        Range<T> intersect = min == max ? min : this.create(min.minValue, min.isMinIncluded, max.maxValue, max.isMaxIncluded);
        assert (intersect.isEmpty() == !this.intersects(range)) : intersect;
        return intersect;
    }

    public Range<?>[] subtract(Range<?> range) throws IllegalArgumentException {
        return this.subtractNC(this.ensureCompatible(range));
    }

    final Range<T>[] subtractNC(Range<? extends T> range) throws IllegalArgumentException {
        Range<T> subtract;
        if (!this.intersects(range)) {
            subtract = this;
        } else {
            boolean clipMax;
            boolean clipMin = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) >= 0;
            boolean bl = clipMax = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) <= 0;
            if (clipMin) {
                if (clipMax) {
                    assert (range.contains(this)) : range;
                    return this.newArray(0);
                }
                subtract = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
            } else {
                if (!clipMax) {
                    Range<T>[] array = this.newArray(2);
                    array[0] = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
                    array[1] = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
                    return array;
                }
                subtract = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
            }
        }
        assert (this.contains(subtract)) : subtract;
        assert (!subtract.intersects(range)) : subtract;
        Range<T>[] array = this.newArray(1);
        array[0] = subtract;
        return array;
    }

    public Range<?> union(Range<?> range) throws IllegalArgumentException {
        return this.unionNC(this.ensureCompatible(range));
    }

    final Range<?> unionNC(Range<? extends T> range) throws IllegalArgumentException {
        Range<T> min = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) > 0 ? range : this;
        Range<T> max = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) < 0 ? range : this;
        Range<T> union = min == max ? min : this.create(min.minValue, min.isMinIncluded, max.maxValue, max.isMaxIncluded);
        assert (union.contains(min)) : min;
        assert (union.contains(max)) : max;
        return union;
    }

    final int compareMinTo(T value, int delta) {
        if (value == null) {
            return delta;
        }
        if (this.minValue == null) {
            return -1;
        }
        int c = this.minValue.compareTo(value);
        if (c == 0) {
            if (this.isMinIncluded) {
                return -delta;
            }
            if (delta <= 0) {
                return 1;
            }
        }
        return c;
    }

    final int compareMaxTo(T value, int delta) {
        if (value == null) {
            return delta;
        }
        if (this.maxValue == null) {
            return 1;
        }
        int c = this.maxValue.compareTo(value);
        if (c == 0) {
            if (this.isMaxIncluded) {
                return -delta;
            }
            if (delta >= 0) {
                return -1;
            }
        }
        return c;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            Range other = (Range)object;
            if (Utilities.equals(this.elementClass, other.elementClass)) {
                if (this.isEmpty()) {
                    return other.isEmpty();
                }
                return Utilities.equals(this.minValue, other.minValue) && Utilities.equals(this.maxValue, other.maxValue) && this.isMinIncluded == other.isMinIncluded && this.isMaxIncluded == other.isMaxIncluded;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 511010651;
        if (!this.isEmpty()) {
            result += this.elementClass.hashCode();
            result = Utilities.hash(this.isMaxIncluded, result);
            result = Utilities.hash(this.isMinIncluded, result);
            result = Utilities.hash(this.maxValue, result);
            result = Utilities.hash(this.minValue, result);
        }
        return result;
    }

    Unit<?> getUnits() {
        return null;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.isMinIncluded ? (char)'[' : '(');
        if (this.minValue == null) {
            buffer.append("-\u221e");
        } else {
            buffer.append(this.minValue);
        }
        buffer.append(", ");
        if (this.maxValue == null) {
            buffer.append('\u221e');
        } else {
            buffer.append(this.maxValue);
        }
        buffer.append(this.isMaxIncluded ? (char)']' : ')');
        Unit<?> units = this.getUnits();
        if (units != null) {
            buffer.append(' ').append(units);
        }
        return buffer.toString();
    }
}

