/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.XPath;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.SAXOutputter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlErrorHandler
extends DefaultHandler {
    private int errorCount = 0;
    private Element xpaths;
    private Namespace ns = Namespace.NO_NAMESPACE;
    protected SAXOutputter so;

    public void setSo(SAXOutputter so) {
        this.so = so;
    }

    public boolean errors() {
        return this.errorCount > 0;
    }

    public Element getXPaths() {
        return this.xpaths;
    }

    public String addMessage(SAXParseException exception, String typeOfError) {
        Element parent;
        if (this.errorCount == 0) {
            this.xpaths = new Element("xsderrors", this.ns);
        }
        ++this.errorCount;
        Element elem = (Element)this.so.getLocator().getNode();
        Element x = new Element("xpath", this.ns);
        try {
            String xpath = XPath.getXPath(elem);
            if (xpath.startsWith("/")) {
                int ind = xpath.indexOf(47, 1);
                xpath = ind != -1 ? xpath.substring(ind + 1) : ".";
            }
            x.setText(xpath);
        }
        catch (JDOMException e) {
            Log.error("jeeves.engine", e.getMessage(), (Throwable)e);
            x.setText("nopath");
        }
        String message = exception.getMessage() + " (Element: " + elem.getQualifiedName();
        String parentName = !elem.isRootElement() ? ((parent = (Element)elem.getParent()) != null ? parent.getQualifiedName() : "Unknown") : "/";
        message = message + " with parent element: " + parentName + ")";
        Element m = new Element("message", this.ns).setText(message);
        Element errorType = new Element("typeOfError", this.ns).setText(typeOfError);
        Element errorNumber = new Element("errorNumber", this.ns).setText(String.valueOf(this.errorCount));
        Element e = new Element("error", this.ns);
        e.addContent((Content)errorType);
        e.addContent((Content)errorNumber);
        e.addContent((Content)m);
        e.addContent((Content)x);
        this.xpaths.addContent((Content)e);
        return x.getText();
    }

    @Override
    public void error(SAXParseException parseException) throws SAXException {
        this.addMessage(parseException, "ERROR");
    }

    @Override
    public void fatalError(SAXParseException parseException) throws SAXException {
        this.addMessage(parseException, "FATAL ERROR");
    }

    @Override
    public void warning(SAXParseException parseException) throws SAXException {
        this.addMessage(parseException, "WARNING");
    }

    public Namespace getNs() {
        return this.ns;
    }

    public void setNs(Namespace ns) {
        this.ns = ns;
    }
}

