/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.ClusterNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.node.Node;
import org.elasticsearch.transport.ProxyConnectionStrategy;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.SniffConnectionStrategy;

public abstract class RemoteClusterAware {
    public static final char REMOTE_CLUSTER_INDEX_SEPARATOR = ':';
    public static final String LOCAL_CLUSTER_GROUP_KEY = "";
    protected final Settings settings;
    private final String nodeName;
    private final boolean isRemoteClusterClientEnabled;

    protected RemoteClusterAware(Settings settings) {
        this.settings = settings;
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.isRemoteClusterClientEnabled = DiscoveryNode.isRemoteClusterClient(settings);
    }

    protected static Set<String> getEnabledRemoteClusters(Settings settings) {
        return RemoteConnectionStrategy.getRemoteClusters(settings);
    }

    protected Map<String, List<String>> groupClusterIndices(Set<String> remoteClusterNames, String[] requestIndices) {
        HashMap<String, List<String>> perClusterIndices = new HashMap<String, List<String>>();
        HashSet<String> clustersToRemove = new HashSet<String>();
        for (String index : requestIndices) {
            String probe = IndexNameExpressionResolver.resolveDateMathExpression(index);
            int i = probe.indexOf(58);
            if (i >= 0) {
                if (!this.isRemoteClusterClientEnabled) {
                    assert (remoteClusterNames.isEmpty()) : remoteClusterNames;
                    throw new IllegalArgumentException("node [" + this.nodeName + "] does not have the remote cluster client role enabled");
                }
                int startIdx = index.charAt(0) == '-' ? 1 : 0;
                String remoteClusterName = index.substring(startIdx, i);
                List<String> clusters = ClusterNameExpressionResolver.resolveClusterNames(remoteClusterNames, remoteClusterName);
                String indexName = index.substring(i + 1);
                if (startIdx == 1) {
                    if (!indexName.equals("*")) {
                        throw new IllegalArgumentException(Strings.format((String)"To exclude a cluster you must specify the '*' wildcard for the index expression, but found: [%s]", (Object[])new Object[]{indexName}));
                    }
                    clustersToRemove.addAll(clusters);
                    continue;
                }
                for (String clusterName : clusters) {
                    perClusterIndices.computeIfAbsent(clusterName, k -> new ArrayList()).add(indexName);
                }
                continue;
            }
            perClusterIndices.computeIfAbsent(LOCAL_CLUSTER_GROUP_KEY, k -> new ArrayList()).add(index);
        }
        ArrayList<String> excludeFailed = new ArrayList<String>();
        for (String exclude : clustersToRemove) {
            List removed = (List)perClusterIndices.remove(exclude);
            if (removed != null) continue;
            excludeFailed.add(exclude);
        }
        if (excludeFailed.size() > 0) {
            String warning = Strings.format((String)"Attempt to exclude cluster%s %s failed as %s not included in the list of clusters to be included: %s. Input: [%s]", (Object[])new Object[]{excludeFailed.size() == 1 ? LOCAL_CLUSTER_GROUP_KEY : "s", excludeFailed, excludeFailed.size() == 1 ? "it is" : "they are", perClusterIndices.keySet().stream().map(s -> s.equals(LOCAL_CLUSTER_GROUP_KEY) ? "(local)" : s).collect(Collectors.toList()), String.join((CharSequence)",", requestIndices)});
            throw new IllegalArgumentException(warning);
        }
        if (clustersToRemove.size() > 0 && perClusterIndices.size() == 0) {
            throw new IllegalArgumentException("The '-' exclusions in the index expression list excludes all indexes. Nothing to search. Input: [" + String.join((CharSequence)",", requestIndices) + "]");
        }
        return perClusterIndices;
    }

    void validateAndUpdateRemoteCluster(String clusterAlias, Settings settings) {
        if (LOCAL_CLUSTER_GROUP_KEY.equals(clusterAlias)) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        this.updateRemoteCluster(clusterAlias, settings);
    }

    protected abstract void updateRemoteCluster(String var1, Settings var2);

    public void listenForUpdates(ClusterSettings clusterSettings) {
        List<Setting.AffixSetting<?>> remoteClusterSettings = List.of(RemoteClusterService.REMOTE_CLUSTER_COMPRESS, RemoteClusterService.REMOTE_CLUSTER_PING_SCHEDULE, RemoteConnectionStrategy.REMOTE_CONNECTION_MODE, SniffConnectionStrategy.REMOTE_CLUSTERS_PROXY, SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS, SniffConnectionStrategy.REMOTE_NODE_CONNECTIONS, ProxyConnectionStrategy.PROXY_ADDRESS, ProxyConnectionStrategy.REMOTE_SOCKET_CONNECTIONS, ProxyConnectionStrategy.SERVER_NAME);
        clusterSettings.addAffixGroupUpdateConsumer(remoteClusterSettings, this::validateAndUpdateRemoteCluster);
    }

    public static String buildRemoteIndexName(String clusterAlias, String indexName) {
        return clusterAlias == null || LOCAL_CLUSTER_GROUP_KEY.equals(clusterAlias) ? indexName : clusterAlias + ":" + indexName;
    }
}

