/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.index.fieldvisitor.FieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.search.internal.FilterFieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.search.internal.FilterStoredFieldVisitor;

public class FieldUsageTrackingDirectoryReader
extends FilterDirectoryReader {
    private final FieldUsageNotifier notifier;

    public FieldUsageTrackingDirectoryReader(DirectoryReader in, final FieldUsageNotifier notifier) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(LeafReader reader) {
                return new FieldUsageTrackingLeafReader(reader, notifier);
            }
        });
        this.notifier = notifier;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new FieldUsageTrackingDirectoryReader(in, this.notifier);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public static interface FieldUsageNotifier {
        public void onTermsUsed(String var1);

        public void onPostingsUsed(String var1);

        public void onTermFrequenciesUsed(String var1);

        public void onPositionsUsed(String var1);

        public void onOffsetsUsed(String var1);

        public void onDocValuesUsed(String var1);

        public void onStoredFieldsUsed(String var1);

        public void onNormsUsed(String var1);

        public void onPayloadsUsed(String var1);

        public void onPointsUsed(String var1);

        public void onTermVectorsUsed(String var1);

        public void onKnnVectorsUsed(String var1);
    }

    static final class FieldUsageTrackingLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final FieldUsageNotifier notifier;

        FieldUsageTrackingLeafReader(LeafReader in, FieldUsageNotifier notifier) {
            super(in);
            this.notifier = notifier;
        }

        public Fields getTermVectors(int docID) throws IOException {
            Object f = super.getTermVectors(docID);
            if (f != null) {
                f = new FieldUsageTrackingTermVectorFields((Fields)f);
            }
            return f;
        }

        public TermVectors termVectors() throws IOException {
            final TermVectors termVectors = super.termVectors();
            return new TermVectors(){

                public Fields get(int doc) throws IOException {
                    Object f = termVectors.get(doc);
                    if (f != null) {
                        f = new FieldUsageTrackingTermVectorFields((Fields)f);
                    }
                    return f;
                }
            };
        }

        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = super.getPointValues(field);
            if (pointValues != null) {
                this.notifier.onPointsUsed(field);
            }
            return pointValues;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            this.storedFields().document(docID, visitor);
        }

        public StoredFields storedFields() throws IOException {
            final StoredFields storedFields = super.storedFields();
            return new StoredFields(){

                public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                    if (visitor instanceof FieldNamesProvidingStoredFieldsVisitor) {
                        storedFields.document(docID, (StoredFieldVisitor)new FieldUsageFieldsVisitor((FieldNamesProvidingStoredFieldsVisitor)visitor));
                    } else {
                        storedFields.document(docID, (StoredFieldVisitor)new FieldUsageStoredFieldVisitor(visitor));
                    }
                }
            };
        }

        public Terms terms(String field) throws IOException {
            Object terms = super.terms(field);
            if (terms != null) {
                this.notifier.onTermsUsed(field);
                if (!(terms instanceof CompletionTerms)) {
                    terms = new FieldUsageTrackingTerms(field, (Terms)terms);
                }
            }
            return terms;
        }

        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            BinaryDocValues binaryDocValues = super.getBinaryDocValues(field);
            if (binaryDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return binaryDocValues;
        }

        public SortedDocValues getSortedDocValues(String field) throws IOException {
            SortedDocValues sortedDocValues = super.getSortedDocValues(field);
            if (sortedDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return sortedDocValues;
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            SortedNumericDocValues sortedNumericDocValues = super.getSortedNumericDocValues(field);
            if (sortedNumericDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return sortedNumericDocValues;
        }

        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            SortedSetDocValues sortedSetDocValues = super.getSortedSetDocValues(field);
            if (sortedSetDocValues != null) {
                this.notifier.onDocValuesUsed(field);
            }
            return sortedSetDocValues;
        }

        public NumericDocValues getNormValues(String field) throws IOException {
            NumericDocValues numericDocValues = super.getNormValues(field);
            if (numericDocValues != null) {
                this.notifier.onNormsUsed(field);
            }
            return numericDocValues;
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            FloatVectorValues vectorValues = super.getFloatVectorValues(field);
            if (vectorValues != null) {
                this.notifier.onKnnVectorsUsed(field);
            }
            return vectorValues;
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            ByteVectorValues vectorValues = super.getByteVectorValues(field);
            if (vectorValues != null) {
                this.notifier.onKnnVectorsUsed(field);
            }
            return vectorValues;
        }

        public void searchNearestVectors(String field, byte[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            super.searchNearestVectors(field, target, collector, acceptDocs);
            if (collector.visitedCount() > 0L) {
                this.notifier.onKnnVectorsUsed(field);
            }
        }

        public void searchNearestVectors(String field, float[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            super.searchNearestVectors(field, target, collector, acceptDocs);
            if (collector.visitedCount() > 0L) {
                this.notifier.onKnnVectorsUsed(field);
            }
        }

        public String toString() {
            return "FieldUsageTrackingLeafReader(reader=" + this.in + ")";
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return new FieldUsageTrackingStoredFieldsReader(reader);
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        private class FieldUsageTrackingTermVectorFields
        extends FilterLeafReader.FilterFields {
            FieldUsageTrackingTermVectorFields(Fields in) {
                super(in);
            }

            public Terms terms(String field) throws IOException {
                Terms terms = super.terms(field);
                if (terms != null) {
                    FieldUsageTrackingLeafReader.this.notifier.onTermVectorsUsed(field);
                }
                return terms;
            }
        }

        class FieldUsageTrackingTerms
        extends FilterLeafReader.FilterTerms {
            private final String field;

            FieldUsageTrackingTerms(String field, Terms in) {
                super(in);
                this.field = field;
            }

            public TermsEnum iterator() throws IOException {
                Object termsEnum = this.in.iterator();
                if (termsEnum != null) {
                    termsEnum = new FieldUsageTrackingTermsEnum(this.field, (TermsEnum)termsEnum);
                }
                return termsEnum;
            }

            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                Object termsEnum = this.in.intersect(compiled, startTerm);
                if (termsEnum != null) {
                    termsEnum = new FieldUsageTrackingTermsEnum(this.field, (TermsEnum)termsEnum);
                }
                return termsEnum;
            }

            public long getSumTotalTermFreq() throws IOException {
                long totalTermFreq = super.getSumTotalTermFreq();
                FieldUsageTrackingLeafReader.this.notifier.onTermFrequenciesUsed(this.field);
                return totalTermFreq;
            }

            public BytesRef getMin() throws IOException {
                return this.in.getMin();
            }

            public BytesRef getMax() throws IOException {
                return this.in.getMax();
            }
        }

        class FieldUsageTrackingStoredFieldsReader
        extends StoredFieldsReader {
            final StoredFieldsReader reader;

            FieldUsageTrackingStoredFieldsReader(StoredFieldsReader reader) {
                this.reader = reader;
            }

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                this.reader.document(docID, (StoredFieldVisitor)new FieldUsageStoredFieldVisitor(visitor));
            }

            public StoredFieldsReader clone() {
                return new FieldUsageTrackingStoredFieldsReader(this.reader.clone());
            }

            public StoredFieldsReader getMergeInstance() {
                return new FieldUsageTrackingStoredFieldsReader(this.reader.getMergeInstance());
            }

            public void checkIntegrity() throws IOException {
                this.reader.checkIntegrity();
            }

            public void close() throws IOException {
                this.reader.close();
            }
        }

        private class FieldUsageFieldsVisitor
        extends FilterFieldNamesProvidingStoredFieldsVisitor {
            FieldUsageFieldsVisitor(FieldNamesProvidingStoredFieldsVisitor visitor) {
                super(visitor);
            }

            @Override
            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                StoredFieldVisitor.Status status = super.needsField(fieldInfo);
                if (status == StoredFieldVisitor.Status.YES) {
                    FieldUsageTrackingLeafReader.this.notifier.onStoredFieldsUsed(fieldInfo.name);
                }
                return status;
            }
        }

        private class FieldUsageStoredFieldVisitor
        extends FilterStoredFieldVisitor {
            FieldUsageStoredFieldVisitor(StoredFieldVisitor visitor) {
                super(visitor);
            }

            @Override
            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                StoredFieldVisitor.Status status = super.needsField(fieldInfo);
                if (status == StoredFieldVisitor.Status.YES) {
                    FieldUsageTrackingLeafReader.this.notifier.onStoredFieldsUsed(fieldInfo.name);
                }
                return status;
            }
        }

        private class FieldUsageTrackingTermsEnum
        extends FilterLeafReader.FilterTermsEnum {
            private final String field;

            FieldUsageTrackingTermsEnum(String field, TermsEnum in) {
                super(in);
                this.field = field;
            }

            public long totalTermFreq() throws IOException {
                long totalTermFreq = super.totalTermFreq();
                FieldUsageTrackingLeafReader.this.notifier.onTermFrequenciesUsed(this.field);
                return totalTermFreq;
            }

            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                PostingsEnum postingsEnum = super.postings(reuse, flags);
                if (postingsEnum != null) {
                    FieldUsageTrackingLeafReader.this.notifier.onPostingsUsed(this.field);
                    this.checkPostingsFlags(flags);
                }
                return postingsEnum;
            }

            public ImpactsEnum impacts(int flags) throws IOException {
                ImpactsEnum impactsEnum = super.impacts(flags);
                if (impactsEnum != null) {
                    FieldUsageTrackingLeafReader.this.notifier.onPostingsUsed(this.field);
                    this.checkPostingsFlags(flags);
                }
                return impactsEnum;
            }

            private void checkPostingsFlags(int flags) {
                if (PostingsEnum.featureRequested((int)flags, (short)8)) {
                    FieldUsageTrackingLeafReader.this.notifier.onTermFrequenciesUsed(this.field);
                }
                if (PostingsEnum.featureRequested((int)flags, (short)24)) {
                    FieldUsageTrackingLeafReader.this.notifier.onPositionsUsed(this.field);
                }
                if (PostingsEnum.featureRequested((int)flags, (short)56)) {
                    FieldUsageTrackingLeafReader.this.notifier.onOffsetsUsed(this.field);
                }
                if (PostingsEnum.featureRequested((int)flags, (short)88)) {
                    FieldUsageTrackingLeafReader.this.notifier.onPayloadsUsed(this.field);
                }
            }
        }
    }
}

