/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class MedianAbsoluteDeviationAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat format;
    private final double compression;
    private final TDigestExecutionHint executionHint;
    private ObjectArray<TDigestState> valueSketches;

    MedianAbsoluteDeviationAggregator(String name, ValuesSourceConfig config, DocValueFormat format, AggregationContext context, Aggregator parent, Map<String, Object> metadata, double compression, TDigestExecutionHint executionHint) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = (ValuesSource.Numeric)config.getValuesSource();
        this.format = Objects.requireNonNull(format);
        this.compression = compression;
        this.executionHint = executionHint;
        this.valueSketches = context.bigArrays().newObjectArray(1L);
    }

    private boolean hasDataForBucket(long bucketOrd) {
        return bucketOrd < this.valueSketches.size() && this.valueSketches.get(bucketOrd) != null;
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.hasDataForBucket(owningBucketOrd)) {
            return InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation(this.valueSketches.get(owningBucketOrd));
        }
        return Double.NaN;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                MedianAbsoluteDeviationAggregator.this.valueSketches = MedianAbsoluteDeviationAggregator.this.bigArrays().grow(MedianAbsoluteDeviationAggregator.this.valueSketches, bucket + 1L);
                TDigestState valueSketch = MedianAbsoluteDeviationAggregator.this.valueSketches.get(bucket);
                if (valueSketch == null) {
                    valueSketch = TDigestState.create(MedianAbsoluteDeviationAggregator.this.compression, MedianAbsoluteDeviationAggregator.this.executionHint);
                    MedianAbsoluteDeviationAggregator.this.valueSketches.set(bucket, valueSketch);
                }
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        double value = values.nextValue();
                        valueSketch.add(value);
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        if (this.hasDataForBucket(bucket)) {
            TDigestState valueSketch = this.valueSketches.get(bucket);
            return new InternalMedianAbsoluteDeviation(this.name, this.metadata(), this.format, valueSketch);
        }
        return this.buildEmptyAggregation();
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalMedianAbsoluteDeviation.empty(this.name, this.metadata(), this.format, this.compression, this.executionHint);
    }

    @Override
    public void doClose() {
        Releasables.close(this.valueSketches);
    }
}

