/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.elasticsearch.lucene.search.uhighlight.LimitedOffsetsEnum;

class CustomFieldHighlighter
extends FieldHighlighter {
    private static final Passage[] EMPTY_PASSAGE = new Passage[0];
    private final Locale breakIteratorLocale;
    private final int noMatchSize;
    private String fieldValue;
    private final Integer queryMaxAnalyzedOffset;

    CustomFieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, Locale breakIteratorLocale, BreakIterator breakIterator, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages, PassageFormatter passageFormatter, int noMatchSize, Integer queryMaxAnalyzedOffset) {
        super(field, fieldOffsetStrategy, breakIterator, passageScorer, maxPassages, maxNoHighlightPassages, passageFormatter);
        this.breakIteratorLocale = breakIteratorLocale;
        this.noMatchSize = noMatchSize;
        this.queryMaxAnalyzedOffset = queryMaxAnalyzedOffset;
    }

    FieldOffsetStrategy getFieldOffsetStrategy() {
        return this.fieldOffsetStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object highlightFieldForDoc(LeafReader reader, int docId, String content) throws IOException {
        this.fieldValue = content;
        try {
            Object object = super.highlightFieldForDoc(reader, docId, content);
            return object;
        }
        finally {
            this.fieldValue = null;
        }
    }

    protected Passage[] getSummaryPassagesNoHighlight(int maxPassages) {
        if (this.noMatchSize > 0) {
            int pos;
            for (pos = 0; pos < this.fieldValue.length() && this.fieldValue.charAt(pos) == '\u0000'; ++pos) {
            }
            if (pos < this.fieldValue.length()) {
                int end = this.fieldValue.indexOf(0, pos);
                if (end == -1) {
                    end = this.fieldValue.length();
                }
                if (this.noMatchSize + pos < end) {
                    BreakIterator bi = BreakIterator.getWordInstance(this.breakIteratorLocale);
                    bi.setText(this.fieldValue);
                    end = bi.following(this.noMatchSize + pos);
                    if (end == -1) {
                        end = this.fieldValue.length();
                    }
                }
                Passage passage = new Passage();
                passage.setScore(Float.NaN);
                passage.setStartOffset(pos);
                passage.setEndOffset(end);
                return new Passage[]{passage};
            }
        }
        return EMPTY_PASSAGE;
    }

    protected Passage[] highlightOffsetsEnums(OffsetsEnum off) throws IOException {
        if (this.queryMaxAnalyzedOffset != null) {
            off = new LimitedOffsetsEnum(off, this.queryMaxAnalyzedOffset);
        }
        return super.highlightOffsetsEnums(off);
    }
}

