/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;

public class MapperBuilderContext {
    private final String path;
    private final boolean isSourceSynthetic;
    private final boolean isDataStream;
    private final boolean parentObjectContainsDimensions;
    private final ObjectMapper.Dynamic dynamic;
    private final MapperService.MergeReason mergeReason;

    public static MapperBuilderContext root(boolean isSourceSynthetic, boolean isDataStream) {
        return MapperBuilderContext.root(isSourceSynthetic, isDataStream, MapperService.MergeReason.MAPPING_UPDATE);
    }

    public static MapperBuilderContext root(boolean isSourceSynthetic, boolean isDataStream, MapperService.MergeReason mergeReason) {
        return new MapperBuilderContext(null, isSourceSynthetic, isDataStream, false, ObjectMapper.Defaults.DYNAMIC, mergeReason);
    }

    MapperBuilderContext(String path) {
        this(path, false, false, false, ObjectMapper.Defaults.DYNAMIC, MapperService.MergeReason.MAPPING_UPDATE);
    }

    MapperBuilderContext(String path, boolean isSourceSynthetic, boolean isDataStream, boolean parentObjectContainsDimensions, ObjectMapper.Dynamic dynamic, MapperService.MergeReason mergeReason) {
        Objects.requireNonNull(dynamic, "dynamic must not be null");
        this.path = path;
        this.isSourceSynthetic = isSourceSynthetic;
        this.isDataStream = isDataStream;
        this.parentObjectContainsDimensions = parentObjectContainsDimensions;
        this.dynamic = dynamic;
        this.mergeReason = mergeReason;
    }

    public MapperBuilderContext createChildContext(String name, @Nullable ObjectMapper.Dynamic dynamic) {
        return this.createChildContext(name, this.parentObjectContainsDimensions, dynamic);
    }

    public MapperBuilderContext createChildContext(String name, boolean parentObjectContainsDimensions, @Nullable ObjectMapper.Dynamic dynamic) {
        return new MapperBuilderContext(this.buildFullName(name), this.isSourceSynthetic, this.isDataStream, parentObjectContainsDimensions, this.getDynamic(dynamic), this.mergeReason);
    }

    protected ObjectMapper.Dynamic getDynamic(@Nullable ObjectMapper.Dynamic dynamic) {
        return dynamic == null ? this.dynamic : dynamic;
    }

    public String buildFullName(String name) {
        if (Strings.isEmpty(this.path)) {
            return name;
        }
        return this.path + "." + name;
    }

    public boolean isSourceSynthetic() {
        return this.isSourceSynthetic;
    }

    public boolean isDataStream() {
        return this.isDataStream;
    }

    public boolean parentObjectContainsDimensions() {
        return this.parentObjectContainsDimensions;
    }

    public ObjectMapper.Dynamic getDynamic() {
        return this.dynamic;
    }

    public MapperService.MergeReason getMergeReason() {
        return this.mergeReason;
    }
}

