/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.TimestampBounds;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class DataStreamTimestampFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_data_stream_timestamp";
    public static final String DEFAULT_PATH = "@timestamp";
    public static final DataStreamTimestampFieldMapper ENABLED_INSTANCE = new DataStreamTimestampFieldMapper(true);
    private static final DataStreamTimestampFieldMapper DISABLED_INSTANCE = new DataStreamTimestampFieldMapper(false);
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> DISABLED_INSTANCE, c -> new Builder());
    private final boolean enabled;

    private static DataStreamTimestampFieldMapper toType(FieldMapper in) {
        return (DataStreamTimestampFieldMapper)in;
    }

    private DataStreamTimestampFieldMapper(boolean enabled) {
        super(TimestampFieldType.INSTANCE);
        this.enabled = enabled;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (!this.enabled) {
            return;
        }
        Mapper mapper = lookup.getMapper(DEFAULT_PATH);
        if (mapper == null) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] does not exist");
        }
        if (!"date".equals(mapper.typeName()) && !"date_nanos".equals(mapper.typeName())) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] is of type [" + mapper.typeName() + "], but [date,date_nanos] is expected");
        }
        DateFieldMapper dateFieldMapper = (DateFieldMapper)mapper;
        if (!dateFieldMapper.fieldType().isIndexed()) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] is not indexed");
        }
        if (!dateFieldMapper.fieldType().hasDocValues()) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] doesn't have doc values");
        }
        if (dateFieldMapper.getNullValue() != null) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] has disallowed [null_value] attribute specified");
        }
        if (dateFieldMapper.ignoreMalformed()) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] has disallowed [ignore_malformed] attribute specified");
        }
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            dateFieldMapper.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            Map configuredSettings = (Map)XContentHelper.convertToMap(BytesReference.bytes(builder), false, XContentType.JSON).v2();
            configuredSettings = (Map)configuredSettings.values().iterator().next();
            configuredSettings.remove("type");
            configuredSettings.remove("meta");
            configuredSettings.remove("format");
            Object value = configuredSettings.remove("ignore_malformed");
            assert (value == null || Boolean.FALSE.equals(value));
            if (!configuredSettings.isEmpty()) {
                throw new IllegalArgumentException("data stream timestamp field [@timestamp] has disallowed attributes: " + configuredSettings.keySet());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void postParse(DocumentParserContext context) throws IOException {
        if (!this.enabled) {
            return;
        }
        boolean foundFsTimestampField = false;
        IndexableField first = null;
        List<IndexableField> fields = context.rootDoc().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            IndexableField indexableField = fields.get(i);
            if (!DEFAULT_PATH.equals(indexableField.name())) continue;
            if (first == null) {
                first = indexableField;
            }
            if (indexableField.fieldType().docValuesType() != DocValuesType.SORTED_NUMERIC) continue;
            if (foundFsTimestampField) {
                throw new IllegalArgumentException("data stream timestamp field [@timestamp] encountered multiple values");
            }
            foundFsTimestampField = true;
        }
        if (first == null) {
            throw new IllegalArgumentException("data stream timestamp field [@timestamp] is missing");
        }
        IndexMode indexMode = context.indexSettings().getMode();
        if (indexMode.shouldValidateTimestamp()) {
            TimestampBounds bounds = context.indexSettings().getTimestampBounds();
            DataStreamTimestampFieldMapper.validateTimestamp(bounds, first, context);
        }
    }

    private static void validateTimestamp(TimestampBounds bounds, IndexableField field, DocumentParserContext context) {
        DateFieldMapper.Resolution resolution;
        long originValue;
        long value = originValue = field.numericValue().longValue();
        if (context.mappingLookup().getMapper(DEFAULT_PATH).typeName().equals("date_nanos")) {
            resolution = DateFieldMapper.Resolution.NANOSECONDS;
            value /= TimeValue.NSEC_PER_MSEC;
        } else {
            resolution = DateFieldMapper.Resolution.MILLISECONDS;
        }
        long startTime = bounds.startTime();
        if (value < startTime) {
            throw new IllegalArgumentException("time series index @timestamp value [" + resolution.toInstant(originValue) + "] must be larger than " + Instant.ofEpochMilli(startTime));
        }
        long endTime = bounds.endTime();
        if (value >= endTime) {
            throw new IllegalArgumentException("time series index @timestamp value [" + resolution.toInstant(originValue) + "] must be smaller than " + Instant.ofEpochMilli(endTime));
        }
    }

    @Override
    protected String contentType() {
        return NAME;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    public static final class TimestampFieldType
    extends MappedFieldType {
        static final TimestampFieldType INSTANCE = new TimestampFieldType();

        private TimestampFieldType() {
            super(DataStreamTimestampFieldMapper.NAME, false, false, false, TextSearchInfo.NONE, Map.of());
        }

        @Override
        public String typeName() {
            return DataStreamTimestampFieldMapper.NAME;
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support term queries");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support exists queries");
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> enabled = FieldMapper.Parameter.boolParam("enabled", true, m -> DataStreamTimestampFieldMapper.toType((FieldMapper)m).enabled, false).setMergeValidator((previous, current, conflicts) -> previous == current || previous == false && current != false);

        public Builder() {
            super(DataStreamTimestampFieldMapper.NAME);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.enabled};
        }

        @Override
        public MetadataFieldMapper build() {
            return this.enabled.getValue() != false ? ENABLED_INSTANCE : DISABLED_INSTANCE;
        }
    }
}

