/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.util.function.Supplier;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class LoggingDeprecationHandler
implements DeprecationHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ParseField.class);
    public static final LoggingDeprecationHandler INSTANCE = new LoggingDeprecationHandler();
    public static final XContentParserConfiguration XCONTENT_PARSER_CONFIG = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)INSTANCE);

    private LoggingDeprecationHandler() {
    }

    public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName) {
        this.logRenamedField(parserName, location, oldName, currentName, false);
    }

    public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName) {
        this.logReplacedField(parserName, location, oldName, replacedName, false);
    }

    public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName) {
        this.logRemovedField(parserName, location, removedName, false);
    }

    public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName, boolean isCompatibleDeprecation) {
        String prefix = LoggingDeprecationHandler.parserLocation(parserName, location);
        LoggingDeprecationHandler.log(isCompatibleDeprecation, "{}Deprecated field [{}] used, expected [{}] instead", new Object[]{prefix, oldName, currentName}, oldName);
    }

    public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName, boolean isCompatibleDeprecation) {
        String prefix = LoggingDeprecationHandler.parserLocation(parserName, location);
        LoggingDeprecationHandler.log(isCompatibleDeprecation, "{}Deprecated field [{}] used, replaced by [{}]", new Object[]{prefix, oldName, replacedName}, oldName);
    }

    public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName, boolean isCompatibleDeprecation) {
        String prefix = LoggingDeprecationHandler.parserLocation(parserName, location);
        LoggingDeprecationHandler.log(isCompatibleDeprecation, "{}Deprecated field [{}] used, this field is unused and will be removed entirely", new Object[]{prefix, removedName}, removedName);
    }

    private static String parserLocation(String parserName, Supplier<XContentLocation> location) {
        return parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
    }

    private static void log(boolean isCompatibleDeprecation, String message, Object[] params, String fieldName) {
        if (isCompatibleDeprecation) {
            deprecationLogger.compatibleCritical("deprecated_field_" + fieldName, message, params);
        } else {
            deprecationLogger.warn(DeprecationCategory.API, "deprecated_field_" + fieldName, message, params);
        }
    }
}

