/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.util.concurrent.atomic.LongAdder;

public class HandlingTimeTracker {
    public static final int BUCKET_COUNT = HandlingTimeTracker.getBucketUpperBounds().length + 1;
    private static final long LAST_BUCKET_LOWER_BOUND = HandlingTimeTracker.getBucketUpperBounds()[BUCKET_COUNT - 2];
    private final LongAdder[] buckets = new LongAdder[BUCKET_COUNT];

    public static int[] getBucketUpperBounds() {
        int[] bounds = new int[17];
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = 1 << i;
        }
        return bounds;
    }

    private static int getBucket(long handlingTimeMillis) {
        if (handlingTimeMillis <= 0L) {
            return 0;
        }
        if (LAST_BUCKET_LOWER_BOUND <= handlingTimeMillis) {
            return BUCKET_COUNT - 1;
        }
        return 64 - Long.numberOfLeadingZeros(handlingTimeMillis);
    }

    public HandlingTimeTracker() {
        for (int i = 0; i < BUCKET_COUNT; ++i) {
            this.buckets[i] = new LongAdder();
        }
    }

    public void addHandlingTime(long handlingTimeMillis) {
        this.buckets[HandlingTimeTracker.getBucket(handlingTimeMillis)].increment();
    }

    public long[] getHistogram() {
        long[] histogram = new long[BUCKET_COUNT];
        for (int i = 0; i < BUCKET_COUNT; ++i) {
            histogram[i] = this.buckets[i].longValue();
        }
        return histogram;
    }
}

