/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.internal;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.FilterClient;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportResponse;

public class ParentTaskAssigningClient
extends FilterClient {
    private final TaskId parentTask;

    public ParentTaskAssigningClient(Client in, TaskId parentTask) {
        super(in);
        this.parentTask = parentTask;
    }

    public ParentTaskAssigningClient(Client in, DiscoveryNode localNode, Task parentTask) {
        this(in, new TaskId(localNode.getId(), parentTask.getId()));
    }

    public TaskId getParentTask() {
        return this.parentTask;
    }

    public Client unwrap() {
        return this.in();
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        request.setParentTask(this.parentTask);
        super.doExecute(action, request, listener);
    }

    @Override
    public RemoteClusterClient getRemoteClusterClient(String clusterAlias, Executor responseExecutor, RemoteClusterService.DisconnectedStrategy disconnectedStrategy) {
        final RemoteClusterClient delegate = super.getRemoteClusterClient(clusterAlias, responseExecutor, disconnectedStrategy);
        return new RemoteClusterClient(){

            @Override
            public <Request extends ActionRequest, Response extends TransportResponse> void execute(RemoteClusterActionType<Response> action, Request request, ActionListener<Response> listener) {
                request.setParentTask(ParentTaskAssigningClient.this.parentTask);
                delegate.execute(action, request, listener);
            }
        };
    }
}

