/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.instance;

import org.elasticsearch.action.ActionRequestLazyBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;

public abstract class InstanceShardOperationRequestBuilder<Request extends InstanceShardOperationRequest<Request>, Response extends ActionResponse, RequestBuilder extends InstanceShardOperationRequestBuilder<Request, Response, RequestBuilder>>
extends ActionRequestLazyBuilder<Request, Response> {
    private String index;
    private TimeValue timeout;

    protected InstanceShardOperationRequestBuilder(ElasticsearchClient client, ActionType<Response> action) {
        super(client, action);
    }

    public RequestBuilder setIndex(String index) {
        this.index = index;
        return (RequestBuilder)this;
    }

    protected String getIndex() {
        return this.index;
    }

    public RequestBuilder setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return (RequestBuilder)this;
    }

    public RequestBuilder setTimeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout"));
        return (RequestBuilder)this;
    }

    protected void apply(Request request) {
        if (this.index != null) {
            ((InstanceShardOperationRequest)request).index(this.index);
        }
        if (this.timeout != null) {
            ((InstanceShardOperationRequest)request).timeout(this.timeout);
        }
    }
}

