/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;

public abstract class TransportAction<Request extends ActionRequest, Response extends ActionResponse> {
    public final String actionName;
    private final ActionFilter[] filters;
    protected final TaskManager taskManager;
    @Deprecated
    protected Logger logger = LogManager.getLogger(this.getClass());

    protected TransportAction(String actionName, ActionFilters actionFilters, TaskManager taskManager) {
        this.actionName = actionName;
        this.filters = actionFilters.filters();
        this.taskManager = taskManager;
    }

    public final void execute(Task task, Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException;
        try {
            validationException = ((ActionRequest)request).validate();
        }
        catch (Exception e) {
            assert (false) : new AssertionError("validating of request [" + request + "] threw exception", e);
            this.logger.warn("validating of request [" + request + "] threw exception", (Throwable)e);
            listener.onFailure(e);
            return;
        }
        if (validationException != null) {
            listener.onFailure(validationException);
            return;
        }
        if (task != null && ((ActionRequest)request).getShouldStoreResult()) {
            listener = new TaskResultStoringActionListener<Response>(this.taskManager, task, listener);
        }
        request.mustIncRef();
        Releasable releaseRef = Releasables.releaseOnce(() -> request.decRef());
        RequestFilterChain<Request, Response> requestFilterChain = new RequestFilterChain<Request, Response>(this, this.logger, releaseRef);
        requestFilterChain.proceed(task, this.actionName, request, ActionListener.runBefore(listener, () -> ((Releasable)releaseRef).close()));
    }

    protected abstract void doExecute(Task var1, Request var2, ActionListener<Response> var3);

    public static <T> T localOnly() {
        assert (false) : "local-only action";
        throw new UnsupportedOperationException("local-only action");
    }

    private static class TaskResultStoringActionListener<Response extends ActionResponse>
    implements ActionListener<Response> {
        private final ActionListener<Response> delegate;
        private final Task task;
        private final TaskManager taskManager;

        private TaskResultStoringActionListener(TaskManager taskManager, Task task, ActionListener<Response> delegate) {
            this.taskManager = taskManager;
            this.task = task;
            this.delegate = delegate;
        }

        @Override
        public void onResponse(Response response) {
            ActionListener.run(this.delegate, l -> this.taskManager.storeResult(this.task, response, l));
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.taskManager.storeResult(this.task, e, this.delegate);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.delegate.onFailure(inner);
            }
        }
    }

    private static class RequestFilterChain<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain<Request, Response> {
        private final TransportAction<Request, Response> action;
        private final AtomicInteger index = new AtomicInteger();
        private final Logger logger;
        private final Releasable releaseRef;

        private RequestFilterChain(TransportAction<Request, Response> action, Logger logger, Releasable releaseRef) {
            this.action = action;
            this.logger = logger;
            this.releaseRef = releaseRef;
        }

        @Override
        public void proceed(Task task, String actionName, Request request, ActionListener<Response> listener) {
            block10: {
                int i = this.index.getAndIncrement();
                try {
                    if (i < this.action.filters.length) {
                        this.action.filters[i].apply(task, actionName, request, listener, this);
                        break block10;
                    }
                    if (i == this.action.filters.length) {
                        try (Releasable releasable = this.releaseRef;){
                            this.action.doExecute(task, request, listener);
                            break block10;
                        }
                    }
                    listener.onFailure(new IllegalStateException("proceed was called too many times"));
                }
                catch (Exception e) {
                    this.logger.trace("Error during transport action execution.", (Throwable)e);
                    listener.onFailure(e);
                }
            }
        }
    }
}

