/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollAsyncAction;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.transport.Transport;

final class SearchScrollQueryThenFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQuerySearchResult> {
    private final SearchTask task;
    private final AtomicArray<FetchSearchResult> fetchResults;
    private final AtomicArray<QuerySearchResult> queryResults;

    SearchScrollQueryThenFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, request, searchTransportService);
        this.task = task;
        this.fetchResults = new AtomicArray(scrollId.getContext().length);
        this.queryResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQuerySearchResult result) {
        this.queryResults.setOnce(shardId, result.queryResult());
    }

    @Override
    protected void executeInitialPhase(Transport.Connection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQuerySearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollQuery(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(final BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return new SearchPhase("fetch"){

            public void run() {
                SearchPhaseController.ReducedQueryPhase reducedQueryPhase = SearchPhaseController.reducedScrollQueryPhase(SearchScrollQueryThenFetchAsyncAction.this.queryResults.asList());
                ScoreDoc[] scoreDocs = reducedQueryPhase.sortedTopDocs().scoreDocs();
                if (scoreDocs.length == 0) {
                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                    return;
                }
                this.doRun(scoreDocs, reducedQueryPhase);
            }

            private void doRun(ScoreDoc[] scoreDocs, final SearchPhaseController.ReducedQueryPhase reducedQueryPhase) {
                List<Integer>[] docIdsToLoad = SearchPhaseController.fillDocIdsToLoad(SearchScrollQueryThenFetchAsyncAction.this.queryResults.length(), scoreDocs);
                ScoreDoc[] lastEmittedDocPerShard = SearchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.queryResults.length());
                final CountDown counter = new CountDown(docIdsToLoad.length);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    int index = i;
                    List<Integer> docIds = docIdsToLoad[index];
                    if (docIds != null) {
                        final QuerySearchResult querySearchResult = SearchScrollQueryThenFetchAsyncAction.this.queryResults.get(index);
                        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[index];
                        ShardFetchRequest shardFetchRequest = new ShardFetchRequest(querySearchResult.getContextId(), docIds, lastEmittedDoc);
                        SearchShardTarget searchShardTarget = querySearchResult.getSearchShardTarget();
                        DiscoveryNode node = (DiscoveryNode)clusterNodeLookup.apply(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                        assert (node != null) : "target node is null in secondary phase";
                        Transport.Connection connection = SearchScrollQueryThenFetchAsyncAction.this.getConnection(searchShardTarget.getClusterAlias(), node);
                        SearchScrollQueryThenFetchAsyncAction.this.searchTransportService.sendExecuteFetchScroll(connection, shardFetchRequest, SearchScrollQueryThenFetchAsyncAction.this.task, new SearchActionListener<FetchSearchResult>(querySearchResult.getSearchShardTarget(), index){

                            @Override
                            protected void innerOnResponse(FetchSearchResult response) {
                                SearchScrollQueryThenFetchAsyncAction.this.fetchResults.setOnce(response.getShardIndex(), response);
                                response.incRef();
                                SearchScrollQueryThenFetchAsyncAction.this.consumeResponse(counter, reducedQueryPhase);
                            }

                            @Override
                            public void onFailure(Exception t) {
                                SearchScrollQueryThenFetchAsyncAction.this.onShardFailure(this.getName(), counter, querySearchResult.getContextId(), t, querySearchResult.getSearchShardTarget(), () -> SearchScrollQueryThenFetchAsyncAction.this.sendResponsePhase(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults));
                            }
                        });
                        continue;
                    }
                    SearchScrollQueryThenFetchAsyncAction.this.consumeResponse(counter, reducedQueryPhase);
                }
            }
        };
    }

    private void consumeResponse(CountDown counter, SearchPhaseController.ReducedQueryPhase reducedQueryPhase) {
        if (counter.countDown()) {
            this.sendResponse(reducedQueryPhase, this.fetchResults);
            for (FetchSearchResult fetchSearchResult : this.fetchResults.asList()) {
                fetchSearchResult.decRef();
            }
        }
    }
}

