/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;

public final class SearchContextId {
    private final Map<ShardId, SearchContextIdForNode> shards;
    private final Map<String, AliasFilter> aliasFilter;
    private final transient Set<ShardSearchContextId> contextIds;

    SearchContextId(Map<ShardId, SearchContextIdForNode> shards, Map<String, AliasFilter> aliasFilter) {
        this.shards = shards;
        this.aliasFilter = aliasFilter;
        this.contextIds = shards.values().stream().map(SearchContextIdForNode::getSearchContextId).collect(Collectors.toSet());
    }

    public Map<ShardId, SearchContextIdForNode> shards() {
        return this.shards;
    }

    public Map<String, AliasFilter> aliasFilter() {
        return this.aliasFilter;
    }

    public boolean contains(ShardSearchContextId contextId) {
        return this.contextIds.contains(contextId);
    }

    public static String encode(List<SearchPhaseResult> searchPhaseResults, Map<String, AliasFilter> aliasFilter, TransportVersion version) {
        BytesReference bytesReference;
        try (BytesStreamOutput encodedStreamOutput = new BytesStreamOutput();){
            try (OutputStreamStreamOutput out = new OutputStreamStreamOutput(Base64.getUrlEncoder().wrap(encodedStreamOutput));){
                out.setTransportVersion(version);
                TransportVersion.writeVersion(version, out);
                out.writeCollection(searchPhaseResults, SearchContextId::writeSearchPhaseResult);
                out.writeMap(aliasFilter, StreamOutput::writeWriteable);
            }
            bytesReference = encodedStreamOutput.bytes();
        }
        catch (IOException e) {
            assert (false) : e;
            throw new IllegalArgumentException(e);
        }
        BytesRef bytesRef = bytesReference.toBytesRef();
        return new String(bytesRef.bytes, bytesRef.offset, bytesRef.length, StandardCharsets.ISO_8859_1);
    }

    private static void writeSearchPhaseResult(StreamOutput out, SearchPhaseResult searchPhaseResult) throws IOException {
        SearchShardTarget target = searchPhaseResult.getSearchShardTarget();
        target.getShardId().writeTo(out);
        new SearchContextIdForNode(target.getClusterAlias(), target.getNodeId(), searchPhaseResult.getContextId()).writeTo(out);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static SearchContextId decode(NamedWriteableRegistry namedWriteableRegistry, String id) {
        try (InputStream decodedInputStream = Base64.getUrlDecoder().wrap(new ByteArrayInputStream(id.getBytes(StandardCharsets.ISO_8859_1)));){
            SearchContextId searchContextId;
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(new InputStreamStreamInput(decodedInputStream), namedWriteableRegistry);){
                TransportVersion version = TransportVersion.readVersion(in);
                in.setTransportVersion(version);
                Map<ShardId, SearchContextIdForNode> shards = Collections.unmodifiableMap(in.readCollection(Maps::newHashMapWithExpectedSize, SearchContextId::readShardsMapEntry));
                Map<String, AliasFilter> aliasFilters = in.readImmutableMap(AliasFilter::readFrom);
                if (in.available() > 0) {
                    throw new IllegalArgumentException("Not all bytes were read");
                }
                searchContextId = new SearchContextId(shards, aliasFilters);
            }
            return searchContextId;
        }
        catch (IOException e) {
            assert (false) : e;
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String[] decodeIndices(String id) {
        try (InputStream decodedInputStream = Base64.getUrlDecoder().wrap(new ByteArrayInputStream(id.getBytes(StandardCharsets.ISO_8859_1)));){
            String[] stringArray;
            try (InputStreamStreamInput in = new InputStreamStreamInput(decodedInputStream);){
                TransportVersion version = TransportVersion.readVersion(in);
                in.setTransportVersion(version);
                Map<ShardId, SearchContextIdForNode> shards = Collections.unmodifiableMap(in.readCollection(Maps::newHashMapWithExpectedSize, SearchContextId::readShardsMapEntry));
                stringArray = new SearchContextId(shards, Collections.emptyMap()).getActualIndices();
            }
            return stringArray;
        }
        catch (IOException e) {
            assert (false) : e;
            throw new IllegalArgumentException(e);
        }
    }

    private static void readShardsMapEntry(StreamInput in, Map<ShardId, SearchContextIdForNode> shards) throws IOException {
        shards.put(new ShardId(in), new SearchContextIdForNode(in));
    }

    public String[] getActualIndices() {
        TreeSet<Object> indices = new TreeSet<Object>();
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : this.shards().entrySet()) {
            String indexName = entry.getKey().getIndexName();
            String clusterAlias = entry.getValue().getClusterAlias();
            if (Strings.isEmpty(clusterAlias)) {
                indices.add(indexName);
                continue;
            }
            indices.add(clusterAlias + ":" + indexName);
        }
        return (String[])indices.toArray(String[]::new);
    }
}

