/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetPipelineResponse
extends ActionResponse
implements ToXContentObject {
    private final List<PipelineConfiguration> pipelines;
    private final boolean summary;

    public GetPipelineResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.pipelines = new ArrayList<PipelineConfiguration>(size);
        for (int i = 0; i < size; ++i) {
            this.pipelines.add(PipelineConfiguration.readFrom(in));
        }
        this.summary = in.readBoolean();
    }

    public GetPipelineResponse(List<PipelineConfiguration> pipelines, boolean summary) {
        this.pipelines = pipelines;
        this.summary = summary;
    }

    public GetPipelineResponse(List<PipelineConfiguration> pipelines) {
        this(pipelines, false);
    }

    public List<PipelineConfiguration> pipelines() {
        return Collections.unmodifiableList(this.pipelines);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.pipelines);
        out.writeBoolean(this.summary);
    }

    public boolean isFound() {
        return !this.pipelines.isEmpty();
    }

    public boolean isSummary() {
        return this.summary;
    }

    public RestStatus status() {
        return this.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (PipelineConfiguration pipeline : this.pipelines) {
            builder.field(pipeline.getId(), this.summary ? Map.of() : pipeline.getConfigAsMap());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof GetPipelineResponse) {
            GetPipelineResponse otherResponse = (GetPipelineResponse)other;
            if (this.pipelines == null) {
                return otherResponse.pipelines == null;
            }
            HashMap<String, PipelineConfiguration> otherPipelineMap = new HashMap<String, PipelineConfiguration>();
            for (PipelineConfiguration pipeline : otherResponse.pipelines) {
                otherPipelineMap.put(pipeline.getId(), pipeline);
            }
            for (PipelineConfiguration pipeline : this.pipelines) {
                PipelineConfiguration otherPipeline;
                if (!pipeline.equals(otherPipeline = (PipelineConfiguration)otherPipelineMap.get(pipeline.getId()))) {
                    return false;
                }
                otherPipelineMap.remove(pipeline.getId());
            }
            return otherPipelineMap.isEmpty();
        }
        return false;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        int result = 1;
        for (PipelineConfiguration pipeline : this.pipelines) {
            result += pipeline == null ? 0 : pipeline.hashCode();
        }
        return result;
    }
}

