/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.DataStreamAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ModifyDataStreamsAction
extends ActionType<AcknowledgedResponse> {
    public static final ModifyDataStreamsAction INSTANCE = new ModifyDataStreamsAction();
    public static final String NAME = "indices:admin/data_stream/modify";

    private ModifyDataStreamsAction() {
        super(NAME);
    }

    public static final class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions(true, true, false, false, false, false, true, false);
        private final List<DataStreamAction> actions;
        public static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("data_stream_actions", args -> new Request((List)args[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.actions = in.readCollectionAsList(DataStreamAction::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.actions);
        }

        public Request(List<DataStreamAction> actions) {
            this.actions = Collections.unmodifiableList(actions);
        }

        public List<DataStreamAction> getActions() {
            return this.actions;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("actions");
            for (DataStreamAction action : this.actions) {
                action.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public ActionRequestValidationException validate() {
            if (this.actions.isEmpty()) {
                return ValidateActions.addValidationError("must specify at least one data stream modification action", null);
            }
            return null;
        }

        @Override
        public String[] indices() {
            return (String[])this.actions.stream().map(DataStreamAction::getIndex).toArray(String[]::new);
        }

        @Override
        public IndicesOptions indicesOptions() {
            return INDICES_OPTIONS;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Arrays.equals(this.actions.toArray(), other.actions.toArray());
        }

        public int hashCode() {
            return Objects.hash(this.actions);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), DataStreamAction.PARSER, new ParseField("actions", new String[0]));
        }
    }
}

