/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.create.AutoCreateAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.rollover.LazyRolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkOperation;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestModifier;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.IngestActionForwarder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    public static final String NAME = "indices:data/write/bulk";
    public static final ActionType<BulkResponse> TYPE = new ActionType("indices:data/write/bulk");
    private static final Logger logger = LogManager.getLogger(TransportBulkAction.class);
    public static final String LAZY_ROLLOVER_ORIGIN = "lazy_rollover";
    private final ActionType<BulkResponse> bulkAction;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IngestService ingestService;
    private final FeatureService featureService;
    private final LongSupplier relativeTimeProvider;
    private final IngestActionForwarder ingestForwarder;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndexingPressure indexingPressure;
    private final SystemIndices systemIndices;
    private final OriginSettingClient rolloverClient;
    private final Executor writeExecutor;
    private final Executor systemWriteExecutor;

    @Inject
    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, FeatureService featureService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        this(threadPool, transportService, clusterService, ingestService, featureService, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, System::nanoTime);
    }

    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, FeatureService featureService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, LongSupplier relativeTimeProvider) {
        this(TYPE, BulkRequest::new, threadPool, transportService, clusterService, ingestService, featureService, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, relativeTimeProvider);
    }

    TransportBulkAction(ActionType<BulkResponse> bulkAction, Writeable.Reader<BulkRequest> requestReader, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, FeatureService featureService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, LongSupplier relativeTimeProvider) {
        super(bulkAction.name(), transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        Objects.requireNonNull(relativeTimeProvider);
        this.bulkAction = bulkAction;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.featureService = featureService;
        this.relativeTimeProvider = relativeTimeProvider;
        this.ingestForwarder = new IngestActionForwarder(transportService);
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indexingPressure = indexingPressure;
        this.systemIndices = systemIndices;
        clusterService.addStateApplier(this.ingestForwarder);
        this.rolloverClient = new OriginSettingClient(client, LAZY_ROLLOVER_ORIGIN);
        this.writeExecutor = threadPool.executor("write");
        this.systemWriteExecutor = threadPool.executor("system_write");
    }

    public static IndexRequest getIndexWriteRequest(DocWriteRequest<?> docWriteRequest) {
        IndexRequest indexRequest = null;
        if (docWriteRequest instanceof IndexRequest) {
            indexRequest = (IndexRequest)docWriteRequest;
        } else if (docWriteRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)docWriteRequest;
            indexRequest = updateRequest.docAsUpsert() ? updateRequest.doc() : updateRequest.upsertRequest();
        }
        return indexRequest;
    }

    public static <Response extends ReplicationResponse> ActionListener<BulkResponse> unwrappingSingleItemBulkResponse(ActionListener<Response> listener) {
        return listener.delegateFailureAndWrap((l, bulkItemResponses) -> {
            assert (bulkItemResponses.getItems().length == 1) : "expected exactly one item in bulk response";
            BulkItemResponse bulkItemResponse = bulkItemResponses.getItems()[0];
            if (!bulkItemResponse.isFailed()) {
                Object response = bulkItemResponse.getResponse();
                l.onResponse(response);
            } else {
                l.onFailure(bulkItemResponse.getFailure().getCause());
            }
        });
    }

    @Override
    protected void doExecute(Task task, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        int indexingOps = bulkRequest.numberOfActions();
        long indexingBytes = bulkRequest.ramBytesUsed();
        boolean isOnlySystem = TransportBulkAction.isOnlySystem(bulkRequest, this.clusterService.state().metadata().getIndicesLookup(), this.systemIndices);
        Releasable releasable = this.indexingPressure.markCoordinatingOperationStarted(indexingOps, indexingBytes, isOnlySystem);
        ActionListener<BulkResponse> releasingListener = ActionListener.runBefore(listener, () -> ((Releasable)releasable).close());
        Executor executor = isOnlySystem ? this.systemWriteExecutor : this.writeExecutor;
        this.ensureClusterStateThenForkAndExecute(task, bulkRequest, executor, releasingListener);
    }

    private void ensureClusterStateThenForkAndExecute(final Task task, final BulkRequest bulkRequest, final Executor executor, final ActionListener<BulkResponse> releasingListener) {
        ClusterState initialState = this.clusterService.state();
        final ClusterBlockException blockException = initialState.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
        if (blockException != null) {
            if (!blockException.retryable()) {
                releasingListener.onFailure(blockException);
                return;
            }
            logger.trace("cluster is blocked, waiting for it to recover", (Throwable)blockException);
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService, bulkRequest.timeout(), logger, this.threadPool.getThreadContext());
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    TransportBulkAction.this.forkAndExecute(task, bulkRequest, executor, releasingListener);
                }

                @Override
                public void onClusterServiceClose() {
                    releasingListener.onFailure(new NodeClosedException(TransportBulkAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    releasingListener.onFailure(blockException);
                }
            }, newState -> false == newState.blocks().hasGlobalBlockWithLevel(ClusterBlockLevel.WRITE));
        } else {
            this.forkAndExecute(task, bulkRequest, executor, releasingListener);
        }
    }

    private void forkAndExecute(final Task task, final BulkRequest bulkRequest, final Executor executor, final ActionListener<BulkResponse> releasingListener) {
        executor.execute(new ActionRunnable<BulkResponse>(releasingListener){

            @Override
            protected void doRun() {
                TransportBulkAction.this.doInternalExecute(task, bulkRequest, executor, releasingListener);
            }
        });
    }

    protected void doInternalExecute(Task task, BulkRequest bulkRequest, Executor executor, ActionListener<BulkResponse> listener) {
        long startTime = this.relativeTime();
        boolean hasIndexRequestsWithPipelines = false;
        Metadata metadata = this.clusterService.state().getMetadata();
        for (DocWriteRequest<?> actionRequest : bulkRequest.requests) {
            IndexRequest ir;
            IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
            if (indexRequest != null) {
                IngestService.resolvePipelinesAndUpdateIndexRequest(actionRequest, indexRequest, metadata);
                hasIndexRequestsWithPipelines |= IngestService.hasPipeline(indexRequest);
            }
            if (!(actionRequest instanceof IndexRequest) || (ir = (IndexRequest)actionRequest).getAutoGeneratedTimestamp() == -1L) continue;
            throw new IllegalArgumentException("autoGeneratedTimestamp should not be set externally");
        }
        if (hasIndexRequestsWithPipelines) {
            ActionListener.run(listener, l -> {
                if (Assertions.ENABLED) {
                    boolean arePipelinesResolved = bulkRequest.requests().stream().map(TransportBulkAction::getIndexWriteRequest).filter(Objects::nonNull).allMatch(IndexRequest::isPipelineResolved);
                    assert (arePipelinesResolved) : bulkRequest;
                }
                if (this.clusterService.localNode().isIngestNode()) {
                    this.processBulkIndexIngestRequest(task, bulkRequest, executor, metadata, (ActionListener<BulkResponse>)l);
                } else {
                    this.ingestForwarder.forwardIngestRequest(this.bulkAction, bulkRequest, (ActionListener<?>)l);
                }
            });
            return;
        }
        Map<String, ReducedRequestInfo> indices = bulkRequest.requests.stream().filter(request -> request.opType() != DocWriteRequest.OpType.DELETE || request.versionType() == VersionType.EXTERNAL || request.versionType() == VersionType.EXTERNAL_GTE).collect(Collectors.toMap(DocWriteRequest::index, request -> ReducedRequestInfo.of(request.isRequireAlias(), request.isRequireDataStream()), (existing, updated) -> ReducedRequestInfo.of(existing.isRequireAlias || updated.isRequireAlias, existing.isRequireDataStream || updated.isRequireDataStream)));
        HashMap<String, IndexNotFoundException> indicesThatCannotBeCreated = new HashMap<String, IndexNotFoundException>();
        ClusterState state = this.clusterService.state();
        Map<String, Boolean> indicesToAutoCreate = indices.entrySet().stream().filter(entry -> !this.indexNameExpressionResolver.hasIndexAbstraction((String)entry.getKey(), state)).filter(entry -> !((ReducedRequestInfo)((Object)((Object)entry.getValue()))).isRequireAlias).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ReducedRequestInfo)((Object)((Object)entry.getValue()))).isRequireDataStream));
        Set<String> dataStreamsToBeRolledOver = this.featureService.clusterHasFeature(state, LazyRolloverAction.DATA_STREAM_LAZY_ROLLOVER) ? indices.keySet().stream().filter(target -> {
            DataStream dataStream = state.metadata().dataStreams().get(target);
            return dataStream != null && dataStream.rolloverOnWrite();
        }).collect(Collectors.toSet()) : Set.of();
        this.createMissingIndicesAndIndexData(task, bulkRequest, executor, listener, indicesToAutoCreate, dataStreamsToBeRolledOver, indicesThatCannotBeCreated, startTime);
    }

    protected void createMissingIndicesAndIndexData(final Task task, final BulkRequest bulkRequest, final Executor executor, ActionListener<BulkResponse> listener, Map<String, Boolean> indicesToAutoCreate, Set<String> dataStreamsToBeRolledOver, final Map<String, IndexNotFoundException> indicesThatCannotBeCreated, final long startTime) {
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        if (indicesToAutoCreate.isEmpty() && dataStreamsToBeRolledOver.isEmpty()) {
            this.executeBulk(task, bulkRequest, startTime, listener, executor, responses, indicesThatCannotBeCreated);
            return;
        }
        Runnable executeBulkRunnable = () -> executor.execute(new ActionRunnable<BulkResponse>(listener){

            @Override
            protected void doRun() {
                TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, this.listener, executor, responses, indicesThatCannotBeCreated);
            }
        });
        try (RefCountingRunnable refs = new RefCountingRunnable(executeBulkRunnable);){
            for (Map.Entry<String, Boolean> indexEntry : indicesToAutoCreate.entrySet()) {
                final String index = indexEntry.getKey();
                this.createIndex(index, indexEntry.getValue(), bulkRequest.timeout(), ActionListener.releaseAfter(new ActionListener<CreateIndexResponse>(){

                    @Override
                    public void onResponse(CreateIndexResponse createIndexResponse) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Exception e) {
                        Throwable cause = ExceptionsHelper.unwrapCause(e);
                        if (cause instanceof IndexNotFoundException) {
                            IndexNotFoundException indexNotFoundException = (IndexNotFoundException)cause;
                            Map map = indicesThatCannotBeCreated;
                            synchronized (map) {
                                indicesThatCannotBeCreated.put(index, indexNotFoundException);
                            }
                        } else if (!(cause instanceof ResourceAlreadyExistsException)) {
                            TransportBulkAction.failRequestsWhenPrerequisiteActionFailed(index, bulkRequest, responses, e);
                        }
                    }
                }, refs.acquire()));
            }
            for (final String dataStream : dataStreamsToBeRolledOver) {
                this.lazyRolloverDataStream(dataStream, bulkRequest.timeout(), ActionListener.releaseAfter(new ActionListener<RolloverResponse>(){

                    @Override
                    public void onResponse(RolloverResponse result) {
                        logger.debug("Data stream {} has {} over, the latest index is {}", (Object)dataStream, (Object)(result.isRolledOver() ? "been successfully rolled" : "skipped rolling"), (Object)result.getNewIndex());
                    }

                    @Override
                    public void onFailure(Exception e) {
                        TransportBulkAction.failRequestsWhenPrerequisiteActionFailed(dataStream, bulkRequest, responses, e);
                    }
                }, refs.acquire()));
            }
        }
    }

    private static void failRequestsWhenPrerequisiteActionFailed(String target, BulkRequest bulkRequest, AtomicArray<BulkItemResponse> responses, Exception error) {
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            DocWriteRequest<?> request = bulkRequest.requests.get(i);
            if (request == null || !TransportBulkAction.setResponseFailureIfIndexMatches(responses, i, request, target, error)) continue;
            bulkRequest.requests.set(i, null);
        }
    }

    protected IngestService getIngestService(BulkRequest request) {
        return this.ingestService;
    }

    static void prohibitAppendWritesInBackingIndices(DocWriteRequest<?> writeRequest, Metadata metadata) {
        DocWriteRequest.OpType opType = writeRequest.opType();
        if (!(opType == DocWriteRequest.OpType.CREATE || opType == DocWriteRequest.OpType.INDEX)) {
            return;
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            return;
        }
        if (indexAbstraction.getParentDataStream() == null) {
            return;
        }
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (opType == DocWriteRequest.OpType.CREATE) {
            throw new IllegalArgumentException("index request with op_type=create targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
        if (opType == DocWriteRequest.OpType.INDEX && writeRequest.ifPrimaryTerm() == 0L && writeRequest.ifSeqNo() == -2L) {
            throw new IllegalArgumentException("index request with op_type=index and no if_primary_term and if_seq_no set targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
    }

    static void prohibitCustomRoutingOnDataStream(DocWriteRequest<?> writeRequest, Metadata metadata) {
        DataStream dataStream;
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeRequest.index());
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) {
            return;
        }
        if (writeRequest.routing() != null && !(dataStream = (DataStream)indexAbstraction).isAllowCustomRouting()) {
            throw new IllegalArgumentException("index request targeting data stream [" + dataStream.getName() + "] specifies a custom routing but the [allow_custom_routing] setting was not enabled in the data stream's template.");
        }
    }

    static boolean isOnlySystem(BulkRequest request, SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices) {
        return request.getIndices().stream().allMatch(indexName -> TransportBulkAction.isSystemIndex(indicesLookup, systemIndices, indexName));
    }

    private static boolean isSystemIndex(SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices, String indexName) {
        IndexAbstraction abstraction = (IndexAbstraction)indicesLookup.get(indexName);
        if (abstraction != null) {
            return abstraction.isSystem();
        }
        return systemIndices.isSystemIndex(indexName);
    }

    void createIndex(String index, boolean requireDataStream, TimeValue timeout, ActionListener<CreateIndexResponse> listener) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest();
        createIndexRequest.index(index);
        createIndexRequest.requireDataStream(requireDataStream);
        createIndexRequest.cause("auto(bulk api)");
        createIndexRequest.masterNodeTimeout(timeout);
        this.client.execute(AutoCreateAction.INSTANCE, createIndexRequest, listener);
    }

    void lazyRolloverDataStream(String dataStream, TimeValue timeout, ActionListener<RolloverResponse> listener) {
        RolloverRequest rolloverRequest = new RolloverRequest(dataStream, null);
        rolloverRequest.masterNodeTimeout(timeout);
        this.rolloverClient.execute(LazyRolloverAction.INSTANCE, rolloverRequest, listener);
    }

    private static boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, DocWriteRequest<?> request, String index, Exception e) {
        if (index.equals(request.index())) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.id(), e);
            responses.set(idx, BulkItemResponse.failure(idx, request.opType(), failure));
            return true;
        }
        return false;
    }

    protected long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTime() - startTimeNanos);
    }

    void executeBulk(Task task, BulkRequest bulkRequest, long startTimeNanos, ActionListener<BulkResponse> listener, Executor executor, AtomicArray<BulkItemResponse> responses, Map<String, IndexNotFoundException> indicesThatCannotBeCreated) {
        new BulkOperation(task, this.threadPool, executor, this.clusterService, bulkRequest, this.client, responses, indicesThatCannotBeCreated, this.indexNameExpressionResolver, this.relativeTimeProvider, startTimeNanos, listener).run();
    }

    private long relativeTime() {
        return this.relativeTimeProvider.getAsLong();
    }

    private void processBulkIndexIngestRequest(final Task task, BulkRequest original, final Executor executor, Metadata metadata, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = System.nanoTime();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.getIngestService(original).executeBulkRequest(original.numberOfActions(), () -> bulkRequestModifier, bulkRequestModifier::markItemAsDropped, indexName -> TransportBulkAction.shouldStoreFailure(indexName, metadata, this.threadPool.absoluteTimeInMillis()), bulkRequestModifier::markItemForFailureStore, bulkRequestModifier::markItemAsFailed, (originalThread, exception) -> {
            if (exception != null) {
                logger.debug("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure((Exception)exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ingestStartTimeInNanos);
                final BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                final ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
                } else {
                    ActionRunnable<BulkResponse> runnable = new ActionRunnable<BulkResponse>(actionListener){

                        @Override
                        protected void doRun() {
                            TransportBulkAction.this.doInternalExecute(task, bulkRequest, executor, actionListener);
                        }

                        @Override
                        public boolean isForceExecution() {
                            return true;
                        }
                    };
                    if (originalThread == Thread.currentThread()) {
                        runnable.run();
                    } else {
                        executor.execute(runnable);
                    }
                }
            }
        }, executor);
    }

    static boolean shouldStoreFailure(String indexName, Metadata metadata, long epochMillis) {
        return DataStream.isFailureStoreFeatureFlagEnabled() && TransportBulkAction.resolveFailureStoreFromMetadata(indexName, metadata, epochMillis).or(() -> TransportBulkAction.resolveFailureStoreFromTemplate(indexName, metadata)).orElse(false) != false;
    }

    private static Optional<Boolean> resolveFailureStoreFromMetadata(String indexName, Metadata metadata, long epochMillis) {
        if (indexName == null) {
            return Optional.empty();
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(IndexNameExpressionResolver.resolveDateMathExpression(indexName, epochMillis));
        if (indexAbstraction == null || !indexAbstraction.isDataStreamRelated()) {
            return Optional.empty();
        }
        Index writeIndex = indexAbstraction.getWriteIndex();
        assert (writeIndex != null) : "Could not resolve write index for resource [" + indexName + "]";
        IndexAbstraction writeAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(writeIndex.getName());
        DataStream targetDataStream = writeAbstraction.getParentDataStream();
        return Optional.of(targetDataStream != null && targetDataStream.isFailureStoreEnabled());
    }

    private static Optional<Boolean> resolveFailureStoreFromTemplate(String indexName, Metadata metadata) {
        ComposableIndexTemplate composableIndexTemplate;
        if (indexName == null) {
            return Optional.empty();
        }
        String template = MetadataIndexTemplateService.findV2Template(metadata, indexName, false);
        if (template != null && (composableIndexTemplate = metadata.templatesV2().get(template)).getDataStreamTemplate() != null) {
            return Optional.of(composableIndexTemplate.getDataStreamTemplate().hasFailureStore());
        }
        return Optional.empty();
    }

    private static enum ReducedRequestInfo {
        REQUIRE_ALIAS_AND_DATA_STREAM(true, true),
        REQUIRE_ALIAS_NOT_DATA_STREAM(true, false),
        REQUIRE_DATA_STREAM_NOT_ALIAS(false, true),
        REQUIRE_NOTHING(false, false);

        private final boolean isRequireAlias;
        private final boolean isRequireDataStream;

        private ReducedRequestInfo(boolean isRequireAlias, boolean isRequireDataStream) {
            this.isRequireAlias = isRequireAlias;
            this.isRequireDataStream = isRequireDataStream;
        }

        static ReducedRequestInfo of(boolean isRequireAlias, boolean isRequireDataStream) {
            if (isRequireAlias) {
                return isRequireDataStream ? REQUIRE_ALIAS_AND_DATA_STREAM : REQUIRE_ALIAS_NOT_DATA_STREAM;
            }
            return isRequireDataStream ? REQUIRE_DATA_STREAM_NOT_ALIAS : REQUIRE_NOTHING;
        }
    }
}

