/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.dangling.find;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import org.elasticsearch.action.admin.indices.dangling.find.FindDanglingIndexResponse;
import org.elasticsearch.action.admin.indices.dangling.find.NodeFindDanglingIndexRequest;
import org.elasticsearch.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.gateway.DanglingIndicesState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportFindDanglingIndexAction
extends TransportNodesAction<FindDanglingIndexRequest, FindDanglingIndexResponse, NodeFindDanglingIndexRequest, NodeFindDanglingIndexResponse> {
    public static final ActionType<FindDanglingIndexResponse> TYPE = new ActionType("cluster:admin/indices/dangling/find");
    private final TransportService transportService;
    private final DanglingIndicesState danglingIndicesState;

    @Inject
    public TransportFindDanglingIndexAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DanglingIndicesState danglingIndicesState) {
        super(TYPE.name(), clusterService, transportService, actionFilters, NodeFindDanglingIndexRequest::new, threadPool.executor("management"));
        this.transportService = transportService;
        this.danglingIndicesState = danglingIndicesState;
    }

    @Override
    protected FindDanglingIndexResponse newResponse(FindDanglingIndexRequest request, List<NodeFindDanglingIndexResponse> nodeResponses, List<FailedNodeException> failures) {
        return new FindDanglingIndexResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    @Override
    protected NodeFindDanglingIndexRequest newNodeRequest(FindDanglingIndexRequest request) {
        return new NodeFindDanglingIndexRequest(request.getIndexUUID());
    }

    @Override
    protected NodeFindDanglingIndexResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeFindDanglingIndexResponse(in);
    }

    @Override
    protected NodeFindDanglingIndexResponse nodeOperation(NodeFindDanglingIndexRequest request, Task task) {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        String indexUUID = request.getIndexUUID();
        ArrayList<IndexMetadata> danglingIndexInfo = new ArrayList<IndexMetadata>();
        for (IndexMetadata each : this.danglingIndicesState.getDanglingIndices().values()) {
            if (!each.getIndexUUID().equals(indexUUID)) continue;
            danglingIndexInfo.add(each);
        }
        return new NodeFindDanglingIndexResponse(localNode, danglingIndexInfo);
    }
}

