/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestoreSnapshotResponse
extends ActionResponse
implements ToXContentObject {
    @Nullable
    private final RestoreInfo restoreInfo;

    public RestoreSnapshotResponse(@Nullable RestoreInfo restoreInfo) {
        this.restoreInfo = restoreInfo;
    }

    public RestoreSnapshotResponse(StreamInput in) throws IOException {
        super(in);
        this.restoreInfo = in.readOptionalWriteable(RestoreInfo::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.restoreInfo);
    }

    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    public RestStatus status() {
        if (this.restoreInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.restoreInfo != null) {
            builder.field("snapshot");
            this.restoreInfo.toXContent(builder, params);
        } else {
            builder.field("accepted", true);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotResponse that = (RestoreSnapshotResponse)o;
        return Objects.equals(this.restoreInfo, that.restoreInfo);
    }

    public int hashCode() {
        return Objects.hash(this.restoreInfo);
    }

    public String toString() {
        return "RestoreSnapshotResponse{restoreInfo=" + this.restoreInfo + "}";
    }
}

