/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterGetSettingsAction
extends TransportMasterNodeReadAction<ClusterGetSettingsAction.Request, ClusterGetSettingsAction.Response> {
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportClusterGetSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/settings", false, transportService, clusterService, threadPool, actionFilters, ClusterGetSettingsAction.Request::new, indexNameExpressionResolver, ClusterGetSettingsAction.Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.settingsFilter = settingsFilter;
    }

    @Override
    protected void masterOperation(Task task, ClusterGetSettingsAction.Request request, ClusterState state, ActionListener<ClusterGetSettingsAction.Response> listener) throws Exception {
        Metadata metadata = state.metadata();
        listener.onResponse(new ClusterGetSettingsAction.Response(this.settingsFilter.filter(metadata.persistentSettings()), this.settingsFilter.filter(metadata.transientSettings()), this.settingsFilter.filter(metadata.settings())));
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterGetSettingsAction.Request request, ClusterState state) {
        return null;
    }
}

