/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.io.PrintWriter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public final class NoShardAvailableActionException
extends ElasticsearchException {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private final boolean onShardFailureWrapper;

    public static NoShardAvailableActionException forOnShardFailureWrapper(String msg) {
        return new NoShardAvailableActionException(null, msg, null, true);
    }

    public NoShardAvailableActionException(ShardId shardId) {
        this(shardId, null, null, false);
    }

    public NoShardAvailableActionException(ShardId shardId, String msg) {
        this(shardId, msg, null, false);
    }

    public NoShardAvailableActionException(ShardId shardId, String msg, Throwable cause) {
        this(shardId, msg, cause, false);
    }

    private NoShardAvailableActionException(ShardId shardId, String msg, Throwable cause, boolean onShardFailureWrapper) {
        super(msg, cause, new Object[0]);
        this.setShard(shardId);
        this.onShardFailureWrapper = onShardFailureWrapper;
    }

    @Override
    public RestStatus status() {
        return RestStatus.SERVICE_UNAVAILABLE;
    }

    public NoShardAvailableActionException(StreamInput in) throws IOException {
        super(in);
        this.onShardFailureWrapper = false;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.onShardFailureWrapper ? EMPTY_STACK_TRACE : super.getStackTrace();
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (!this.onShardFailureWrapper) {
            super.printStackTrace(s);
        } else {
            s.println(this);
        }
    }
}

