/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.arcsde;

import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.arcgis.ArcSDEConnection;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.arcsde.ArcSDEConnectionFactory;
import org.fao.geonet.kernel.harvest.harvester.arcsde.ArcSDEParams;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.schema.iso19139.ISO19139Namespaces;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.Namespace;

public class ArcSDEHarvester
extends AbstractHarvester<HarvestResult, ArcSDEParams> {
    private static final String ARC_TO_ISO19115_TRANSFORMER = "ArcCatalog8_to_ISO19115.xsl";
    private static final String ISO19115_TO_ISO19139_TRANSFORMER = "fromISO19115.xsl";

    @Override
    protected void storeNodeExtra(ArcSDEParams params, String path, String siteId, String optionsId) throws SQLException {
        this.setParams(params);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"icon", (Object)params.icon);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"server", (Object)params.server);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"port", (Object)params.port);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"username", (Object)params.getUsername());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"password", (Object)params.getPassword());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"database", (Object)params.database);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"version", (Object)params.version);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"connectionType", (Object)params.connectionType);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"databaseType", (Object)params.databaseType);
    }

    @Override
    protected ArcSDEParams createParams() {
        return new ArcSDEParams(this.dataMan);
    }

    @Override
    public Element getResult() {
        Element res = new Element("result");
        if (this.result != null) {
            this.add(res, "total", this.result.totalMetadata);
            this.add(res, "added", this.result.addedMetadata);
            this.add(res, "updated", this.result.updatedMetadata);
            this.add(res, "unchanged", this.result.unchangedMetadata);
            this.add(res, "unknownSchema", this.result.unknownSchema);
            this.add(res, "removed", this.result.locallyRemoved);
            this.add(res, "unretrievable", this.result.unretrievable);
            this.add(res, "badFormat", this.result.badFormat);
            this.add(res, "doesNotValidate", this.result.doesNotValidate);
        }
        return res;
    }

    @Override
    public void doHarvest(Logger l) throws Exception {
        this.log.info("ArcSDE harvest starting");
        ArcSDEConnectionFactory connectionFactory = (ArcSDEConnectionFactory)this.context.getBean(ArcSDEConnectionFactory.class);
        ArcSDEConnection connection = connectionFactory.getConnection(((ArcSDEParams)this.params).connectionType, ((ArcSDEParams)this.params).databaseType, ((ArcSDEParams)this.params).server, ((ArcSDEParams)this.params).port, ((ArcSDEParams)this.params).database, ((ArcSDEParams)this.params).getUsername(), ((ArcSDEParams)this.params).getPassword());
        Map metadataList = connection.retrieveMetadata(this.cancelMonitor, ((ArcSDEParams)this.params).version);
        this.align(metadataList);
        this.log.info("ArcSDE harvest finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void align(Map<String, String> metadataList) throws Exception {
        this.log.info("Start of alignment for : " + ((ArcSDEParams)this.params).getName());
        this.result = new HarvestResult();
        CategoryMapper localCateg = new CategoryMapper(this.context);
        GroupMapper localGroups = new GroupMapper(this.context);
        this.metadataManager.flush();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
        Path ArcToISO19115Transformer = dataDirectory.getXsltConversion("schema:iso19139:convert/ArcCatalog8_to_ISO19115.xsl");
        Path ISO19115ToISO19139Transformer = dataDirectory.getXsltConversion("schema:iso19139:convert/fromISO19115.xsl");
        ArrayList<Integer> idsForHarvestingResult = new ArrayList<Integer>();
        for (Map.Entry<String, String> entry : metadataList.entrySet()) {
            String metadata;
            String uuid;
            block32: {
                block31: {
                    this.log.info("Processing UUID: " + entry.getKey());
                    uuid = entry.getKey();
                    metadata = entry.getValue();
                    if (this.cancelMonitor.get()) {
                        return;
                    }
                    ++this.result.totalMetadata;
                    if (!StringUtils.isEmpty((String)uuid)) break block31;
                    this.log.info("Processing empty UUID. Skipping");
                    ++this.result.originalMetadata;
                    continue;
                }
                if (!StringUtils.isEmpty((String)metadata)) break block32;
                this.log.info("Processing empty metadata xml for UUID: " + uuid + ". Skipping");
                ++this.result.originalMetadata;
                continue;
            }
            String thumbnailContent = "";
            Element metadataElement = Xml.loadString((String)metadata, (boolean)false);
            String schema = null;
            try {
                schema = this.dataMan.autodetectSchema(metadataElement, null);
            }
            catch (NoSchemaMatchesException noSchemaMatchesException) {
                // empty catch block
            }
            ArrayList<Namespace> esriMdNamespaces = new ArrayList<Namespace>();
            esriMdNamespaces.add(metadataElement.getNamespace());
            esriMdNamespaces.addAll(metadataElement.getAdditionalNamespaces());
            esriMdNamespaces.add(ISO19139Namespaces.GMD);
            Element iso19139Element = Xml.selectElement((Element)metadataElement, (String)"gmd:MD_Metadata", esriMdNamespaces);
            boolean hasIso19139Embedded = false;
            if (schema == null && iso19139Element != null) {
                try {
                    schema = this.dataMan.autodetectSchema(iso19139Element, null);
                }
                catch (NoSchemaMatchesException noSchemaMatchesException) {
                    // empty catch block
                }
                hasIso19139Embedded = schema != null;
                this.log.info("Metadata has ISO13139 embedded - " + hasIso19139Embedded);
            }
            if (schema == null) {
                this.log.info("Convert metadata to ISO19139 - start");
                Element thumbnailEl = Xml.selectElement((Element)metadataElement, (String)"Binary/Thumbnail/Data", esriMdNamespaces);
                if (thumbnailEl != null) {
                    thumbnailContent = thumbnailEl.getText();
                }
                Element iso19115 = Xml.transform((Element)metadataElement, (Path)ArcToISO19115Transformer);
                metadataElement = Xml.transform((Element)iso19115, (Path)ISO19115ToISO19139Transformer);
                this.log.info("Convert metadata to ISO19139 - end");
                try {
                    schema = this.dataMan.autodetectSchema(metadataElement, null);
                }
                catch (NoSchemaMatchesException noSchemaMatchesException) {}
            } else if (hasIso19139Embedded) {
                metadataElement = iso19139Element;
            }
            if (schema == null) {
                this.log.info("Skipping metadata with unknown schema.");
                ++this.result.unknownSchema;
                continue;
            }
            this.log.info("Metadata schema: " + schema);
            this.log.info("Assigning metadata uuid: " + uuid);
            metadataElement = this.dataMan.setUUID(schema, uuid, metadataElement);
            if (StringUtils.isEmpty((String)uuid)) {
                this.log.info("No metadata uuid. Skipping.");
                ++this.result.badFormat;
                continue;
            }
            try {
                Integer groupIdVal = null;
                if (StringUtils.isNotEmpty((String)((ArcSDEParams)this.params).getOwnerIdGroup())) {
                    groupIdVal = Integer.parseInt(((ArcSDEParams)this.params).getOwnerIdGroup());
                }
                ((ArcSDEParams)this.params).getValidate().validate(this.dataMan, this.context, metadataElement, groupIdVal);
            }
            catch (Exception e) {
                this.log.error("Ignoring invalid metadata with uuid " + uuid);
                ++this.result.doesNotValidate;
                ++this.result.originalMetadata;
                continue;
            }
            try {
                BaseAligner aligner = new BaseAligner(this.cancelMonitor){};
                aligner.setParams(this.params);
                String id = this.dataMan.getMetadataId(uuid);
                if (id == null) {
                    id = this.addMetadata(metadataElement, uuid, schema, localGroups, localCateg, aligner);
                    ++this.result.addedMetadata;
                } else {
                    this.updateMetadata(metadataElement, id, localGroups, localCateg, aligner);
                    ++this.result.updatedMetadata;
                }
                if (StringUtils.isNotEmpty((String)thumbnailContent)) {
                    this.loadMetadataThumbnail(thumbnailContent, id, uuid);
                }
                idsForHarvestingResult.add(Integer.valueOf(id));
            }
            catch (Throwable t) {
                this.log.error("Unable to process record from arcsde (" + ((ArcSDEParams)this.params).getName() + ")");
                this.log.error("   Record failed. Error is: " + t.getMessage());
                this.log.error(t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ++this.result.originalMetadata;
            }
        }
        HashSet idsResultHs = Sets.newHashSet(idsForHarvestingResult);
        List existingMetadata = ((MetadataRepository)this.context.getBean(MetadataRepository.class)).findIdsBy(MetadataSpecs.hasHarvesterUuid((String)((ArcSDEParams)this.params).getUuid()));
        for (Integer existingId : existingMetadata) {
            if (this.cancelMonitor.get()) {
                return;
            }
            if (idsResultHs.contains(existingId)) continue;
            this.log.debug("  Removing: " + existingId);
            this.metadataManager.deleteMetadata(this.context, existingId.toString());
            ++this.result.locallyRemoved;
        }
    }

    private void updateMetadata(Element xml, String id, GroupMapper localGroups, CategoryMapper localCateg, BaseAligner aligner) throws Exception {
        this.log.info("Updating metadata with id: " + id);
        boolean validate = false;
        boolean ufo = false;
        String language = this.context.getLanguage();
        String changeDate = null;
        try {
            String schema = this.dataMan.autodetectSchema(xml);
            changeDate = this.dataMan.extractDateModified(schema, xml);
        }
        catch (Exception ex) {
            this.log.error("ArcSDEHarverter - updateMetadata - can't get metadata modified date for metadata id= " + id + ", using current date for modified date");
            changeDate = new ISODate().toString();
        }
        AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, xml, validate, ufo, language, changeDate, true, IndexingMode.none);
        OperationAllowedRepository operationAllowedRepository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
        operationAllowedRepository.deleteAllByMetadataId(Integer.parseInt(id));
        aligner.addPrivileges(id, ((ArcSDEParams)this.params).getPrivileges(), localGroups, this.context);
        metadata.getCategories().clear();
        aligner.addCategories(metadata, ((ArcSDEParams)this.params).getCategories(), localCateg, this.context, null, true);
        this.metadataManager.flush();
        this.dataMan.indexMetadata(id, true);
    }

    private String addMetadata(Element xml, String uuid, String schema, GroupMapper localGroups, CategoryMapper localCateg, BaseAligner aligner) throws Exception {
        this.log.info("  - Adding metadata with remote uuid: " + uuid);
        ISODate createDate = null;
        try {
            createDate = new ISODate(this.dataMan.extractDateModified(schema, xml));
        }
        catch (Exception ex) {
            this.log.error("ArcSDEHarverter - addMetadata - can't get metadata modified date for metadata with uuid= " + uuid + ", using current date for modified date");
            createDate = new ISODate();
        }
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(xml.getQualifiedName()).setType(MetadataType.METADATA).setCreateDate(createDate).setChangeDate(createDate);
        metadata.getSourceInfo().setSourceId(((ArcSDEParams)this.params).getUuid()).setOwner(Integer.valueOf(Integer.parseInt(((ArcSDEParams)this.params).getOwnerId())));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((ArcSDEParams)this.params).getUuid());
        try {
            metadata.getSourceInfo().setGroupOwner(Integer.valueOf(((ArcSDEParams)this.params).getOwnerIdGroup()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        aligner.addCategories((AbstractMetadata)metadata, ((ArcSDEParams)this.params).getCategories(), localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, xml, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        aligner.addPrivileges(id, ((ArcSDEParams)this.params).getPrivileges(), localGroups, this.context);
        this.dataMan.indexMetadata(id, true);
        return id;
    }

    private void loadMetadataThumbnail(String thumbnail, String metadataId, String uuid) {
        this.log.info("  - Creating thumbnail for metadata uuid: " + uuid);
        try {
            String filename = uuid + ".png";
            Path dir = this.context.getUploadDir();
            byte[] byArray = Base64.decodeBase64((String)thumbnail);
        }
        catch (Exception e) {
            this.log.warning("  - Failed to set thumbnail for metadata: " + e.getMessage());
            this.log.error((Throwable)e);
            ++this.result.thumbnailsFailed;
        }
    }
}

