/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users.validation;

import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.users.model.UserRegisterDto;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.utils.EmailUtil;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class UserRegisterDtoValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return UserRegisterDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        UserRepository userRepository;
        UserRegisterDto userRegisterDto = (UserRegisterDto)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"field.required", (String)"name is required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"email", (String)"field.required", (String)"email is required");
        if (StringUtils.hasLength((String)userRegisterDto.getEmail()) && !EmailUtil.isValidEmailAddress((String)userRegisterDto.getEmail())) {
            errors.rejectValue("email", "field.notvalid", "Email address is not valid");
        }
        if ((userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class)).findOneByEmail(userRegisterDto.getEmail()) != null || !userRepository.findByUsernameIgnoreCase(userRegisterDto.getEmail()).isEmpty()) {
            errors.rejectValue("", "user_with_that_email_username_found", "A user with this email or username already exists.");
        }
    }
}

