/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MultilingualSchemaPlugin;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/registries/entries"})
@Tag(name="registries", description="Registries related operations")
public class DirectoryEntriesApi {
    private static final char SEPARATOR = '~';
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    GeonetworkDataDirectory dataDirectory;

    @Operation(summary="Get a directory entry", description="Directory entry (AKA subtemplates) are XML fragments that can be inserted in metadata records using XLinks. XLinks can be remote or local.")
    @RequestMapping(value={"/{uuid:.+}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Directory entry."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Element getEntry(@Parameter(description="Directory entry UUID.", required=true) @PathVariable String uuid, @Parameter(description="Process", required=false) @RequestParam(required=false) String[] process, @Parameter(description="Transformation", required=false) @RequestParam(required=false) String transformation, @Parameter(description="lang", required=false) @RequestParam(name="lang", required=false) String[] langs, @Parameter(description="schema", required=false) @RequestParam(required=false, defaultValue="iso19139") String schema, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        AbstractMetadata metadata = this.metadataRepository.findOneByUuid(uuid);
        if (metadata == null) {
            throw new ResourceNotFoundException(String.format("Directory entry with UUID '%s' not found in this registry.", uuid));
        }
        if (metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE) {
            throw new IllegalArgumentException(String.format("The record found with UUID '%s' is not a subtemplate", uuid));
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        if (langs == null) {
            langs = context.getLanguage().split(",");
        }
        Element tpl = metadata.getXmlData(false);
        if (process != null) {
            String[] replaceList;
            for (String parameters : replaceList = process) {
                int endIndex = parameters.indexOf(126);
                if (endIndex == -1) continue;
                String xpath = parameters.substring(0, endIndex);
                String value = parameters.substring(endIndex + 1);
                HashSet allNamespaces = Sets.newHashSet();
                Iterator descendants = tpl.getDescendants();
                while (descendants.hasNext()) {
                    Object next = descendants.next();
                    if (!(next instanceof Element)) continue;
                    Element element = (Element)next;
                    allNamespaces.add(element.getNamespace());
                    for (Object o : tpl.getAdditionalNamespaces()) {
                        if (!(o instanceof Namespace)) continue;
                        Namespace namespace = (Namespace)o;
                        allNamespaces.add(namespace);
                    }
                }
                Object o = Xml.selectSingle((Element)tpl, (String)xpath, (List)Lists.newArrayList((Iterable)allNamespaces));
                if (o instanceof Element) {
                    ((Element)o).setText(value);
                    continue;
                }
                if (!(o instanceof Attribute)) continue;
                ((Attribute)o).setValue(value);
            }
        }
        ArrayList<CallSite> twoCharLangs = new ArrayList<CallSite>();
        for (String l : langs) {
            twoCharLangs.add((CallSite)((Object)("#" + XslUtil.twoCharLangCode((String)l).toUpperCase())));
        }
        MultilingualSchemaPlugin plugin = (MultilingualSchemaPlugin)this.schemaManager.getSchema(schema).getSchemaPlugin();
        if (plugin != null) {
            plugin.removeTranslationFromElement(tpl, twoCharLangs);
        }
        if (transformation != null) {
            Element root = new Element("root");
            Element requestElt = new Element("request");
            requestElt.addContent((Content)new Element("transformation").setText(transformation));
            root.addContent((Content)requestElt);
            root.addContent((Content)tpl);
            Path xslt = this.dataDirectory.getWebappDir().resolve("xslt/services/subtemplate/convert.xsl");
            return Xml.transform((Element)root, (Path)xslt);
        }
        return tpl;
    }
}

