/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions.metadata;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.fao.geonet.kernel.search.spatial.ErrorHandler;
import org.fao.geonet.util.GMLParsers;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Parser;
import org.jdom.Element;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.SAXException;

public class GeomUtils {
    public static MultiPolygon getSpatialExtent(Path schemaDir, Element metadata, ErrorHandler errorHandler) throws Exception {
        Logging.getLogger((String)"org.geotools.xml").setLevel(Level.SEVERE);
        Path sSheet = schemaDir.resolve("extract-gml.xsl").toAbsolutePath();
        Element transform = Xml.transform((Element)metadata, (Path)sSheet);
        if (transform.getChildren().size() == 0) {
            return null;
        }
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        for (Element geom : transform.getChildren()) {
            Parser parser = GMLParsers.create((Element)geom);
            String srs = geom.getAttributeValue("srsName");
            DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
            String gml = Xml.getString((Element)geom);
            try {
                if (srs != null && !srs.equals("")) {
                    sourceCRS = CRS.decode((String)srs);
                }
                MultiPolygon jts = GeomUtils.parseGml(parser, gml);
                if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
                    MathTransform tform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    jts = (MultiPolygon)JTS.transform((Geometry)jts, (MathTransform)tform);
                }
                for (int i = 0; i < jts.getNumGeometries(); ++i) {
                    allPolygons.add((Polygon)jts.getGeometryN(i));
                }
            }
            catch (Exception e) {
                errorHandler.handleParseException(e, gml);
            }
        }
        if (allPolygons.isEmpty()) {
            return null;
        }
        try {
            Polygon[] array = new Polygon[allPolygons.size()];
            GeometryFactory geometryFactory = ((Polygon)allPolygons.get(0)).getFactory();
            return geometryFactory.createMultiPolygon(allPolygons.toArray(array));
        }
        catch (Exception e) {
            errorHandler.handleBuildException(e, allPolygons);
            return null;
        }
    }

    public static MultiPolygon parseGml(Parser parser, String gml) throws IOException, SAXException, ParserConfigurationException {
        Object value = parser.parse((Reader)new StringReader(gml));
        if (value instanceof HashMap) {
            HashMap map = (HashMap)value;
            ArrayList<MultiPolygon> geoms = new ArrayList<MultiPolygon>();
            for (Object entry : map.values()) {
                GeomUtils.addToList(geoms, entry);
            }
            if (geoms.isEmpty()) {
                return null;
            }
            if (geoms.size() > 1) {
                GeometryFactory factory = ((MultiPolygon)geoms.get(0)).getFactory();
                return factory.createMultiPolygon(geoms.toArray(new Polygon[0]));
            }
            return GeomUtils.toMultiPolygon((Geometry)geoms.get(0));
        }
        if (value == null) {
            return null;
        }
        return GeomUtils.toMultiPolygon((Geometry)value);
    }

    public static MultiPolygon toMultiPolygon(Geometry geometry) {
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return geometry.getFactory().createMultiPolygon(new Polygon[]{polygon});
        }
        if (geometry instanceof MultiPolygon) {
            return (MultiPolygon)geometry;
        }
        String message = geometry.getClass() + " cannot be converted to a polygon. Check metadata";
        Log.error((String)"geonetwork.index", (Object)message);
        throw new IllegalArgumentException(message);
    }

    public static void addToList(List<MultiPolygon> geoms, Object entry) {
        if (entry instanceof Polygon) {
            geoms.add(GeomUtils.toMultiPolygon((Geometry)((Polygon)entry)));
        } else if (entry instanceof MultiPolygon) {
            geoms.add((MultiPolygon)entry);
        } else if (entry instanceof Collection) {
            Collection collection = (Collection)entry;
            for (Object object : collection) {
                geoms.add(GeomUtils.toMultiPolygon((Geometry)((Polygon)object)));
            }
        }
    }
}

