/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.SingleThesaurusFinder;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.rdf.Query;
import org.fao.geonet.kernel.rdf.QueryBuilder;
import org.fao.geonet.kernel.rdf.Selectors;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.Request;
import org.fao.geonet.kernel.search.keyword.KeywordRelation;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParamsBuilder;
import org.fao.geonet.kernel.search.keyword.KeywordSearchType;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.util.LangUtils;
import org.fao.geonet.utils.Log;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;

public class ThesaurusRequest
extends Request {
    private static final String NO_CATEGORY = "_none_";
    private static final CoordinateReferenceSystem WGS84 = Region.WGS84;
    private final WeakHashMap<String, Map<String, String>> categoryTranslations;
    private final ServiceContext serviceContext;
    private final KeywordSearchParamsBuilder searchBuilder;
    private final Thesaurus thesaurus;
    private final SingleThesaurusFinder finder;
    private final Set<String> localesToLoad;

    public ThesaurusRequest(ServiceContext context, WeakHashMap<String, Map<String, String>> categoryTranslations, Set<String> localesToLoad, Thesaurus thesaurus) {
        this.localesToLoad = localesToLoad;
        this.serviceContext = context;
        this.categoryTranslations = categoryTranslations;
        this.thesaurus = thesaurus;
        this.searchBuilder = new KeywordSearchParamsBuilder(thesaurus.getIsoLanguageMapper());
        for (String lang : localesToLoad) {
            this.searchBuilder.addLang(lang);
        }
        this.searchBuilder.addThesaurus(thesaurus.getKey());
        this.searchBuilder.requireBoundedBy(true);
        this.finder = new SingleThesaurusFinder(thesaurus);
    }

    public Request label(String labelParam) {
        this.searchBuilder.keyword(labelParam, KeywordSearchType.CONTAINS, true);
        return this;
    }

    public Request categoryId(String categoryIdParam) {
        if (categoryIdParam.equals(NO_CATEGORY)) {
            categoryIdParam = "";
        }
        this.searchBuilder.relationship(categoryIdParam, KeywordRelation.BROADER, KeywordSearchType.MATCH, false);
        return this;
    }

    public String getCategoryId(String keywordId) {
        String categoryIdParam = "";
        Query query = QueryBuilder.keywordQueryBuilder((IsoLanguagesMapper)this.thesaurus.getIsoLanguageMapper(), (String[])new String[0]).select(Selectors.related((String)keywordId, (KeywordRelation)KeywordRelation.NARROWER), true).build();
        try {
            List results = query.execute(this.thesaurus);
            if (results.size() == 1) {
                categoryIdParam = ((KeywordBean)results.get(0)).getUriCode();
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.thesaurus", (String)e.getMessage(), (Throwable)e);
        }
        return categoryIdParam;
    }

    public Request maxRecords(int maxRecordsParam) {
        this.searchBuilder.maxResults(maxRecordsParam);
        return this;
    }

    public Collection<Region> execute() throws Exception {
        List keywords = this.searchBuilder.build().search((ThesaurusFinder)this.finder);
        ArrayList<Region> regions = new ArrayList<Region>(keywords.size());
        for (KeywordBean keywordBean : keywords) {
            WeakHashMap<String, String> categoryLabels;
            String categoryLabelKey;
            String id = keywordBean.getUriCode();
            Map unfilteredLabels = keywordBean.getValues();
            HashMap<String, String> labels = new HashMap<String, String>((int)((double)unfilteredLabels.size() * 1.25));
            for (Map.Entry next : unfilteredLabels.entrySet()) {
                if (((String)next.getValue()).trim().isEmpty()) continue;
                labels.put((String)next.getKey(), (String)next.getValue());
            }
            String categoryId = this.getCategoryId(keywordBean.getUriCode());
            if (categoryId.trim().isEmpty()) {
                categoryId = NO_CATEGORY;
            }
            if ((categoryLabelKey = categoryId).equals(NO_CATEGORY)) {
                categoryLabelKey = "none";
            }
            if (categoryLabelKey.indexOf(35) > -1) {
                categoryLabelKey = categoryLabelKey.substring(categoryLabelKey.lastIndexOf(35) + 1);
            }
            if ((categoryLabels = this.categoryTranslations.get(categoryLabelKey)) == null) {
                try {
                    categoryLabels = LangUtils.translate((ApplicationContext)this.serviceContext.getApplicationContext(), (String)"categories", (String)categoryLabelKey);
                    this.categoryTranslations.put(categoryLabelKey, (Map<String, String>)categoryLabels);
                }
                catch (JDOMException e) {
                    Log.debug((String)"geonetwork.thesaurus-man", (Object)String.format("Category key %s is not valid for JDOM element.Region thesaurus should use rdf:about element with the following structure <prefix>#<id> where the id could be a valid XML element name. Error is %s.", categoryLabelKey, e.getMessage()));
                    categoryLabels = new WeakHashMap<String, String>();
                }
            }
            if (categoryLabels.isEmpty()) {
                for (String loc : this.localesToLoad) {
                    categoryLabels.put(loc, categoryLabelKey);
                }
            }
            boolean hasGeom = false;
            double west = Double.parseDouble(keywordBean.getCoordWest());
            double east = Double.parseDouble(keywordBean.getCoordEast());
            double north = Double.parseDouble(keywordBean.getCoordNorth());
            double south = Double.parseDouble(keywordBean.getCoordSouth());
            ReferencedEnvelope bbox = new ReferencedEnvelope(west, east, south, north, WGS84);
            Region region = new Region(id, labels, categoryId, categoryLabels, hasGeom, bbox);
            regions.add(region);
        }
        return regions;
    }

    public Request id(String regionId) {
        this.searchBuilder.uri(regionId);
        return this;
    }

    public Optional<Long> getLastModified() {
        return Optional.of((Object)this.thesaurus.getLastModifiedTime().toMillis());
    }
}

