/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.MetadataBatchApproveParameter;
import org.fao.geonet.api.records.model.MetadataBatchSubmitParameter;
import org.fao.geonet.api.records.model.MetadataPublicationNotificationInfo;
import org.fao.geonet.api.records.model.MetadataStatusParameter;
import org.fao.geonet.api.records.model.MetadataStatusResponse;
import org.fao.geonet.api.records.model.MetadataWorkflowStatusResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordRestoredEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusActionsFactory;
import org.fao.geonet.kernel.metadata.StatusChangeType;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.search.Translator;
import org.fao.geonet.kernel.search.TranslatorFactory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.MetadataPublicationMailNotifier;
import org.fao.geonet.util.WorkflowUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.input.JDOMParseException;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordWorkflow")
@ReadWriteController
public class MetadataWorkflowApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;
    @Autowired
    MetadataDraftRepository metadatadraftRepository;
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    IMetadataStatus metadataStatus;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    FeedbackLanguages feedbackLanguages;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    StatusActionsFactory statusActionFactory;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    private EsSearchManager searchManager;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private IMetadataValidator metadataValidator;
    @Autowired
    private OperationAllowedRepository operationAllowedRepository;
    @Autowired
    private MetadataCategoryRepository categoryRepository;
    @Autowired
    MetadataPublicationMailNotifier metadataPublicationMailNotifier;
    @Autowired
    RoleHierarchy roleHierarchy;
    @Autowired
    TranslatorFactory translatorFactory;
    static final StatusValue.Events[] supportedRestoreStatuses = StatusValue.Events.getSupportedRestoreStatuses();

    @Operation(summary="Get record status history", description="")
    @RequestMapping(value={"/{metadataUuid}/status"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistory(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @RequestParam(required=false) boolean details, @Parameter(description="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        ServiceContext context = ApiUtils.createServiceContext(request);
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, approved, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException(messages.getString("exception.notAllowed.cannotView"));
        }
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
        List listOfStatus = this.metadataStatusRepository.findAllByMetadataId(metadata.getId(), Sort.by((Sort.Direction)sortOrder, (String[])new String[]{sortField}));
        return this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
    }

    @Operation(summary="Get record status history by type", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistoryByType(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Type", required=true) @PathVariable StatusValueType type, @RequestParam(required=false) boolean details, @Parameter(description="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        ServiceContext context = ApiUtils.createServiceContext(request);
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, approved, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException(messages.getString("exception.notAllowed.cannotView"));
        }
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
        List listOfStatus = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadata.getId(), type, Sort.by((Sort.Direction)sortOrder, (String[])new String[]{sortField}));
        return this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
    }

    @Operation(summary="Get last workflow status for a record", description="")
    @RequestMapping(value={"/{metadataUuid}/status/workflow/last"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('RegisteredUser')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record status."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public MetadataWorkflowStatusResponse getStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.getRecord(metadataUuid);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());
        if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
            Profile userProfile = context.getUserSession().getProfile();
            String minimumAllowedProfileName = (String)StringUtils.defaultIfBlank((CharSequence)this.settingManager.getValue("metadata/history/accesslevel"), (CharSequence)Profile.Editor.toString());
            Profile minimumAllowedProfile = Profile.valueOf((String)minimumAllowedProfileName);
            if (!minimumAllowedProfile.getProfileAndAllParents().contains(userProfile)) {
                String message = this.getMustBeProfileOrOwnerMessage(minimumAllowedProfileName, messages, locale);
                Log.debug((String)"geonetwork.api", (Object)message);
                throw new NotAllowedException(message);
            }
            this.checkUserCanSeeHistory(minimumAllowedProfile, metadataUuid, messages, request);
        }
        MetadataStatus recordStatus = this.metadataStatus.getStatus(metadata.getId());
        List elStatus = this.statusValueRepository.findAllByType(StatusValueType.workflow);
        HashSet<Integer> ids = new HashSet<Integer>();
        ids.add(metadata.getId());
        List reviewers = this.userRepository.findAllByGroupOwnerNameAndProfile(ids, Profile.Reviewer);
        reviewers.sort(Comparator.comparing(s -> ((User)s.two()).getName()));
        ArrayList<User> listOfReviewers = new ArrayList<User>();
        for (Pair reviewer : reviewers) {
            listOfReviewers.add((User)reviewer.two());
        }
        return new MetadataWorkflowStatusResponse(recordStatus, listOfReviewers, this.accessManager.hasEditPermission(context, String.valueOf(metadata.getId())), elStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set the records status to approved", description="")
    @RequestMapping(value={"/approve"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Metadata approved ."), @ApiResponse(responseCode="400", description="Metadata workflow not enabled.")})
    @ResponseBody
    MetadataProcessingReport approve(@RequestBody MetadataBatchApproveParameter approveParameter, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request, this.languageUtils.getIso3langCode(request.getLocales()));
        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(request.getLocale());
        this.checkWorkflowEnabled();
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
            boolean notifyByEmail = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.settingManager.getValue("system/metadataprivs/publication/notificationLevel")});
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(approveParameter.getUuids(), approveParameter.getBucket(), ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                Metadata metadataApproved;
                AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!this.accessManager.isOwner(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                if (!this.isAllowedMetadataStatusChange(context, metadata, report)) continue;
                MetadataStatus currentStatus = this.metadataStatus.getStatus(metadata.getId());
                if (currentStatus == null) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Metadata workflow is not enabled");
                    continue;
                }
                if (!approveParameter.isDirectApproval() && currentStatus.getStatusValue().getId() != Integer.parseInt("4")) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), this.metadataUtils.isMetadataDraft(metadata.getId()), this.metadataUtils.isMetadataApproved(metadata.getId()), "Metadata is not in submitted status.");
                    continue;
                }
                this.changeMetadataStatus(context, metadata, currentStatus.getCurrentState(), "2", approveParameter.getMessage());
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
                if (!notifyByEmail) continue;
                int metadataIdApproved = metadata.getId();
                if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                    metadataIdApproved = metadataApproved.getId();
                }
                if (currentStatus.getStatusValue().getId() == Integer.parseInt("2") || !this.metadataUtils.isMetadataPublished(metadataIdApproved)) continue;
                MetadataPublicationNotificationInfo metadataNotificationInfo = new MetadataPublicationNotificationInfo();
                metadataNotificationInfo.setMetadataUuid(metadata.getUuid());
                metadataNotificationInfo.setMetadataId(metadataIdApproved);
                metadataNotificationInfo.setGroupId(metadata.getSourceInfo().getGroupOwner());
                metadataNotificationInfo.setPublished(true);
                metadataNotificationInfo.setPublicationDateStamp(new ISODate());
                metadataNotificationInfo.setReapproval(true);
                metadataListToNotifyPublication.add(metadataNotificationInfo);
            }
            this.dataManager.flush();
            this.metadataIndexer.indexMetadata(listOfUpdatedRecords);
            if (notifyByEmail && !metadataListToNotifyPublication.isEmpty()) {
                this.metadataPublicationMailNotifier.notifyPublication(feedbackLocales, metadataListToNotifyPublication);
            }
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set the records status to submitted", description="")
    @RequestMapping(value={"/submit"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Metadata submitted ."), @ApiResponse(responseCode="400", description="Metadata workflow not enabled.")})
    @ResponseBody
    MetadataProcessingReport submit(@RequestBody MetadataBatchSubmitParameter submitParameter, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String language = this.languageUtils.getIso3langCode(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request, language);
        this.checkWorkflowEnabled();
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(submitParameter.getUuids(), submitParameter.getBucket(), ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                Metadata metadataApproved;
                AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!this.accessManager.isOwner(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                if (!this.isAllowedMetadataStatusChange(context, metadata, report)) continue;
                MetadataStatus currentStatus = this.metadataStatus.getStatus(metadata.getId());
                if (currentStatus == null) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Record has no status. It can't be submitted.");
                    continue;
                }
                if (currentStatus.getStatusValue().getId() != Integer.parseInt("1")) {
                    report.addMetadataInfos(metadata.getId(), metadata.getUuid(), this.metadataUtils.isMetadataDraft(metadata.getId()), this.metadataUtils.isMetadataApproved(metadata.getId()), String.format("Record status is %s. Only draft can be submitted.", currentStatus.getStatusValue().getLabel(language)));
                    continue;
                }
                this.changeMetadataStatus(context, metadata, currentStatus.getCurrentState(), "4", submitParameter.getMessage());
                if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                    listOfUpdatedRecords.add(String.valueOf(metadataApproved.getId()));
                }
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
            }
            this.dataManager.flush();
            this.metadataIndexer.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    @Operation(summary="Set the record status", description="")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Status updated."), @ApiResponse(responseCode="400", description="Metadata workflow not enabled."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Map<Integer, StatusChangeType> setStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Metadata status", required=true) @RequestBody(required=true) MetadataStatusParameter status, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer groupOwnerId;
        Group groupOwner;
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request, this.languageUtils.getIso3langCode(request.getLocales()));
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(request.getLocale());
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
        boolean notifyByEmail = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.settingManager.getValue("system/metadataprivs/publication/notificationLevel")});
        int author = context.getUserSession().getUserIdAsInt();
        MetadataStatus metadataStatusValue = this.convertParameter(metadata.getId(), metadata.getUuid(), status, author);
        if (metadataStatusValue.getStatusValue().getType() == StatusValueType.workflow && !isMdWorkflowEnable) {
            throw new FeatureNotEnabledException("Metadata workflow is disabled, can not be set the status of metadata").withMessageKey("exception.resourceNotEnabled.workflow").withDescriptionKey("exception.resourceNotEnabled.workflow.description");
        }
        if (metadataStatusValue.getStatusValue().getType() == StatusValueType.workflow && this.metadataStatus.getStatus(metadata.getId()) == null && !WorkflowUtil.isGroupWithEnabledWorkflow((String)(groupOwner = (Group)this.groupRepository.findById((Object)(groupOwnerId = metadata.getSourceInfo().getGroupOwner())).orElseThrow(() -> new ResourceNotFoundException(MessageFormat.format(messages.getString("api.groups.group_not_found"), groupOwnerId)))).getName())) {
            throw new FeatureNotEnabledException("Metadata workflow is disabled for group '" + groupOwner.getName() + "', metadata status can not be set").withMessageKey("exception.resourceNotEnabled.groupWorkflow", new Object[]{groupOwner.getName()}).withDescriptionKey("exception.resourceNotEnabled.groupWorkflow.description", new Object[]{groupOwner.getName()});
        }
        if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
            throw new SecurityException(messages.getString("api.metadata.status.errorSetStatusNotAllowed"));
        }
        boolean isAllowedSubmitApproveInvalidMd = this.settingManager.getValueAsBool("metadata/workflow/allowSubmitApproveInvalidMd");
        if (!(status.getStatus() != Integer.parseInt("4") && status.getStatus() != Integer.parseInt("2") || isAllowedSubmitApproveInvalidMd)) {
            this.metadataValidator.doValidate(metadata, context.getLanguage());
            boolean isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, context);
            if (isInvalid) {
                throw new NotAllowedException("Metadata is invalid: can't be submitted or approved").withMessageKey("exception.resourceInvalid.metadata").withDescriptionKey("exception.resourceInvalid.metadata.description");
            }
        }
        StatusActions sa = this.statusActionFactory.createStatusActions(context);
        String metadataCurrentStatus = this.dataManager.getCurrentStatus(metadata.getId());
        metadataStatusValue.setPreviousState(metadataCurrentStatus);
        ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
        listOfStatusChange.add(metadataStatusValue);
        Map statusUpdate = sa.onStatusChange(listOfStatusChange, false);
        int metadataIdApproved = metadata.getId();
        if (statusUpdate.get(metadata.getId()) == StatusChangeType.UPDATED) {
            Metadata metadataApproved;
            this.metadataIndexer.indexMetadata(String.valueOf(metadata.getId()), true, IndexingMode.full);
            if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                metadataIdApproved = metadataApproved.getId();
                this.metadataIndexer.indexMetadata(String.valueOf(metadataApproved.getId()), true, IndexingMode.full);
            }
        }
        if (status.getStatus() == Integer.parseInt("2") && notifyByEmail && this.metadataUtils.isMetadataPublished(metadataIdApproved)) {
            MetadataPublicationNotificationInfo metadataNotificationInfo = new MetadataPublicationNotificationInfo();
            metadataNotificationInfo.setMetadataUuid(metadata.getUuid());
            metadataNotificationInfo.setMetadataId(metadataIdApproved);
            metadataNotificationInfo.setGroupId(metadata.getSourceInfo().getGroupOwner());
            metadataNotificationInfo.setPublished(true);
            metadataNotificationInfo.setPublicationDateStamp(new ISODate());
            metadataNotificationInfo.setReapproval(metadataIdApproved != metadata.getId());
            if (isMdWorkflowEnable) {
                String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
                List statusList = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadata.getId(), StatusValueType.workflow, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField}));
                Optional reviewerUser = this.userRepository.findById((Object)metadataStatusValue.getUserId());
                reviewerUser.ifPresent(user -> {
                    metadataNotificationInfo.setReviewerUser(user.getUsername());
                    metadataNotificationInfo.setPublisherUser(user.getUsername());
                });
                Optional<MetadataStatus> submittedStatus = statusList.stream().filter(status1 -> status1.getStatusValue().getId() == Integer.parseInt("4")).findFirst();
                if (submittedStatus.isPresent()) {
                    Optional submitterUser = this.userRepository.findById((Object)submittedStatus.get().getUserId());
                    submitterUser.ifPresent(user -> metadataNotificationInfo.setSubmitterUser(user.getUsername()));
                }
            }
            metadataListToNotifyPublication.add(metadataNotificationInfo);
            this.metadataPublicationMailNotifier.notifyPublication(feedbackLocales, metadataListToNotifyPublication);
        }
        return statusUpdate;
    }

    @Operation(summary="Close a record task", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/close"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Task closed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Status not found."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void closeTask(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(description="Close date", required=true) @RequestParam String closeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatusValue = this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(metadata.getId(), statusId, userId, new ISODate(changeDate));
        if (metadataStatusValue == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%s', user '%d' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.update((Serializable)Integer.valueOf(metadataStatusValue.getId()), entity -> entity.setCloseDate(new ISODate(closeDate)));
    }

    @Operation(summary="Delete a record status", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Status removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Status not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRecordStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatusValue = this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(metadata.getId(), statusId, userId, new ISODate(changeDate));
        if (metadataStatusValue == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%s', user '%d' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.delete((Object)metadataStatusValue);
    }

    @Operation(summary="Delete all record status", description="")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Status removed.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Status not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllRecordStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        this.metadataStatusRepository.deleteAllById_MetadataId(Integer.valueOf(metadata.getId()));
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Search status", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET}, path={"/status/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('RegisteredUser')")
    @ResponseBody
    public List<MetadataStatusResponse> getWorkflowStatusByType(@Parameter(description="One or more types to retrieve (ie. worflow, event, task). Default is all.", required=false) @RequestParam(required=false) List<StatusValueType> type, @Parameter(description="All event details including XML changes. Responses are bigger. Default is false", required=false) @RequestParam(required=false) boolean details, @Parameter(description="Sort Order (ie. DESC or ASC). Default is none.", required=false) @RequestParam(required=false) Sort.Direction sortOrder, @Parameter(description="One or more event author. Default is all.", required=false) @RequestParam(required=false) List<Integer> author, @Parameter(description="One or more event owners. Default is all.", required=false) @RequestParam(required=false) List<Integer> owner, @Parameter(description="One or more record identifier. Default is all.", required=false) @RequestParam(required=false) List<Integer> id, @Parameter(description="One or more metadata record identifier. Default is all.", required=false) @RequestParam(required=false) List<Integer> recordIdentifier, @Parameter(description="One or more metadata uuid. Default is all.", required=false) @RequestParam(required=false) List<String> uuid, @Parameter(description="One or more status id. Default is all.", required=false) @RequestParam(required=false) List<String> statusIds, @Parameter(description="Start date", required=false) @RequestParam(required=false) String dateFrom, @Parameter(description="End date", required=false) @RequestParam(required=false) String dateTo, @Parameter(description="From page", required=false) @RequestParam(required=false, defaultValue="0") Integer from, @Parameter(description="Number of records to return", required=false) @RequestParam(required=false, defaultValue="100") Integer size, HttpServletRequest request) throws Exception {
        void var24_32;
        PageRequest pageRequest;
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        Profile userProfile = context.getUserSession().getProfile();
        String minimumAllowedProfileName = (String)StringUtils.defaultIfBlank((CharSequence)this.settingManager.getValue("metadata/history/accesslevel"), (CharSequence)Profile.Editor.toString());
        Profile minimumAllowedProfile = Profile.valueOf((String)minimumAllowedProfileName);
        boolean isMinimumAllowedProfile = minimumAllowedProfile.getProfileAndAllParents().contains(userProfile);
        String mustBeProfileOrOwnerMessage = this.getMustBeProfileOrOwnerMessage(minimumAllowedProfileName, messages, locale);
        if (userProfile != Profile.Administrator) {
            AbstractMetadata metadata;
            if (CollectionUtils.isEmpty(recordIdentifier) && CollectionUtils.isEmpty(uuid)) {
                throw new NotAllowedException("Non administrator user must use a id or uuid parameter to search for status.");
            }
            if (!CollectionUtils.isEmpty(recordIdentifier)) {
                for (Integer n : recordIdentifier) {
                    metadata = ApiUtils.getRecord(String.valueOf(n));
                    if (!isMinimumAllowedProfile && !this.accessManager.isOwner(context, metadata.getSourceInfo())) {
                        Log.debug((String)"geonetwork.api", (Object)mustBeProfileOrOwnerMessage);
                        throw new NotAllowedException(mustBeProfileOrOwnerMessage);
                    }
                    this.checkUserCanSeeHistory(minimumAllowedProfile, String.valueOf(n), messages, request);
                }
            }
            if (!CollectionUtils.isEmpty(uuid)) {
                for (String string : uuid) {
                    metadata = ApiUtils.getRecord(string);
                    if (!isMinimumAllowedProfile && !this.accessManager.isOwner(context, metadata.getSourceInfo())) {
                        Log.debug((String)"geonetwork.api", (Object)mustBeProfileOrOwnerMessage);
                        throw new NotAllowedException(mustBeProfileOrOwnerMessage);
                    }
                    this.checkUserCanSeeHistory(minimumAllowedProfile, string, messages, request);
                }
            }
        }
        if (sortOrder != null) {
            Sort sort = SortUtils.createSort((Sort.Direction)sortOrder, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate}).and(SortUtils.createSort((Sort.Direction)sortOrder, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id}));
            pageRequest = PageRequest.of((int)from, (int)size, (Sort)sort);
        } else {
            Sort sort = SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate}).and(SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id}));
            pageRequest = PageRequest.of((int)from, (int)size, (Sort)sort);
        }
        if (CollectionUtils.isNotEmpty(id) || CollectionUtils.isNotEmpty(uuid) || CollectionUtils.isNotEmpty(type) || CollectionUtils.isNotEmpty(author) || CollectionUtils.isNotEmpty(owner) || CollectionUtils.isNotEmpty(recordIdentifier) || CollectionUtils.isNotEmpty(statusIds)) {
            List list = this.metadataStatusRepository.searchStatus(id, uuid, type, author, owner, recordIdentifier, statusIds, dateFrom, dateTo, (Pageable)pageRequest);
        } else {
            List list = this.metadataStatusRepository.findAll((Pageable)pageRequest).getContent();
        }
        return this.buildMetadataStatusResponses((List<MetadataStatus>)var24_32, details, context.getLanguage());
    }

    private MetadataStatus convertParameter(int id, String uuid, MetadataStatusParameter parameter, int author) throws Exception {
        StatusValue statusValue = (StatusValue)this.statusValueRepository.findById((Object)parameter.getStatus()).get();
        MetadataStatus metadataStatusValue = new MetadataStatus();
        metadataStatusValue.setMetadataId(id);
        metadataStatusValue.setUuid(uuid);
        metadataStatusValue.setChangeDate(new ISODate());
        metadataStatusValue.setUserId(author);
        metadataStatusValue.setStatusValue(statusValue);
        if (parameter.getChangeMessage() != null) {
            metadataStatusValue.setChangeMessage(parameter.getChangeMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter.getDueDate())) {
            metadataStatusValue.setDueDate(new ISODate(parameter.getDueDate()));
        }
        if (StringUtils.isNotEmpty((CharSequence)parameter.getCloseDate())) {
            metadataStatusValue.setCloseDate(new ISODate(parameter.getCloseDate()));
        }
        if (parameter.getOwner() != null) {
            metadataStatusValue.setOwner(parameter.getOwner());
        }
        return metadataStatusValue;
    }

    @Operation(summary="Get saved content from the status record before changes", description="")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/before"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Previous version of the record."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String showStatusBefore(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        MetadataStatus metadataStatusValue = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        return this.getValidatedStateText(metadataStatusValue, State.BEFORE, request, httpSession);
    }

    @Operation(summary="Get saved content from the status record after changes")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/after"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Version of the record after changes."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String showStatusAfter(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        MetadataStatus metadataStatusValue = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        return this.getValidatedStateText(metadataStatusValue, State.AFTER, request, httpSession);
    }

    @Operation(summary="Restore saved content from a status record")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/restore"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record restored."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void restoreAtStatusSave(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Status identifier", required=true) @PathVariable int statusId, @Parameter(description="User identifier", required=true) @PathVariable int userId, @Parameter(description="Change date", required=true) @PathVariable String changeDate, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        MetadataStatus metadataStatusValue = this.getMetadataStatus(metadataUuid, statusId, userId, changeDate);
        String previousStateText = this.getValidatedStateText(metadataStatusValue, State.BEFORE, request, httpSession);
        try {
            metadata = ApiUtils.canEditRecord(metadataStatusValue.getUuid(), request);
        }
        catch (ResourceNotFoundException e) {
            metadata = null;
        }
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());
        Element beforeMetadata = null;
        String xmlBefore = null;
        if (metadata != null) {
            beforeMetadata = this.dataManager.getMetadata(context, String.valueOf(metadata.getId()), false, false, false);
            XMLOutputter outp = new XMLOutputter();
            if (beforeMetadata != null) {
                xmlBefore = outp.outputString(beforeMetadata);
            }
            if (xmlBefore.equals(previousStateText)) {
                throw new NotAllowedException("Error recovering metadata id " + metadataUuid + ". Cannot recover record which are identical. Possibly already recovered.");
            }
        }
        Integer recoveredMetadataId = null;
        if (metadata != null) {
            Element md = Xml.loadString((String)previousStateText, (boolean)false);
            Element mdNoGeonetInfo = this.metadataUtils.removeMetadataInfo(md);
            this.metadataManager.updateMetadata(context, String.valueOf(metadata.getId()), mdNoGeonetInfo, false, true, context.getLanguage(), null, true, IndexingMode.full);
            recoveredMetadataId = metadata.getId();
        } else {
            Element element = null;
            try {
                element = Xml.loadString((String)previousStateText, (boolean)false);
            }
            catch (JDOMParseException ex) {
                throw new IllegalArgumentException(String.format("XML fragment is invalid. Error is %s", ex.getMessage()));
            }
            recoveredMetadataId = this.reloadRecord(element, this.metadataManager, httpSession, request);
        }
        this.metadataIndexer.indexMetadata(String.valueOf(recoveredMetadataId), true, IndexingMode.full);
        UserSession session = ApiUtils.getUserSession(request.getSession());
        if (session != null) {
            Element afterMetadata = this.dataManager.getMetadata(context, String.valueOf(recoveredMetadataId), false, false, false);
            XMLOutputter outp = new XMLOutputter();
            String xmlAfter = outp.outputString(afterMetadata);
            new RecordRestoredEvent(recoveredMetadataId, metadataStatusValue.getUuid(), Integer.valueOf(session.getUserIdAsInt()), xmlBefore, xmlAfter, metadataStatusValue).publish((ApplicationContext)applicationContext);
        }
    }

    private List<MetadataStatusResponse> buildMetadataStatusResponses(List<MetadataStatus> listOfStatus, boolean details, String language) {
        ArrayList<MetadataStatusResponse> response = new ArrayList<MetadataStatusResponse>();
        HashMap<Integer, User> listOfUsers = new HashMap<Integer, User>();
        for (MetadataStatus s : listOfStatus) {
            if (listOfUsers.get(s.getUserId()) == null) {
                listOfUsers.put(s.getUserId(), (User)this.userRepository.findById((Object)s.getUserId()).get());
            }
            if (s.getOwner() == null || listOfUsers.get(s.getOwner()) != null) continue;
            Optional user = this.userRepository.findById((Object)s.getOwner());
            user.ifPresent(value -> listOfUsers.put(s.getOwner(), (User)value));
        }
        HashMap<Integer, String> titles = new HashMap<Integer, String>();
        for (MetadataStatus s : listOfStatus) {
            User owner;
            MetadataStatusResponse status = new MetadataStatusResponse(s, details);
            User author = (User)listOfUsers.get(status.getUserId());
            if (author != null) {
                status.setAuthorName(author.getName() + " " + author.getSurname());
                status.setAuthorEmail(author.getEmail());
            }
            if (s.getOwner() != null && (owner = (User)listOfUsers.get(status.getOwner())) != null) {
                status.setOwnerName(owner.getName() + " " + owner.getSurname());
                status.setOwnerEmail(owner.getEmail());
            }
            status.setDateChange(s.getChangeDate().getDateAndTime());
            if (s.getStatusValue().getType().equals((Object)StatusValueType.event)) {
                status.setCurrentStatus(this.extractCurrentStatus(s));
                status.setPreviousStatus(this.extractPreviousStatus(s));
            } else if (s.getStatusValue().getType().equals((Object)StatusValueType.task)) {
                if (s.getDueDate() != null) {
                    status.setDateDue(s.getDueDate().getDateAndTime());
                }
                if (s.getCloseDate() != null) {
                    status.setDateClose(s.getCloseDate().getDateAndTime());
                }
            }
            if (s.getTitles() != null && s.getTitles().size() > 0) {
                status.setTitle(s.getTitles().getOrDefault(language, s.getTitles().getOrDefault(language.substring(0, 2), (String)s.getTitles().entrySet().iterator().next().getValue())));
            }
            if (status.getTitle() == null || status.getTitle().length() == 0) {
                String title = (String)titles.get(s.getMetadataId());
                if (title == null) {
                    try {
                        HashSet<String> fields = new HashSet<String>();
                        String titleField = "resourceTitleObject";
                        fields.add(titleField);
                        Optional metadata = this.metadataRepository.findById((Object)s.getMetadataId());
                        Map values = this.searchManager.getFieldsValues(((Metadata)metadata.get()).getUuid(), fields, language);
                        title = (String)values.get(titleField);
                        titles.put(s.getMetadataId(), title);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                status.setTitle(title);
            }
            status.setUuid(s.getUuid());
            response.add(status);
        }
        return response;
    }

    private String extractCurrentStatus(MetadataStatus s) {
        switch (StatusValue.Events.fromId((Integer)s.getStatusValue().getId())) {
            case ATTACHMENTADDED: {
                return s.getCurrentState();
            }
            case RECORDOWNERCHANGE: 
            case RECORDGROUPOWNERCHANGE: {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"owner", (String)"name");
            }
            case RECORDPROCESSINGCHANGE: {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"process");
            }
            case RECORDCATEGORYCHANGE: {
                List categories = ObjectJSONUtils.extractListOfFieldFromJSONString((String)s.getCurrentState(), (String)"category", (String)"name");
                StringBuilder categoriesAsString = new StringBuilder("[ ");
                for (String categoryName : categories) {
                    categoriesAsString.append(categoryName).append(" ");
                }
                categoriesAsString.append("]");
                return categoriesAsString.toString();
            }
            case RECORDVALIDATIONTRIGGERED: {
                if (s.getCurrentState() == null) {
                    return "UNKNOWN";
                }
                if (s.getCurrentState().equals("1")) {
                    return "OK";
                }
                return "KO";
            }
        }
        return "";
    }

    private String extractPreviousStatus(MetadataStatus s) {
        switch (StatusValue.Events.fromId((Integer)s.getStatusValue().getId())) {
            case ATTACHMENTDELETED: {
                return s.getPreviousState();
            }
            case RECORDOWNERCHANGE: 
            case RECORDGROUPOWNERCHANGE: {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getPreviousState(), (String)"owner", (String)"name");
            }
        }
        return "";
    }

    private void checkCanViewStatus(String metadata, HttpSession httpSession) throws Exception {
        UserSession userSession;
        Group groupEntity;
        Element xmlElement = null;
        try {
            xmlElement = Xml.loadString((String)metadata, (boolean)false);
        }
        catch (JDOMParseException ex) {
            throw new IllegalArgumentException(String.format("XML fragment is invalid. Error is %s", ex.getMessage()));
        }
        Element info = xmlElement.getChild("info", Edit.NAMESPACE);
        if (info == null) {
            throw new IllegalArgumentException("Can't locate required geonet:info which is required for the recovery. May need to manually re-import the data");
        }
        String groupOwnerName = info.getChildText("groupOwnerName");
        String groupId = null;
        if (groupOwnerName != null && (groupEntity = this.groupRepository.findByName(groupOwnerName)) != null) {
            groupId = String.valueOf(groupEntity.getId());
        }
        if ((userSession = ApiUtils.getUserSession(httpSession)).getProfile() != Profile.Administrator) {
            if (groupId != null) {
                List editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor);
                if (!editingGroupList.contains(Integer.valueOf(groupId))) {
                    throw new SecurityException(String.format("You can't view history from this group (%s). User MUST be an Editor in that group", groupOwnerName));
                }
            } else {
                throw new SecurityException("Error identify group where this metadata belong to. Only administrator can view this record");
            }
        }
    }

    private int reloadRecord(Element md, IMetadataManager iMetadataManager, HttpSession httpSession, HttpServletRequest request) throws Exception {
        String uuid;
        List editingGroupList;
        UserSession userSession;
        Group groupEntity;
        Element info = md.getChild("info", Edit.NAMESPACE);
        if (info == null) {
            throw new IllegalArgumentException("Can't location geonet:info which is required for the recovery. May need to manually re-import the data");
        }
        md = this.metadataUtils.removeMetadataInfo(md);
        String groupOwnerName = info.getChildText("groupOwnerName");
        String groupId = null;
        if (groupOwnerName != null && (groupEntity = this.groupRepository.findByName(groupOwnerName)) != null) {
            groupId = String.valueOf(groupEntity.getId());
        }
        if ((userSession = ApiUtils.getUserSession(httpSession)).getProfile() != Profile.Administrator && groupId != null && !(editingGroupList = AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor)).contains(Integer.valueOf(groupId))) {
            throw new SecurityException(String.format("You can't create a record in this group (%s). User MUST be an Editor in that group", groupOwnerName));
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        String schema = info.getChildText("schema");
        if (schema == null) {
            try {
                schema = this.dataManager.autodetectSchema(md);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't detect schema for metadata automatically. You could try to force the schema with the schema parameter.");
            }
        }
        if ((uuid = info.getChildText("uuid")) == null && (uuid = this.metadataUtils.extractUUID(schema, md)).length() == 0) {
            throw new IllegalArgumentException("Could not locate the UUID for the document being restored.");
        }
        if (this.metadataRepository.findOneByUuid(uuid) != null) {
            throw new IllegalArgumentException(String.format("A record with UUID '%s' already exist", uuid));
        }
        String date = new ISODate().toString();
        boolean ufo = false;
        String metadataId = iMetadataManager.insertMetadata(context, schema, md, uuid, context.getUserSession().getUserIdAsInt(), groupId, this.settingManager.getSiteId(), MetadataType.METADATA.codeString, null, null, date, date, ufo, IndexingMode.none);
        int id = Integer.parseInt(metadataId);
        List categoryList = info.getChildren("category");
        if (categoryList != null && !categoryList.isEmpty()) {
            for (Element cat : categoryList) {
                String catName = cat.getText();
                MetadataCategory metadataCategory = this.categoryRepository.findOneByName(catName);
                if (metadataCategory == null) continue;
                this.dataManager.setCategory(context, metadataId, String.valueOf(metadataCategory.getId()));
            }
        }
        return id;
    }

    private MetadataStatus getMetadataStatus(String uuidOrInternalId, int statusId, int userId, String changeDate) throws ResourceNotFoundException {
        MetadataStatus metadataStatusValue = uuidOrInternalId.matches("\\d+") ? this.metadataStatusRepository.findOneByMetadataIdAndStatusValue_IdAndUserIdAndChangeDate(Integer.valueOf(uuidOrInternalId).intValue(), statusId, userId, new ISODate(changeDate)) : this.metadataStatusRepository.findOneByUuidAndStatusValue_IdAndUserIdAndChangeDate(uuidOrInternalId, statusId, userId, new ISODate(changeDate));
        if (metadataStatusValue == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%s', user '%d', status, '%d' at date '%s'", uuidOrInternalId, userId, statusId, changeDate));
        }
        return metadataStatusValue;
    }

    private String getValidatedStateText(MetadataStatus metadataStatus, State state, HttpServletRequest request, HttpSession httpSession) throws Exception {
        MediaType stateFormat;
        String stateText;
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        if (!StatusValueType.event.equals((Object)metadataStatus.getStatusValue().getType()) || !ArrayUtils.contains((Object[])supportedRestoreStatuses, (Object)StatusValue.Events.fromId((Integer)metadataStatus.getStatusValue().getId()))) {
            throw new NotAllowedException("Unsupported action on status type '" + metadataStatus.getStatusValue().getType() + "' for metadata '" + metadataStatus.getUuid() + "'. Supports status type '" + StatusValueType.event + "' with the status id '" + Arrays.stream(supportedRestoreStatuses).map(StatusValue.Events::getId).collect(Collectors.toList()) + "'.");
        }
        if (state.equals((Object)State.AFTER)) {
            stateText = metadataStatus.getCurrentState();
            stateFormat = StatusValue.Events.fromId((Integer)metadataStatus.getStatusValue().getId()).getCurrentStateFormat();
        } else {
            stateText = metadataStatus.getPreviousState();
            stateFormat = StatusValue.Events.fromId((Integer)metadataStatus.getStatusValue().getId()).getPreviousStateFormat();
        }
        String xmlStateText = stateFormat.equals((Object)MediaType.APPLICATION_JSON) ? ObjectJSONUtils.extractFieldFromJSONString((String)stateText, (String)"xmlRecord") : stateText;
        if (xmlStateText == null) {
            throw new ResourceNotFoundException(String.format("No data exists for previous state on metadata record '%s', user '%d' at date '%s'", metadataStatus.getUuid(), metadataStatus.getUserId(), metadataStatus.getChangeDate()));
        }
        try {
            ApiUtils.canEditRecord(metadataStatus.getUuid(), request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException(messages.getString("exception.notAllowed.cannotView"));
        }
        catch (ResourceNotFoundException e) {
            this.checkCanViewStatus(xmlStateText, httpSession);
        }
        return xmlStateText;
    }

    private void checkWorkflowEnabled() throws FeatureNotEnabledException {
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (!isMdWorkflowEnable) {
            throw new FeatureNotEnabledException("Metadata workflow is disabled, can not be set the status of metadata").withMessageKey("exception.resourceNotEnabled.workflow").withDescriptionKey("exception.resourceNotEnabled.workflow.description");
        }
    }

    private boolean isAllowedMetadataStatusChange(ServiceContext context, AbstractMetadata metadata, MetadataProcessingReport report) throws Exception {
        boolean isInvalid;
        boolean isAllowedSubmitApproveInvalidMd = this.settingManager.getValueAsBool("metadata/workflow/allowSubmitApproveInvalidMd");
        if (!isAllowedSubmitApproveInvalidMd && (isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, context))) {
            report.addMetadataInfos(metadata.getId(), metadata.getUuid(), true, false, "Metadata is invalid: can't be approved");
            return false;
        }
        return true;
    }

    private void changeMetadataStatus(ServiceContext context, AbstractMetadata metadata, String previousStatus, String newStatus, String changeMessage) throws Exception {
        StatusActions sa = this.statusActionFactory.createStatusActions(context);
        MetadataStatusParameter status = new MetadataStatusParameter();
        status.setStatus(Integer.parseInt(newStatus));
        status.setChangeMessage(changeMessage);
        int author = context.getUserSession().getUserIdAsInt();
        MetadataStatus metadataStatusValue = this.convertParameter(metadata.getId(), metadata.getUuid(), status, author);
        metadataStatusValue.setPreviousState(previousStatus);
        ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
        listOfStatusChange.add(metadataStatusValue);
        sa.onStatusChange(listOfStatusChange, true);
    }

    private String getMustBeProfileOrOwnerMessage(String minimumAllowedProfileName, ResourceBundle messages, Locale locale) {
        Translator jsonLocTranslator = this.translatorFactory.getTranslator("apploc:", locale.getISO3Language());
        return MessageFormat.format(messages.getString("exception.notAllowed.mustBeProfileOrOwner"), jsonLocTranslator.translate(minimumAllowedProfileName));
    }

    private void checkUserCanSeeHistory(Profile minimumAllowedProfile, String recordId, ResourceBundle messages, HttpServletRequest request) throws Exception {
        if (minimumAllowedProfile == Profile.RegisteredUser) {
            try {
                ApiUtils.canViewRecord(recordId, request);
            }
            catch (SecurityException e) {
                Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
                throw new NotAllowedException(messages.getString("exception.notAllowed.cannotView"));
            }
        }
        if (minimumAllowedProfile == Profile.Editor) {
            try {
                ApiUtils.canEditRecord(recordId, request);
            }
            catch (SecurityException e) {
                Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
                throw new NotAllowedException(messages.getString("exception.notAllowed.cannotEdit"));
            }
        }
    }

    private static enum State {
        BEFORE,
        AFTER;

    }
}

