/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.DatabaseProcessUtils;
import org.fao.geonet.api.processing.report.MetadataReplacementProcessingReport;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.events.history.RecordProcessingChangeEvent;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.UserUtil;
import org.fao.geonet.utils.Diff;
import org.fao.geonet.utils.DiffType;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/processes/db"})
@Tag(name="processes", description="Processing operations")
@Controller(value="dbprocess")
@ReadWriteController
public class DatabaseProcessApi {
    @Autowired
    DataManager dataMan;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    SchemaManager schemaMan;
    @Autowired
    SettingManager settingManager;
    @Autowired
    RoleHierarchy roleHierarchy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Preview of search and replace text.", description=" When errors occur during processing, the processing report is returned in JSON format.")
    @RequestMapping(value={"/search-and-replace"}, method={RequestMethod.GET}, consumes={"text/html", "*/*"}, produces={"*/*"})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Processed records."), @ApiResponse(responseCode="500", description="If one record processed is invalid."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public ResponseEntity<Object> previewProcessSearchAndReplace(@Parameter(description="Use regular expression (may not be supported by all databases - tested with H2 and PostgreSQL)", required=false) @RequestParam(required=false, defaultValue="false") boolean useRegexp, @Parameter(description="Value to search for") @RequestParam String search, @Parameter(description="Replacement") @RequestParam(defaultValue="") String replace, @Parameter(description="regexpFlags") @RequestParam(required=false, defaultValue="") String regexpFlags, @Parameter(description="Return differences with diff, diffhtml or patch", required=false) @RequestParam(required=false) DiffType diffType, @Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response) throws IllegalArgumentException {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Element preview = new Element("preview");
        try (MetadataReplacementProcessingReport processingReport = new MetadataReplacementProcessingReport(search + "-" + replace);){
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            UserUtil.checkUserProfileLevel((UserSession)serviceContext.getUserSession(), (SettingManager)this.settingManager, (RoleHierarchy)this.roleHierarchy, (String)"metadata/batchediting/accesslevel", (Profile)Profile.Editor, (String)"batch edit metadata");
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
            String siteURL = request.getRequestURL().toString() + "?" + request.getQueryString();
            for (String uuid : records) {
                String id = String.valueOf(this.metadataUtils.findOneByUuid(uuid).getId());
                Log.info((String)"org.fao.geonet.services.metadata", (Object)("Processing metadata for preview with id:" + id));
                Element record = DatabaseProcessUtils.process(serviceContext, id, useRegexp, search, replace, regexpFlags, false, false, false, processingReport);
                if (record == null) continue;
                if (diffType != null) {
                    AbstractMetadata metadata = this.metadataUtils.findOne(id);
                    preview.addContent(Diff.diff((String)metadata.getData(), (String)Xml.getString((Element)record), (DiffType)diffType));
                    continue;
                }
                preview.addContent(record.detach());
            }
        }
        if (processingReport.getMetadataErrors().size() > 0) {
            response.setHeader("Content-Type", "application/json");
            response.setStatus(500);
            ObjectMapper mapper = new ObjectMapper();
            try {
                return new ResponseEntity((Object)mapper.writeValueAsString((Object)processingReport), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (JsonProcessingException errorReportException) {
                return new ResponseEntity((Object)String.format("Failed to generate error report due to '%s'.", errorReportException.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((Object)preview, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Apply a database search and replace to one or more records", description="Process a metadata with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process.")
    @RequestMapping(value={"/search-and-replace"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about processed records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public XsltMetadataProcessingReport processSearchAndReplace(@Parameter(description="Use regular expression (may not be supported by all databases - tested with H2 and PostgreSQL)", required=false) @RequestParam(required=false, defaultValue="false") boolean useRegexp, @Parameter(description="Value to search for") @RequestParam String search, @Parameter(description="Replacement") @RequestParam(defaultValue="") String replace, @Parameter(description="regexpFlags") @RequestParam(required=false, defaultValue="") String regexpFlags, @Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="If true updates the DateStamp (or equivalent in standards different to ISO 19139) field in the metadata with the current timestamp", required=false) @RequestParam(required=false, defaultValue="true") boolean updateDateStamp, @Parameter(description="Index after processing", required=false, example="false") @RequestParam(required=false, defaultValue="true") boolean index, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        try (MetadataReplacementProcessingReport processingReport = new MetadataReplacementProcessingReport(search + "-" + replace);){
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            UserUtil.checkUserProfileLevel((UserSession)serviceContext.getUserSession(), (SettingManager)this.settingManager, (RoleHierarchy)this.roleHierarchy, (String)"metadata/batchediting/accesslevel", (Profile)Profile.Editor, (String)"batch edit metadata");
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
            UserSession userSession = ApiUtils.getUserSession(httpSession);
            String siteURL = request.getRequestURL().toString() + "?" + request.getQueryString();
            processingReport.setTotalRecords(records.size());
            BatchDatabaseUpdateMetadataReindexer m = new BatchDatabaseUpdateMetadataReindexer(serviceContext, this.dataMan, records, useRegexp, search, replace, regexpFlags, httpSession, siteURL, processingReport, request, index, updateDateStamp, userSession.getUserIdAsInt());
            m.process(this.settingManager.getSiteId());
        }
        return processingReport;
    }

    static final class BatchDatabaseUpdateMetadataReindexer
    extends MetadataIndexerProcessor {
        private final boolean index;
        private final boolean updateDateStamp;
        Set<String> records;
        boolean useRegexp;
        String search;
        String replace;
        String regexpFlags;
        String siteURL;
        HttpSession session;
        MetadataReplacementProcessingReport processingReport;
        HttpServletRequest request;
        ServiceContext context;
        int userId;

        public BatchDatabaseUpdateMetadataReindexer(ServiceContext context, DataManager dm, Set<String> records, boolean useRegexp, String search, String replace, String regexpFlags, HttpSession session, String siteURL, MetadataReplacementProcessingReport processingReport, HttpServletRequest request, boolean index, boolean updateDateStamp, int userId) {
            super(dm);
            this.records = records;
            this.useRegexp = useRegexp;
            this.search = search;
            this.replace = replace;
            this.regexpFlags = regexpFlags;
            this.session = session;
            this.index = index;
            this.updateDateStamp = updateDateStamp;
            this.siteURL = siteURL;
            this.request = request;
            this.processingReport = processingReport;
            this.context = context;
            this.userId = userId;
        }

        public void process(String catalogueId) throws Exception {
            DataManager dataMan = (DataManager)this.context.getBean(DataManager.class);
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            for (String uuid : this.records) {
                String id = String.valueOf(((IMetadataUtils)this.context.getBean(IMetadataUtils.class)).findOneByUuid(uuid).getId());
                Log.info((String)"org.fao.geonet.services.metadata", (Object)("Processing metadata with id:" + id));
                Element beforeMetadata = dataMan.getMetadata(this.context, id, false, false, false);
                Element record = DatabaseProcessUtils.process(ApiUtils.createServiceContext(this.request), id, this.useRegexp, this.search, this.replace, this.regexpFlags, true, this.index, this.updateDateStamp, this.processingReport);
                Element afterMetadata = dataMan.getMetadata(this.context, id, false, false, false);
                XMLOutputter outp = new XMLOutputter();
                String xmlAfter = outp.outputString(afterMetadata);
                String xmlBefore = outp.outputString(beforeMetadata);
                new RecordProcessingChangeEvent(Long.valueOf(Long.parseLong(id)), Integer.valueOf(this.userId), xmlBefore, xmlAfter, this.processingReport.getProcessId()).publish((ApplicationContext)appContext);
            }
        }
    }
}

