/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.io.StringReader;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.lang.arq.ARQParser;
import org.apache.jena.sparql.lang.arq.ParseException;
import org.apache.jena.sparql.lang.arq.Token;
import org.apache.jena.sparql.lang.arq.TokenMgrError;
import org.apache.jena.sparql.serializer.FmtExprSPARQL;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.SSE_ParseException;
import org.apache.jena.sparql.sse.builders.SSE_ExprBuildException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sys.JenaSystem;

public class ExprUtils {
    @Deprecated
    public static Expr nodeToExpr(Node n) {
        return ExprLib.nodeToExpr(n);
    }

    public static Expr parse(String s) {
        return ExprUtils.parse(s, ARQConstants.getGlobalPrefixMap());
    }

    public static Expr parse(String s, PrefixMapping pmap) {
        Query query = QueryFactory.make();
        query.setPrefixMapping(pmap);
        return ExprUtils.parse(query, s, true);
    }

    public static Expr parse(String s, PrefixMapping pmap, String baseURI) {
        Query query = QueryFactory.make();
        if (pmap != null) {
            query.setPrefixMapping(pmap);
        }
        if (baseURI != null) {
            query.setBaseURI(baseURI);
        }
        return ExprUtils.parse(query, s, true);
    }

    public static Expr parse(Query query, String s, boolean checkAllUsed) {
        try {
            StringReader in = new StringReader(s);
            ARQParser parser = new ARQParser(in);
            parser.setQuery(query);
            Expr expr = parser.Expression();
            if (checkAllUsed) {
                Token t = parser.getNextToken();
                if (t.kind != 0) {
                    throw new QueryParseException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
                }
            }
            return expr;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginLine);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    public static NodeValue parseNodeValue(String s) {
        Node n = NodeFactoryExtra.parseNode(s);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr, SerializationContext sCxt) {
        FmtExprSPARQL v = new FmtExprSPARQL(iOut, sCxt);
        v.format(expr);
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr) {
        ExprUtils.fmtSPARQL(iOut, expr, FmtUtils.sCxt());
    }

    public static String fmtSPARQL(Expr expr) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL((IndentedWriter)buff, expr);
        return buff.toString();
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs, SerializationContext pmap) {
        FmtExprSPARQL fmt = new FmtExprSPARQL(iOut, pmap);
        String sep = "";
        for (Expr expr : exprs) {
            iOut.print(sep);
            sep = " , ";
            fmt.format(expr);
        }
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs) {
        ExprUtils.fmtSPARQL(iOut, exprs, FmtUtils.sCxt());
    }

    public static String fmtSPARQL(ExprList exprs) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL((IndentedWriter)buff, exprs);
        return buff.toString();
    }

    public static String fmtSPARQL(ExprList exprs, SerializationContext sCxt) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL((IndentedWriter)buff, exprs, sCxt);
        return buff.toString();
    }

    public static String strComparison(int cmp) {
        switch (cmp) {
            case 1: {
                return "GT";
            }
            case 0: {
                return "EQ";
            }
            case -1: {
                return "LT";
            }
            case 2: {
                return "indeterminate";
            }
        }
        return "??";
    }

    public static void expr(String exprStr) {
        ExprUtils.expr(exprStr, null);
    }

    public static void expr(String exprStr, Binding binding) {
        try {
            Expr expr = ExprUtils.parse(exprStr, ARQConstants.getGlobalPrefixMap());
            ExprUtils.evalPrint(expr, binding);
        }
        catch (QueryParseException ex) {
            System.err.println("Parse error: " + ex.getMessage());
            return;
        }
    }

    public static void exprPrefix(String exprStr) {
        ExprUtils.exprPrefix(exprStr, null);
    }

    public static void evalPrint(Expr expr, Binding binding) {
        try {
            NodeValue r = ExprUtils.eval(expr, binding);
            Node n = r.asNode();
            String s = FmtUtils.stringForNode(n);
            System.out.println(s);
        }
        catch (ExprEvalException ex) {
            System.out.println("Exception: " + ex.getMessage());
            return;
        }
        catch (SSE_ExprBuildException ex) {
            System.err.println("Build exception: " + ex.getMessage());
            return;
        }
    }

    public static NodeValue eval(Expr expr) {
        return ExprUtils.eval(expr, BindingRoot.create());
    }

    public static NodeValue eval(Expr expr, Binding binding) {
        Context context2 = ARQ.getContext().copy();
        context2.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        ExecutionContext env = new ExecutionContext(context2, null, null, null);
        NodeValue r = expr.eval(binding, env);
        return r;
    }

    public static void exprPrefix(String string, Binding binding) {
        try {
            Expr expr = SSE.parseExpr(string);
            ExprUtils.evalPrint(expr, binding);
        }
        catch (SSE_ParseException ex) {
            System.err.println("Parse error: " + ex.getMessage());
            return;
        }
    }

    static {
        JenaSystem.init();
    }
}

