/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggMedian
extends AggregatorBase {
    private static Logger log = LoggerFactory.getLogger((String)"Median");
    private static final NodeValue noValuesToMedian = NodeValue.nvZERO;

    public AggMedian(Expr expr) {
        super("MEDIAN", false, expr);
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggMedian(expr.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccMedian(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToMedian);
    }

    @Override
    public int hashCode() {
        return 0x182 ^ this.getExprList().hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggMedian)) {
            return false;
        }
        AggMedian a = (AggMedian)other;
        return this.exprList.equals(a.exprList, bySyntax);
    }

    private static class AccMedian
    extends AccumulatorExpr {
        private NodeValue total = noValuesToMedian;
        private int count = 0;
        ArrayList<NodeValue> collection = new ArrayList();

        public AccMedian(Expr expr) {
            super(expr, false);
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            log.debug("median {}", (Object)nv);
            if (nv.isNumber()) {
                ++this.count;
            } else {
                throw new ExprEvalException("median: not a number: " + nv);
            }
            this.collection.add(nv);
            log.debug("median count {}", (Object)this.count);
        }

        @Override
        public NodeValue getAccValue() {
            if (this.count == 0) {
                return noValuesToMedian;
            }
            if (this.errorCount != 0L) {
                return null;
            }
            int indexsize = this.collection.size();
            double[] arrDouble = new double[indexsize];
            for (int i = 0; i < indexsize; ++i) {
                arrDouble[i] = this.collection.get(i).getDouble();
            }
            Arrays.sort(arrDouble);
            double median = indexsize % 2 != 0 ? arrDouble[indexsize / 2] : (arrDouble[indexsize / 2] + arrDouble[indexsize / 2 - 1]) / 2.0;
            return NodeValue.makeDecimal(median);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

