/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdfxml.xmlinput0.ALiteral;
import org.apache.jena.rdfxml.xmlinput0.ARP0;
import org.apache.jena.rdfxml.xmlinput0.ARPOptions;
import org.apache.jena.rdfxml.xmlinput0.AResource;
import org.apache.jena.rdfxml.xmlinput0.NamespaceHandler;
import org.apache.jena.rdfxml.xmlinput0.ParseException;
import org.apache.jena.rdfxml.xmlinput0.StatementHandler;
import org.apache.jena.rdfxml.xmlinput0.impl.ARPSaxErrorHandler;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.Checker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ReaderRIOTRDFXML0
implements ReaderRIOT {
    public static ReaderRIOTFactory factory = (language, parserProfile) -> new ReaderRIOTRDFXML0(parserProfile.getErrorHandler());
    private ErrorHandler errorHandler;
    private Context context;
    public static boolean RiotUniformCompatibility = true;
    private static int[] additionalErrors = new int[]{115};
    private static boolean errorForSpaceInURI = true;

    public ReaderRIOTRDFXML0(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        this.parse(in, null, baseURI, ct, output, context2);
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        this.parse(null, reader, baseURI, ct, output, context2);
    }

    private void oneProperty(ARPOptions options, String pName, Object value) {
        int val;
        int cond;
        block8: {
            block9: {
                block7: {
                    if (!(pName.startsWith("ERR_") || pName.startsWith("IGN_") || pName.startsWith("WARN_"))) {
                        return;
                    }
                    cond = ParseException.errorCode((String)pName);
                    if (cond == -1) {
                        throw new RiotException("No such ARP property: '" + pName + "'");
                    }
                    if (!(value instanceof String)) break block7;
                    if (!((String)value).startsWith("EM_")) {
                        throw new RiotException("Value for ARP property does not start EM_: '" + pName + "' = '" + value + "'");
                    }
                    val = ParseException.errorCode((String)((String)value));
                    if (val == -1) {
                        throw new RiotException("Illegal value for ARP property: '" + pName + "' = '" + value + "'");
                    }
                    break block8;
                }
                if (!(value instanceof Integer)) break block9;
                val = (Integer)value;
                switch (val) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break block8;
                    }
                    default: {
                        throw new RiotException("Illegal value for ARP property: '" + pName + "' = '" + value + "'");
                    }
                }
            }
            throw new RiotException("Property \"" + pName + "\" cannot have value: " + value.toString());
        }
        options.setErrorMode(cond, val);
    }

    void parse(InputStream input, Reader reader, String xmlBase, ContentType ct, StreamRDF sink, Context context2) {
        sink.start();
        HandlerSink rslt = new HandlerSink(sink, this.errorHandler);
        ARP0 arp = new ARP0();
        arp.getHandlers().setStatementHandler((StatementHandler)rslt);
        arp.getHandlers().setErrorHandler((org.xml.sax.ErrorHandler)((Object)rslt));
        arp.getHandlers().setNamespaceHandler((NamespaceHandler)rslt);
        ARPOptions arpOptions = arp.getOptions();
        if (RiotUniformCompatibility) {
            for (int code : additionalErrors) {
                arpOptions.setErrorMode(code, 2);
            }
        }
        if (context2 != null) {
            Map properties = null;
            try {
                Map p;
                properties = p = (Map)context2.get(SysRIOT.sysRdfReaderProperties);
            }
            catch (Throwable ex) {
                Log.warn((Object)this, (String)"Problem accessing the RDF/XML reader properties: properties ignored", (Throwable)ex);
            }
            if (properties != null) {
                properties.forEach((k, v) -> this.oneProperty(arpOptions, (String)k, v));
            }
        }
        arp.setOptionsWith(arpOptions);
        String filename = xmlBase;
        try {
            if (reader != null) {
                arp.load(reader, xmlBase);
            } else {
                arp.load(input, xmlBase);
            }
        }
        catch (IOException e2) {
            this.errorHandler.error(filename + ": " + ParseException.formatMessage((Exception)e2), -1L, -1L);
        }
        catch (SAXParseException e2) {
        }
        catch (SAXException sax) {
            this.errorHandler.error(filename + ": " + ParseException.formatMessage((Exception)sax), -1L, -1L);
        }
        sink.finish();
    }

    private static String baseURI_RDFXML(String baseIRI) {
        if (baseIRI == null) {
            return IRIs.getBaseStr();
        }
        return baseIRI;
    }

    private static class HandlerSink
    extends ARPSaxErrorHandler
    implements StatementHandler,
    NamespaceHandler {
        private StreamRDF output;
        private ErrorHandler riotErrorHandler;

        HandlerSink(StreamRDF output, ErrorHandler errHandler) {
            super((RDFErrorHandler)new ErrorHandlerBridge(errHandler));
            this.output = output;
            this.riotErrorHandler = errHandler;
        }

        public void statement(AResource subj, AResource pred, AResource obj) {
            this.output.triple(this.convert(subj, pred, obj));
        }

        public void statement(AResource subj, AResource pred, ALiteral lit) {
            this.output.triple(this.convert(subj, pred, lit));
        }

        private static Node convert(ALiteral lit) {
            String dtURI = lit.getDatatypeURI();
            if (dtURI == null) {
                return NodeFactory.createLiteral((String)lit.toString(), (String)lit.getLang());
            }
            if (lit.isWellFormedXML()) {
                return NodeFactory.createLiteral((String)lit.toString(), null, (boolean)true);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
            return NodeFactory.createLiteral((String)lit.toString(), (RDFDatatype)dt);
        }

        private Node convert(AResource r) {
            if (!r.isAnonymous()) {
                String uriStr = r.getURI();
                if (errorForSpaceInURI && uriStr.contains(" ")) {
                    int i = uriStr.indexOf(32);
                    String s = uriStr.substring(0, i);
                    String msg = String.format("Bad character in IRI (space): <%s[space]...>", s);
                    this.riotErrorHandler.error(msg, -1L, -1L);
                    throw new RiotParseException(msg, -1L, -1L);
                }
                return NodeFactory.createURI((String)uriStr);
            }
            Node rr = (Node)r.getUserData();
            if (rr == null) {
                rr = NodeFactory.createBlankNode();
                r.setUserData((Object)rr);
            }
            return rr;
        }

        private Triple convert(AResource s, AResource p, AResource o) {
            return Triple.create((Node)this.convert(s), (Node)this.convert(p), (Node)this.convert(o));
        }

        private Triple convert(AResource s, AResource p, ALiteral o) {
            Node literal = HandlerSink.convert(o);
            Checker.checkLiteral(literal, this.riotErrorHandler, -1L, -1L);
            return Triple.create((Node)this.convert(s), (Node)this.convert(p), (Node)literal);
        }

        public void startPrefixMapping(String prefix, String uri) {
            this.output.prefix(prefix, uri);
        }

        public void endPrefixMapping(String prefix) {
        }
    }

    private static class ErrorHandlerBridge
    implements RDFErrorHandler {
        private ErrorHandler errorHandler;

        ErrorHandlerBridge(ErrorHandler hander) {
            this.errorHandler = hander;
        }

        public void warning(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.warning(e2.getMessage(), ((Integer)p.getLeft()).intValue(), ((Integer)p.getRight()).intValue());
        }

        public void error(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.error(e2.getMessage(), ((Integer)p.getLeft()).intValue(), ((Integer)p.getRight()).intValue());
        }

        public void fatalError(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.fatal(e2.getMessage(), ((Integer)p.getLeft()).intValue(), ((Integer)p.getRight()).intValue());
        }

        private static Pair<Integer, Integer> getLineCol(Exception e2) {
            if (e2 instanceof SAXParseException) {
                SAXParseException esax = (SAXParseException)e2;
                return Pair.create((Object)esax.getLineNumber(), (Object)esax.getColumnNumber());
            }
            return Pair.create((Object)-1, (Object)-1);
        }
    }
}

