/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;

public class UniqueName {
    private String key;
    private List<COSName> resourceNames;

    public UniqueName(String key, COSDictionary sourcePageResources, boolean disable) {
        if (disable) {
            this.resourceNames = Collections.emptyList();
        } else {
            key = key.split("#")[0];
            this.key = Integer.toString(key.hashCode());
            this.resourceNames = this.getResourceNames(sourcePageResources);
        }
    }

    protected String getName(COSName cn) {
        if (this.resourceNames.contains(cn)) {
            return cn.getName() + this.key;
        }
        return cn.getName();
    }

    protected void writeName(StringBuilder sb, COSName cn) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cn.writePDF((OutputStream)bos);
        String name = bos.toString("ISO-8859-1");
        sb.append(name);
        if (this.resourceNames.contains(cn)) {
            sb.append(this.key);
        }
    }

    private List<COSName> getResourceNames(COSDictionary sourcePageResources) {
        ArrayList<COSName> resourceNames = new ArrayList<COSName>();
        for (COSBase e : sourcePageResources.getValues()) {
            if (e instanceof COSObject) {
                e = ((COSObject)e).getObject();
            }
            if (!(e instanceof COSDictionary)) continue;
            COSDictionary d = (COSDictionary)e;
            resourceNames.addAll(d.keySet());
        }
        return resourceNames;
    }
}

