/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.StringToClassMapItem;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.DependentRequired;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.DelegatingMethodParameter;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springdoc.core.providers.RepositoryRestConfigurationProvider;
import org.springdoc.core.providers.SpringDataWebPropertiesProvider;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;

public class DataRestDelegatingMethodParameterCustomizer
implements DelegatingMethodParameterCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRestDelegatingMethodParameterCustomizer.class);
    private final Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider;
    private final Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfigurationProvider;

    public DataRestDelegatingMethodParameterCustomizer(Optional<SpringDataWebPropertiesProvider> optionalSpringDataWebPropertiesProvider, Optional<RepositoryRestConfigurationProvider> optionalRepositoryRestConfigurationProvider) {
        this.optionalSpringDataWebPropertiesProvider = optionalSpringDataWebPropertiesProvider;
        this.optionalRepositoryRestConfigurationProvider = optionalRepositoryRestConfigurationProvider;
    }

    @Override
    public void customize(MethodParameter originalParameter, MethodParameter methodParameter) {
        PageableDefault pageableDefault = (PageableDefault)originalParameter.getParameterAnnotation(PageableDefault.class);
        SortDefault sortDefault = (SortDefault)originalParameter.getParameterAnnotation(SortDefault.class);
        Class parameterType = originalParameter.getParameterType();
        if (pageableDefault != null || sortDefault != null || (Pageable.class.isAssignableFrom(parameterType) || Sort.class.isAssignableFrom(parameterType)) && (this.isSpringDataWebPropertiesPresent() || this.isRepositoryRestConfigurationPresent())) {
            Field field = FieldUtils.getDeclaredField(DelegatingMethodParameter.class, (String)"additionalParameterAnnotations", (boolean)true);
            try {
                Object[] parameterAnnotations = (Annotation[])field.get(methodParameter);
                if (ArrayUtils.isNotEmpty((Object[])parameterAnnotations)) {
                    for (int i = 0; i < parameterAnnotations.length; ++i) {
                        Optional<Annotation> annotationForField;
                        if (!Parameter.class.equals(parameterAnnotations[i].annotationType()) || !(annotationForField = this.getNewParameterAnnotationForField(methodParameter, pageableDefault, sortDefault)).isPresent()) continue;
                        parameterAnnotations[i] = annotationForField.get();
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }

    private Optional<Annotation> getNewParameterAnnotationForField(MethodParameter methodParameter, final PageableDefault pageableDefault, final SortDefault sortDefault) {
        final String parameterName = methodParameter.getParameterName();
        try {
            Field field = methodParameter.getContainingClass().getDeclaredField(parameterName);
            final Parameter parameter = field.getAnnotation(Parameter.class);
            Parameter parameterNew = new Parameter(){

                public Class<? extends Annotation> annotationType() {
                    return parameter.annotationType();
                }

                public String name() {
                    return DataRestDelegatingMethodParameterCustomizer.this.getName(parameterName, parameter.name());
                }

                public ParameterIn in() {
                    return parameter.in();
                }

                public String description() {
                    return DataRestDelegatingMethodParameterCustomizer.this.getDescription(parameterName, parameter.description());
                }

                public boolean required() {
                    return parameter.required();
                }

                public boolean deprecated() {
                    return parameter.deprecated();
                }

                public boolean allowEmptyValue() {
                    return parameter.allowEmptyValue();
                }

                public ParameterStyle style() {
                    return parameter.style();
                }

                public Explode explode() {
                    return parameter.explode();
                }

                public boolean allowReserved() {
                    return parameter.allowReserved();
                }

                public Schema schema() {
                    return new Schema(){
                        private Schema parameterSchema;
                        {
                            this.parameterSchema = parameter.schema();
                        }

                        public Class<? extends Annotation> annotationType() {
                            return this.parameterSchema.annotationType();
                        }

                        public Class<?> implementation() {
                            return this.parameterSchema.implementation();
                        }

                        public Class<?> not() {
                            return this.parameterSchema.not();
                        }

                        public Class<?>[] oneOf() {
                            return this.parameterSchema.oneOf();
                        }

                        public Class<?>[] anyOf() {
                            return this.parameterSchema.anyOf();
                        }

                        public Class<?>[] allOf() {
                            return this.parameterSchema.allOf();
                        }

                        public String name() {
                            return this.parameterSchema.name();
                        }

                        public String title() {
                            return this.parameterSchema.title();
                        }

                        public double multipleOf() {
                            return this.parameterSchema.multipleOf();
                        }

                        public String maximum() {
                            return this.parameterSchema.maximum();
                        }

                        public boolean exclusiveMaximum() {
                            return this.parameterSchema.exclusiveMaximum();
                        }

                        public String minimum() {
                            return this.parameterSchema.minimum();
                        }

                        public boolean exclusiveMinimum() {
                            return this.parameterSchema.exclusiveMaximum();
                        }

                        public int maxLength() {
                            return this.parameterSchema.maxLength();
                        }

                        public int minLength() {
                            return this.parameterSchema.minLength();
                        }

                        public String pattern() {
                            return this.parameterSchema.pattern();
                        }

                        public int maxProperties() {
                            return this.parameterSchema.maxProperties();
                        }

                        public int minProperties() {
                            return this.parameterSchema.minProperties();
                        }

                        public String[] requiredProperties() {
                            return this.parameterSchema.requiredProperties();
                        }

                        public boolean required() {
                            return this.parameterSchema.required();
                        }

                        public Schema.RequiredMode requiredMode() {
                            return this.parameterSchema.requiredMode();
                        }

                        public String description() {
                            return this.parameterSchema.description();
                        }

                        public String format() {
                            return this.parameterSchema.format();
                        }

                        public String ref() {
                            return this.parameterSchema.ref();
                        }

                        public boolean nullable() {
                            return this.parameterSchema.nullable();
                        }

                        public boolean readOnly() {
                            return Schema.AccessMode.READ_ONLY.equals((Object)this.parameterSchema.accessMode());
                        }

                        public boolean writeOnly() {
                            return Schema.AccessMode.WRITE_ONLY.equals((Object)this.parameterSchema.accessMode());
                        }

                        public Schema.AccessMode accessMode() {
                            return this.parameterSchema.accessMode();
                        }

                        public String example() {
                            return this.parameterSchema.example();
                        }

                        public ExternalDocumentation externalDocs() {
                            return this.parameterSchema.externalDocs();
                        }

                        public boolean deprecated() {
                            return this.parameterSchema.deprecated();
                        }

                        public String type() {
                            return this.parameterSchema.type();
                        }

                        public String[] allowableValues() {
                            return this.parameterSchema.allowableValues();
                        }

                        public String defaultValue() {
                            return DataRestDelegatingMethodParameterCustomizer.this.getDefaultValue(parameterName, pageableDefault, this.parameterSchema.defaultValue());
                        }

                        public String discriminatorProperty() {
                            return this.parameterSchema.discriminatorProperty();
                        }

                        public DiscriminatorMapping[] discriminatorMapping() {
                            return this.parameterSchema.discriminatorMapping();
                        }

                        public boolean hidden() {
                            return this.parameterSchema.hidden();
                        }

                        public boolean enumAsRef() {
                            return this.parameterSchema.enumAsRef();
                        }

                        public Class<?>[] subTypes() {
                            return this.parameterSchema.subTypes();
                        }

                        public Extension[] extensions() {
                            return this.parameterSchema.extensions();
                        }

                        public Class<?>[] prefixItems() {
                            return this.parameterSchema.prefixItems();
                        }

                        public String[] types() {
                            return this.parameterSchema.types();
                        }

                        public int exclusiveMaximumValue() {
                            return this.parameterSchema.exclusiveMaximumValue();
                        }

                        public int exclusiveMinimumValue() {
                            return this.parameterSchema.exclusiveMinimumValue();
                        }

                        public Class<?> contains() {
                            return this.parameterSchema.contains();
                        }

                        public String $id() {
                            return this.parameterSchema.$id();
                        }

                        public String $schema() {
                            return this.parameterSchema.$schema();
                        }

                        public String $anchor() {
                            return this.parameterSchema.$anchor();
                        }

                        public String $vocabulary() {
                            return this.parameterSchema.$vocabulary();
                        }

                        public String $dynamicAnchor() {
                            return this.parameterSchema.$dynamicAnchor();
                        }

                        public String contentEncoding() {
                            return this.parameterSchema.contentEncoding();
                        }

                        public String contentMediaType() {
                            return this.parameterSchema.contentMediaType();
                        }

                        public Class<?> contentSchema() {
                            return this.parameterSchema.contentSchema();
                        }

                        public Class<?> propertyNames() {
                            return this.parameterSchema.propertyNames();
                        }

                        public int maxContains() {
                            return this.parameterSchema.maxContains();
                        }

                        public int minContains() {
                            return this.parameterSchema.minContains();
                        }

                        public Class<?> additionalItems() {
                            return this.parameterSchema.additionalItems();
                        }

                        public Class<?> unevaluatedItems() {
                            return this.parameterSchema.unevaluatedItems();
                        }

                        public Class<?> _if() {
                            return this.parameterSchema._if();
                        }

                        public Class<?> _else() {
                            return this.parameterSchema._else();
                        }

                        public Class<?> then() {
                            return this.parameterSchema.then();
                        }

                        public String $comment() {
                            return this.parameterSchema.$comment();
                        }

                        public Class<?>[] exampleClasses() {
                            return this.parameterSchema.exampleClasses();
                        }

                        public Schema.AdditionalPropertiesValue additionalProperties() {
                            return this.parameterSchema.additionalProperties();
                        }

                        public DependentRequired[] dependentRequiredMap() {
                            return this.parameterSchema.dependentRequiredMap();
                        }

                        public StringToClassMapItem[] dependentSchemas() {
                            return this.parameterSchema.dependentSchemas();
                        }

                        public StringToClassMapItem[] patternProperties() {
                            return this.parameterSchema.patternProperties();
                        }

                        public StringToClassMapItem[] properties() {
                            return this.parameterSchema.properties();
                        }

                        public Class<?> unevaluatedProperties() {
                            return this.parameterSchema.unevaluatedProperties();
                        }

                        public Class<?> additionalPropertiesSchema() {
                            return this.parameterSchema.additionalPropertiesSchema();
                        }

                        public String[] examples() {
                            return this.parameterSchema.examples();
                        }

                        public String _const() {
                            return this.parameterSchema._const();
                        }
                    };
                }

                public ArraySchema array() {
                    final ArraySchema arraySchema = parameter.array();
                    return new ArraySchema(){

                        public Class<? extends Annotation> annotationType() {
                            return arraySchema.annotationType();
                        }

                        public Schema items() {
                            return arraySchema.items();
                        }

                        public Schema schema() {
                            return arraySchema.schema();
                        }

                        public Schema arraySchema() {
                            final Schema schema = arraySchema.arraySchema();
                            return new Schema(){

                                public Class<? extends Annotation> annotationType() {
                                    return schema.annotationType();
                                }

                                public Class<?> implementation() {
                                    return schema.implementation();
                                }

                                public Class<?> not() {
                                    return schema.not();
                                }

                                public Class<?>[] oneOf() {
                                    return schema.oneOf();
                                }

                                public Class<?>[] anyOf() {
                                    return schema.anyOf();
                                }

                                public Class<?>[] allOf() {
                                    return schema.allOf();
                                }

                                public String name() {
                                    return schema.name();
                                }

                                public String title() {
                                    return schema.title();
                                }

                                public double multipleOf() {
                                    return schema.multipleOf();
                                }

                                public String maximum() {
                                    return schema.maximum();
                                }

                                public boolean exclusiveMaximum() {
                                    return schema.exclusiveMaximum();
                                }

                                public String minimum() {
                                    return schema.minimum();
                                }

                                public boolean exclusiveMinimum() {
                                    return schema.exclusiveMinimum();
                                }

                                public int maxLength() {
                                    return schema.maxLength();
                                }

                                public int minLength() {
                                    return schema.minLength();
                                }

                                public String pattern() {
                                    return schema.pattern();
                                }

                                public int maxProperties() {
                                    return schema.maxProperties();
                                }

                                public int minProperties() {
                                    return schema.minProperties();
                                }

                                public String[] requiredProperties() {
                                    return schema.requiredProperties();
                                }

                                public boolean required() {
                                    return schema.required();
                                }

                                public Schema.RequiredMode requiredMode() {
                                    return schema.requiredMode();
                                }

                                public String description() {
                                    return schema.description();
                                }

                                public String format() {
                                    return schema.format();
                                }

                                public String ref() {
                                    return schema.ref();
                                }

                                public boolean nullable() {
                                    return schema.nullable();
                                }

                                public boolean readOnly() {
                                    return Schema.AccessMode.READ_ONLY.equals((Object)schema.accessMode());
                                }

                                public boolean writeOnly() {
                                    return Schema.AccessMode.WRITE_ONLY.equals((Object)schema.accessMode());
                                }

                                public Schema.AccessMode accessMode() {
                                    return schema.accessMode();
                                }

                                public String example() {
                                    return schema.example();
                                }

                                public ExternalDocumentation externalDocs() {
                                    return schema.externalDocs();
                                }

                                public boolean deprecated() {
                                    return schema.deprecated();
                                }

                                public String type() {
                                    return schema.type();
                                }

                                public String[] allowableValues() {
                                    return schema.allowableValues();
                                }

                                public String defaultValue() {
                                    return DataRestDelegatingMethodParameterCustomizer.this.getArrayDefaultValue(parameterName, pageableDefault, sortDefault, schema.defaultValue());
                                }

                                public String discriminatorProperty() {
                                    return schema.discriminatorProperty();
                                }

                                public DiscriminatorMapping[] discriminatorMapping() {
                                    return schema.discriminatorMapping();
                                }

                                public boolean hidden() {
                                    return schema.hidden();
                                }

                                public boolean enumAsRef() {
                                    return schema.enumAsRef();
                                }

                                public Class<?>[] subTypes() {
                                    return schema.subTypes();
                                }

                                public Extension[] extensions() {
                                    return schema.extensions();
                                }

                                public Class<?>[] prefixItems() {
                                    return schema.prefixItems();
                                }

                                public String[] types() {
                                    return schema.types();
                                }

                                public int exclusiveMaximumValue() {
                                    return schema.exclusiveMaximumValue();
                                }

                                public int exclusiveMinimumValue() {
                                    return schema.exclusiveMinimumValue();
                                }

                                public Class<?> contains() {
                                    return schema.contains();
                                }

                                public String $id() {
                                    return schema.$id();
                                }

                                public String $schema() {
                                    return schema.$schema();
                                }

                                public String $anchor() {
                                    return schema.$anchor();
                                }

                                public String $vocabulary() {
                                    return schema.$vocabulary();
                                }

                                public String $dynamicAnchor() {
                                    return schema.$dynamicAnchor();
                                }

                                public String contentEncoding() {
                                    return schema.contentEncoding();
                                }

                                public String contentMediaType() {
                                    return schema.contentMediaType();
                                }

                                public Class<?> contentSchema() {
                                    return schema.contentSchema();
                                }

                                public Class<?> propertyNames() {
                                    return schema.propertyNames();
                                }

                                public int maxContains() {
                                    return schema.maxContains();
                                }

                                public int minContains() {
                                    return schema.minContains();
                                }

                                public Class<?> additionalItems() {
                                    return schema.additionalItems();
                                }

                                public Class<?> unevaluatedItems() {
                                    return schema.unevaluatedItems();
                                }

                                public Class<?> _if() {
                                    return schema._if();
                                }

                                public Class<?> _else() {
                                    return schema._else();
                                }

                                public Class<?> then() {
                                    return schema.then();
                                }

                                public String $comment() {
                                    return schema.$comment();
                                }

                                public Class<?>[] exampleClasses() {
                                    return schema.exampleClasses();
                                }

                                public Schema.AdditionalPropertiesValue additionalProperties() {
                                    return schema.additionalProperties();
                                }

                                public DependentRequired[] dependentRequiredMap() {
                                    return schema.dependentRequiredMap();
                                }

                                public StringToClassMapItem[] dependentSchemas() {
                                    return schema.dependentSchemas();
                                }

                                public StringToClassMapItem[] patternProperties() {
                                    return schema.patternProperties();
                                }

                                public StringToClassMapItem[] properties() {
                                    return schema.properties();
                                }

                                public Class<?> unevaluatedProperties() {
                                    return schema.unevaluatedProperties();
                                }

                                public Class<?> additionalPropertiesSchema() {
                                    return schema.additionalPropertiesSchema();
                                }

                                public String[] examples() {
                                    return schema.examples();
                                }

                                public String _const() {
                                    return schema._const();
                                }
                            };
                        }

                        public int maxItems() {
                            return arraySchema.maxItems();
                        }

                        public int minItems() {
                            return arraySchema.minItems();
                        }

                        public boolean uniqueItems() {
                            return arraySchema.uniqueItems();
                        }

                        public Extension[] extensions() {
                            return arraySchema.extensions();
                        }

                        public Schema contains() {
                            return arraySchema.contains();
                        }

                        public int maxContains() {
                            return arraySchema.maxContains();
                        }

                        public int minContains() {
                            return arraySchema.minContains();
                        }

                        public Schema unevaluatedItems() {
                            return arraySchema.unevaluatedItems();
                        }

                        public Schema[] prefixItems() {
                            return arraySchema.prefixItems();
                        }
                    };
                }

                public Content[] content() {
                    return parameter.content();
                }

                public boolean hidden() {
                    return parameter.hidden();
                }

                public ExampleObject[] examples() {
                    return parameter.examples();
                }

                public String example() {
                    return parameter.example();
                }

                public Extension[] extensions() {
                    return parameter.extensions();
                }

                public String ref() {
                    return parameter.ref();
                }
            };
            return Optional.of(parameterNew);
        }
        catch (NoSuchFieldException e) {
            LOGGER.warn(e.getMessage());
            return Optional.empty();
        }
    }

    private String getName(String parameterName, String originalName) {
        String name = null;
        switch (parameterName) {
            case "size": {
                if (this.isRepositoryRestConfigurationPresent()) {
                    name = this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getLimitParamName();
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    name = this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getPrefix() + this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getSizeParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "sort": {
                if (this.isRepositoryRestConfigurationPresent()) {
                    name = this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getSortParamName();
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    name = this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getSort().getSortParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "page": {
                if (this.isRepositoryRestConfigurationPresent()) {
                    name = this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getPageParamName();
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    name = this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getPrefix() + this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getPageParameter();
                    break;
                }
                name = originalName;
                break;
            }
            case "direction": 
            case "caseSensitive": {
                name = originalName;
                break;
            }
        }
        return name;
    }

    private String getDescription(String parameterName, String originalDescription) {
        if ("page".equals(parameterName) && this.isSpringDataWebPropertiesPresent() && this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().isOneIndexedParameters()) {
            return "One-based page index (1..N)";
        }
        return originalDescription;
    }

    private String getDefaultValue(String parameterName, PageableDefault pageableDefault, String defaultSchemaVal) {
        String defaultValue = null;
        switch (parameterName) {
            case "size": {
                if (pageableDefault != null) {
                    Object defaultSize;
                    int size = pageableDefault.size();
                    try {
                        defaultSize = PageableDefault.class.getMethod("size", new Class[0]).getDefaultValue();
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.warn(e.getMessage());
                        defaultSize = null;
                    }
                    if (Objects.deepEquals(size, defaultSize)) {
                        size = pageableDefault.value();
                    }
                    defaultValue = String.valueOf(size);
                    break;
                }
                if (this.isRepositoryRestConfigurationPresent()) {
                    defaultValue = String.valueOf(this.optionalRepositoryRestConfigurationProvider.get().getRepositoryRestConfiguration().getDefaultPageSize());
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent()) {
                    defaultValue = String.valueOf(this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().getDefaultPageSize());
                    break;
                }
                defaultValue = defaultSchemaVal;
                break;
            }
            case "page": {
                if (pageableDefault != null) {
                    defaultValue = String.valueOf(pageableDefault.page());
                    break;
                }
                if (this.isSpringDataWebPropertiesPresent() && this.optionalSpringDataWebPropertiesProvider.get().getSpringDataWebProperties().getPageable().isOneIndexedParameters()) {
                    defaultValue = "1";
                    break;
                }
                defaultValue = defaultSchemaVal;
                break;
            }
        }
        return defaultValue;
    }

    private String getArrayDefaultValue(String parameterName, PageableDefault pageableDefault, SortDefault sortDefault, String defaultSchemaVal) {
        DefaultSort defaultSort;
        String defaultValue = defaultSchemaVal;
        if ("sort".equals(parameterName) && (defaultSort = this.getDefaultSort(pageableDefault, sortDefault)) != null && ArrayUtils.isNotEmpty((Object[])defaultSort.properties)) {
            List<String> sortValues = defaultSort.getEffectiveProperties();
            try {
                defaultValue = ObjectMapperFactory.buildStrictGenericObjectMapper().writeValueAsString(sortValues);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return defaultValue;
    }

    private DefaultSort getDefaultSort(PageableDefault pageableDefault, SortDefault sortDefault) {
        if (sortDefault != null) {
            Object defaultSort;
            String[] sortProperties = sortDefault.sort();
            try {
                defaultSort = SortDefault.class.getMethod("sort", new Class[0]).getDefaultValue();
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn(e.getMessage());
                defaultSort = null;
            }
            if (!Objects.deepEquals(sortProperties, defaultSort)) {
                return new DefaultSort(sortDefault.direction(), sortProperties);
            }
            sortProperties = sortDefault.value();
            try {
                defaultSort = SortDefault.class.getMethod("value", new Class[0]).getDefaultValue();
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn(e.getMessage());
                defaultSort = null;
            }
            if (!Objects.deepEquals(sortProperties, defaultSort)) {
                return new DefaultSort(sortDefault.direction(), sortProperties);
            }
        }
        if (pageableDefault != null) {
            return new DefaultSort(pageableDefault.direction(), pageableDefault.sort());
        }
        return null;
    }

    private boolean isSpringDataWebPropertiesPresent() {
        return this.optionalSpringDataWebPropertiesProvider.isPresent() && this.optionalSpringDataWebPropertiesProvider.get().isSpringDataWebPropertiesPresent();
    }

    private boolean isRepositoryRestConfigurationPresent() {
        return this.optionalRepositoryRestConfigurationProvider.isPresent() && this.optionalRepositoryRestConfigurationProvider.get().isRepositoryRestConfigurationPresent();
    }

    private static class DefaultSort {
        private static final String DIRECTION_GROUP = Arrays.stream(Sort.Direction.values()).map(Enum::name).collect(Collectors.joining("|"));
        private static final String DIRECTED_REGEXP = "\\w+(\\.\\w+)*,\\s*(" + DIRECTION_GROUP + ')';
        private static final Pattern DIRECTED_PATTERN = Pattern.compile(DIRECTED_REGEXP, 2);
        private final Sort.Direction direction;
        private final String[] properties;

        DefaultSort(Sort.Direction direction, String ... properties) {
            this.direction = direction;
            this.properties = properties;
        }

        List<String> getEffectiveProperties() {
            return Arrays.stream(this.properties).map(p -> {
                if (DIRECTED_PATTERN.matcher((CharSequence)p).matches()) {
                    return p;
                }
                return p + ',' + this.direction.name();
            }).collect(Collectors.toList());
        }
    }
}

