/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;

public class NodeStateProtocol
extends TextProtocol {
    public static final String VERSION = "1.0";
    public final TextProtocol.MessageOp NODE_STATE_REQ = new TextProtocol.MessageOp("STATEREQ", NodeStateRequest.class);
    public final TextProtocol.MessageOp NODE_STATE_RESP = new TextProtocol.MessageOp("STATERESP", NodeStateResponse.class);

    public NodeStateProtocol(String groupName, NameIdPair nameIdPair, RepImpl repImpl) {
        super(VERSION, groupName, nameIdPair, repImpl);
        this.initializeMessageOps(new TextProtocol.MessageOp[]{this.NODE_STATE_REQ, this.NODE_STATE_RESP});
        this.setTimeouts(repImpl, RepParams.REP_GROUP_OPEN_TIMEOUT, RepParams.REP_GROUP_READ_TIMEOUT);
    }

    public class NodeStateResponse
    extends TextProtocol.ResponseMessage {
        private final String nodeName;
        private final String masterName;
        private final long joinTime;
        private final ReplicatedEnvironment.State nodeState;

        public NodeStateResponse(String nodeName, String masterName, long joinTime, ReplicatedEnvironment.State nodeState) {
            super(NodeStateProtocol.this);
            this.nodeName = nodeName;
            this.masterName = masterName;
            this.joinTime = joinTime;
            this.nodeState = nodeState;
        }

        public NodeStateResponse(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(NodeStateProtocol.this, line, tokens);
            this.nodeName = this.nextPayloadToken();
            this.masterName = this.nextPayloadToken();
            this.joinTime = Long.parseLong(this.nextPayloadToken());
            this.nodeState = ReplicatedEnvironment.State.valueOf(this.nextPayloadToken());
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getMasterName() {
            return this.masterName;
        }

        public long getJoinTime() {
            return this.joinTime;
        }

        public ReplicatedEnvironment.State getNodeState() {
            return this.nodeState;
        }

        public TextProtocol.MessageOp getOp() {
            return NodeStateProtocol.this.NODE_STATE_RESP;
        }

        protected String getMessagePrefix() {
            return NodeStateProtocol.this.messagePrefixNocheck;
        }

        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nodeName + "|" + this.masterName + "|" + Long.toString(this.joinTime) + "|" + this.nodeState.toString();
        }
    }

    public class NodeStateRequest
    extends TextProtocol.RequestMessage {
        private final String nodeName;

        public NodeStateRequest(String nodeName) {
            super(NodeStateProtocol.this);
            this.nodeName = nodeName;
        }

        public NodeStateRequest(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(NodeStateProtocol.this, line, tokens);
            this.nodeName = this.nextPayloadToken();
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public TextProtocol.MessageOp getOp() {
            return NodeStateProtocol.this.NODE_STATE_REQ;
        }

        protected String getMessagePrefix() {
            return NodeStateProtocol.this.messagePrefixNocheck;
        }

        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nodeName;
        }
    }
}

