/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.log.LogEntryType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseEntry {
    private final Constructor<?> noargsConstructor;
    LogEntryType entryType;

    BaseEntry(Class<?> logClass) {
        try {
            this.noargsConstructor = logClass.getConstructor(null);
        }
        catch (SecurityException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (NoSuchMethodException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    Object newInstanceOfType() {
        try {
            return this.noargsConstructor.newInstance(null);
        }
        catch (IllegalAccessException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (InstantiationException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (IllegalArgumentException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    BaseEntry() {
        this.noargsConstructor = null;
    }

    public void setLogType(LogEntryType entryType) {
        this.entryType = entryType;
    }

    public LogEntryType getLogType() {
        return this.entryType;
    }

    public int getLastLoggedSize() {
        return 0;
    }

    public boolean isDeleted() {
        return false;
    }

    public void postLogWork(long justLoggedLsn) throws DatabaseException {
    }

    public abstract StringBuilder dumpEntry(StringBuilder var1, boolean var2);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpEntry(sb, true);
        return sb.toString();
    }
}

