/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.api.parameter.Parameter;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Period;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.util.DistanceBufferUtil;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.InFunction;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.jdbc.EnumMapping;
import org.geotools.jdbc.EscapeSql;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JoinId;
import org.geotools.jdbc.JoinPropertyName;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class FilterToSQL
implements FilterVisitor,
ExpressionVisitor {
    protected static final String IO_ERROR = "io problem writing filter";
    protected static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    protected FilterCapabilities capabilities = null;
    protected static Logger LOGGER = Logging.getLogger(FilterToSQL.class);
    protected String sqlNameEscape = "";
    protected Writer out;
    protected PrimaryKey primaryKey;
    protected String databaseSchema;
    protected SimpleFeatureType featureType;
    protected boolean encodingFunction = false;
    protected GeometryDescriptor currentGeometry;
    protected Integer currentSRID;
    protected Integer currentDimension;
    protected boolean inline = false;
    protected boolean inEncodingEnabled = true;
    protected boolean escapeBackslash = false;
    protected FieldEncoder fieldEncoder = DefaultFieldEncoder.DEFAULT_FIELD_ENCODER;

    public FilterToSQL() {
    }

    public FilterToSQL(Writer out) {
        this.out = out;
    }

    public void setWriter(Writer out) {
        this.out = out;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public boolean isInEncodingEnabled() {
        return this.inEncodingEnabled;
    }

    public void setInEncodingEnabled(boolean inEncodingEnabled) {
        this.inEncodingEnabled = inEncodingEnabled;
    }

    public boolean isEscapeBackslash() {
        return this.escapeBackslash;
    }

    public void setEscapeBackslash(boolean escapeBackslash) {
        this.escapeBackslash = escapeBackslash;
    }

    public void encode(Filter filter) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        if (this.getCapabilities().fullySupports(filter)) {
            try {
                if (!this.inline) {
                    this.out.write("WHERE ");
                }
                filter.accept((FilterVisitor)this, null);
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
                throw new FilterToSQLException("Problem writing filter: ", ioe);
            }
        } else {
            throw new FilterToSQLException("Filter type not supported: " + filter);
        }
    }

    public String encodeToString(Filter filter) throws FilterToSQLException {
        StringWriter out = new StringWriter();
        this.out = out;
        this.encode(filter);
        return out.getBuffer().toString();
    }

    public void encode(Expression expression) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        expression.accept((ExpressionVisitor)this, null);
    }

    public String encodeToString(Expression expression) throws FilterToSQLException {
        StringWriter out = new StringWriter();
        this.out = out;
        this.encode(expression);
        return out.getBuffer().toString();
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        if (this.inEncodingEnabled) {
            capabilities.addAll(InFunction.getInCapabilities());
        }
        capabilities.addType(Add.class);
        capabilities.addType(Subtract.class);
        capabilities.addType(Divide.class);
        capabilities.addType(Multiply.class);
        capabilities.addType(PropertyName.class);
        capabilities.addType(Literal.class);
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(PropertyIsLike.class);
        capabilities.addType(Id.class);
        capabilities.addType(IncludeFilter.class);
        capabilities.addType(ExcludeFilter.class);
        capabilities.addType(After.class);
        capabilities.addType(Before.class);
        capabilities.addType(Begins.class);
        capabilities.addType(BegunBy.class);
        capabilities.addType(During.class);
        capabilities.addType(Ends.class);
        capabilities.addType(EndedBy.class);
        capabilities.addType(TContains.class);
        capabilities.addType(TEquals.class);
        return capabilities;
    }

    public final synchronized FilterCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.createFilterCapabilities();
        }
        return this.capabilities;
    }

    public void setCapabilities(FilterCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        try {
            this.out.write("0 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        try {
            this.out.write("1 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyIsBetween");
        Expression expr = filter.getExpression();
        Expression lowerbounds = filter.getLowerBoundary();
        Expression upperbounds = filter.getUpperBoundary();
        AttributeDescriptor attType = (AttributeDescriptor)expr.evaluate((Object)this.featureType);
        Class context = attType != null ? attType.getType().getBinding() : String.class;
        try {
            expr.accept((ExpressionVisitor)this, extraData);
            this.out.write(" BETWEEN ");
            lowerbounds.accept((ExpressionVisitor)this, (Object)context);
            this.out.write(" AND ");
            upperbounds.accept((ExpressionVisitor)this, (Object)context);
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        char esc = filter.getEscape().charAt(0);
        char multi = filter.getWildCard().charAt(0);
        char single = filter.getSingleChar().charAt(0);
        boolean matchCase = filter.isMatchingCase();
        Object literal = filter.getLiteral();
        Expression att = filter.getExpression();
        Class attributeType = this.getExpressionType(att);
        if (attributeType != null && Date.class.isAssignableFrom(attributeType)) {
            literal = (String)literal + multi;
        }
        String pattern = LikeFilterImpl.convertToSQL92(esc, multi, single, matchCase, (String)literal, false);
        try {
            if (!matchCase) {
                this.out.write(" UPPER(");
            }
            att.accept((ExpressionVisitor)this, extraData);
            if (!matchCase) {
                this.out.write(") LIKE ");
            } else {
                this.out.write(" LIKE ");
            }
            this.writeLiteral(pattern);
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(And filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"AND");
    }

    public Object visit(Not filter, Object extraData) {
        try {
            if (filter.getFilter() instanceof PropertyIsNull) {
                Expression expr = ((PropertyIsNull)filter.getFilter()).getExpression();
                if (this.isEnumerated(expr)) {
                    this.writeEncodedField(Integer.class, (PropertyName)expr, (AttributeDescriptor)expr.evaluate((Object)this.featureType));
                } else {
                    expr.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(" IS NOT NULL ");
            } else {
                this.out.write("NOT (");
                filter.getFilter().accept((FilterVisitor)this, extraData);
                this.out.write(")");
            }
            return extraData;
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
    }

    public Object visit(Or filter, Object extraData) {
        LinkedHashMap<Object, ArrayList<Literal>> grouped = new LinkedHashMap<Object, ArrayList<Literal>>();
        int maxGroupSize = 0;
        for (Filter child : filter.getChildren()) {
            Expression[] nameLiteral = this.getNameLiteralFromEquality(child);
            if (nameLiteral == null) {
                grouped.put(child, null);
                continue;
            }
            PropertyName name = (PropertyName)nameLiteral[0];
            Literal value = (Literal)nameLiteral[1];
            ArrayList<Literal> values = (ArrayList<Literal>)grouped.get(name);
            if (values == null) {
                values = new ArrayList<Literal>();
                grouped.put(name, values);
            }
            values.add(value);
            maxGroupSize = Math.max(maxGroupSize, values.size());
        }
        if (maxGroupSize < 2) {
            return this.visit((BinaryLogicOperator)filter, (Object)"OR");
        }
        try {
            Iterator iterator = grouped.entrySet().iterator();
            if (grouped.size() > 1) {
                this.out.write("(");
            }
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getKey() instanceof PropertyName) {
                    PropertyName pn = (PropertyName)entry.getKey();
                    List literals = (List)entry.getValue();
                    pn.accept((ExpressionVisitor)this, extraData);
                    Class binding = this.getExpressionType((Expression)pn);
                    int literalsSize = literals.size();
                    if (literalsSize == 1) {
                        this.out.write(" = ");
                        ((Literal)literals.get(0)).accept((ExpressionVisitor)this, (Object)binding);
                    } else {
                        this.out.write(" IN (");
                        for (int i = 0; i < literalsSize; ++i) {
                            ((Literal)literals.get(i)).accept((ExpressionVisitor)this, (Object)binding);
                            if (i >= literalsSize - 1) continue;
                            this.out.write(", ");
                        }
                        this.out.write(")");
                    }
                } else {
                    ((Filter)entry.getKey()).accept((FilterVisitor)this, extraData);
                }
                if (!iterator.hasNext()) continue;
                this.out.write(" OR ");
            }
            if (grouped.size() > 1) {
                this.out.write(")");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    private Expression[] getNameLiteralFromEquality(Filter child) {
        if (child instanceof PropertyIsEqualTo) {
            PropertyIsEqualTo equal = (PropertyIsEqualTo)child;
            Expression ex1 = equal.getExpression1();
            Expression ex2 = equal.getExpression2();
            if (ex1 instanceof PropertyName && ex2 instanceof Literal) {
                return new Expression[]{ex1, ex2};
            }
            if (ex2 instanceof PropertyName && ex1 instanceof Literal) {
                return new Expression[]{ex2, ex1};
            }
        }
        return null;
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        LOGGER.finer("exporting LogicFilter");
        String type = (String)extraData;
        try {
            Iterator list = filter.getChildren().iterator();
            this.out.write("(");
            while (list.hasNext()) {
                ((Filter)list.next()).accept((FilterVisitor)this, extraData);
                if (!list.hasNext()) continue;
                this.out.write(" " + type + " ");
            }
            this.out.write(")");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">");
        return extraData;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<");
        return extraData;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<=");
        return extraData;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "!=");
        return extraData;
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting SQL ComparisonFilter");
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        if (this.inEncodingEnabled && ("=".equals(extraData) || "!=".equals(extraData))) {
            if (right instanceof Literal && InFunction.isInFunction(left) && right.evaluate(null, Boolean.class) != null) {
                this.encodeInComparison((Function)left, (Literal)right, extraData);
                return;
            }
            if (left instanceof Literal && InFunction.isInFunction(right) && left.evaluate(null, Boolean.class) != null) {
                this.encodeInComparison((Function)right, (Literal)left, extraData);
                return;
            }
        }
        Class rightContext = this.getExpressionType(left);
        Class leftContext = this.getExpressionType(right);
        this.encodeBinaryComparisonOperator(filter, extraData, left, right, leftContext, rightContext);
    }

    protected void encodeBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData, Expression left, Expression right, Class leftContext, Class rightContext) {
        boolean matchCase = true;
        if (!filter.isMatchingCase() && (filter instanceof PropertyIsEqualTo || filter instanceof PropertyIsNotEqualTo) && (String.class.equals((Object)leftContext) || String.class.equals((Object)rightContext))) {
            matchCase = false;
        }
        String type = (String)extraData;
        try {
            if (this.isEnumerated(right) || this.isEnumerated(left)) {
                this.encodeEnumeratedComparison(right, left, type, matchCase);
                return;
            }
            if (matchCase) {
                this.writeBinaryExpressionMember(left, leftContext);
                this.out.write(" " + type + " ");
                this.writeBinaryExpressionMember(right, rightContext);
            } else {
                FunctionImpl f = new FunctionImpl(){
                    {
                        this.functionName = new FunctionNameImpl("lower", FunctionNameImpl.parameter("lowercase", String.class), FunctionNameImpl.parameter("string", String.class));
                    }
                };
                f.setName("lower");
                f.setParameters(Arrays.asList(left));
                f.accept(this, Arrays.asList(leftContext));
                this.out.write(" " + type + " ");
                f.setParameters(Arrays.asList(right));
                f.accept(this, Arrays.asList(rightContext));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    private void encodeEnumeratedComparison(Expression right, Expression left, String type, boolean matchCase) throws IOException {
        EnumMapping mapping = this.getEnumMapping(right);
        if (mapping != null) {
            PropertyName rightName = (PropertyName)right;
            if (left instanceof Literal) {
                String value = (String)left.evaluate(null, String.class);
                String code = mapping.fromValue(value, matchCase);
                if (code == null) {
                    this.out.write("FALSE");
                } else {
                    this.out.write(String.valueOf(code));
                    this.out.write(" " + type + " ");
                    this.writeEncodedField(Integer.class, rightName, (AttributeDescriptor)right.evaluate((Object)this.featureType));
                }
            } else {
                this.out.write("CASE ");
                if (!matchCase) {
                    this.out.write("lower(");
                    this.writeBinaryExpressionMember(left, Integer.class);
                    this.out.write(")");
                }
                for (Map.Entry<String, String> entry : mapping.valueToKeyMap().entrySet()) {
                    this.out.write("WHEN '" + entry.getKey() + "' THEN " + entry.getValue() + "\n");
                }
                this.out.write("END");
                this.out.write(" " + type + " ");
                this.writeEncodedField(Integer.class, rightName, (AttributeDescriptor)right.evaluate((Object)this.featureType));
            }
        } else {
            mapping = this.getEnumMapping(left);
            PropertyName leftName = (PropertyName)left;
            if (right instanceof Literal) {
                String value = (String)right.evaluate(null, String.class);
                String code = mapping.fromValue(value, matchCase);
                if (code == null) {
                    this.out.write("FALSE");
                } else {
                    this.writeEncodedField(Integer.class, leftName, (AttributeDescriptor)left.evaluate((Object)this.featureType));
                    this.out.write(" " + type + " ");
                    this.out.write(String.valueOf(code));
                }
            } else {
                this.writeEncodedField(Integer.class, leftName, (AttributeDescriptor)left.evaluate((Object)this.featureType));
                this.out.write(" " + type + " ");
                this.out.write("CASE ");
                if (!matchCase) {
                    this.out.write("lower(");
                    this.writeBinaryExpressionMember(right, Integer.class);
                    this.out.write(")");
                }
                for (Map.Entry<String, String> entry : mapping.valueToKeyMap().entrySet()) {
                    this.out.write("WHEN '" + entry.getKey() + "' THEN " + entry.getValue() + "\n");
                }
                this.out.write("END");
            }
        }
    }

    private boolean isEnumerated(Expression ex) {
        return this.getEnumMapping(ex) != null;
    }

    private EnumMapping getEnumMapping(Expression ex) {
        Object o;
        AttributeDescriptor ad;
        if (ex instanceof PropertyName && (ad = (AttributeDescriptor)ex.evaluate((Object)this.featureType)) != null && (o = ad.getUserData().get("org.geotools.jdbc.enumMap")) instanceof EnumMapping) {
            return (EnumMapping)o;
        }
        return null;
    }

    protected void writeBinaryExpressionMember(Expression exp, Class context) throws IOException {
        if (context != null && this.isBinaryExpression(exp)) {
            this.writeBinaryExpression(exp, context);
        } else {
            exp.accept((ExpressionVisitor)this, (Object)context);
        }
    }

    public Class getExpressionType(Expression expression) {
        Class ret;
        Class binding = null;
        if (expression instanceof PropertyName) {
            AttributeDescriptor attType = (AttributeDescriptor)expression.evaluate((Object)this.featureType);
            if (attType != null) {
                binding = attType.getType().getBinding();
            }
        } else if (expression instanceof Function && (ret = this.getFunctionReturnType((Function)expression)) != null) {
            binding = ret;
        }
        return binding;
    }

    private void encodeInComparison(Function in, Literal bool, Object extraData) {
        boolean negated = "!=".equals(extraData);
        if (bool.evaluate(null, Boolean.class) == Boolean.FALSE) {
            negated = !negated;
        }
        this.visitInFunction(in, false, negated, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBinaryExpression(Expression e, Class context) throws IOException {
        Writer tmp = this.out;
        try {
            this.out = new StringWriter();
            this.out.write("(");
            e.accept((ExpressionVisitor)this, null);
            this.out.write(")");
            tmp.write(this.cast(this.out.toString(), context));
        }
        finally {
            this.out = tmp;
        }
    }

    protected Class getFunctionReturnType(Function f) {
        Class clazz = Object.class;
        if (f.getFunctionName() != null && f.getFunctionName().getReturn() != null) {
            clazz = f.getFunctionName().getReturn().getType();
        }
        if (clazz == Object.class) {
            clazz = null;
        }
        return clazz;
    }

    protected boolean isBinaryExpression(Expression e) {
        return e instanceof BinaryExpression;
    }

    public Object visit(PropertyIsNull filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting NullFilter");
        Expression expr = filter.getExpression();
        try {
            if (this.isEnumerated(expr)) {
                this.writeEncodedField(Integer.class, (PropertyName)expr, (AttributeDescriptor)expr.evaluate((Object)this.featureType));
            } else {
                expr.accept((ExpressionVisitor)this, extraData);
            }
            this.out.write(" IS NULL ");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("isNil not supported");
    }

    public Object visit(Id filter, Object extraData) {
        if (this.primaryKey == null) {
            throw new RuntimeException("Must set primary key before trying to encode FIDFilters");
        }
        Set ids = filter.getIdentifiers();
        LOGGER.finer("Exporting FID=" + ids);
        try {
            if (ids.size() > 1) {
                this.out.write("(");
            }
            List<PrimaryKeyColumn> columns = this.primaryKey.getColumns();
            Iterator i = ids.iterator();
            while (i.hasNext()) {
                Identifier id = (Identifier)i.next();
                List<Object> attValues = JDBCDataStore.decodeFID(this.primaryKey, id.toString(), false);
                this.out.write("(");
                for (int j = 0; j < attValues.size(); ++j) {
                    if (filter instanceof JoinId) {
                        this.out.write(this.escapeName(((JoinId)filter).getAlias()));
                        this.out.write(".");
                    }
                    this.out.write(this.escapeName(columns.get(j).getName()));
                    this.out.write(" = ");
                    this.writeLiteral(attValues.get(j));
                    if (j >= attValues.size() - 1) continue;
                    this.out.write(" AND ");
                }
                this.out.write(")");
                if (!i.hasNext()) continue;
                this.out.write(" OR ");
            }
            if (ids.size() > 1) {
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
        return extraData;
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        if (filter == null) {
            throw new NullPointerException("Filter to be encoded cannot be null");
        }
        if (!(filter instanceof BinarySpatialOperator)) {
            throw new IllegalArgumentException("This filter is not a binary spatial operator, can't do SDO relate against it: " + filter.getClass());
        }
        BinarySpatialOperator op = filter;
        Expression e1 = op.getExpression1();
        Expression e2 = op.getExpression2();
        if (e1 instanceof Literal && e2 instanceof PropertyName) {
            e1 = op.getExpression2();
            e2 = op.getExpression1();
        }
        if (e1 instanceof PropertyName) {
            AttributeDescriptor descriptor;
            this.currentGeometry = null;
            this.currentSRID = null;
            this.currentDimension = null;
            if (this.featureType != null && (descriptor = (AttributeDescriptor)e1.evaluate((Object)this.featureType)) instanceof GeometryDescriptor) {
                this.currentGeometry = (GeometryDescriptor)descriptor;
                this.currentSRID = (Integer)descriptor.getUserData().get("nativeSRID");
                this.currentDimension = (Integer)descriptor.getUserData().get(Hints.COORDINATE_DIMENSION);
            }
        }
        if (e1 instanceof PropertyName && e2 instanceof Literal) {
            return this.visitBinarySpatialOperator(filter, (PropertyName)e1, (Literal)e2, filter.getExpression1() instanceof Literal, extraData);
        }
        return this.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    protected Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, Object extraData) {
        if (filter == null) {
            throw new NullPointerException("Null filter");
        }
        Expression e1 = filter.getExpression1();
        Expression e2 = filter.getExpression2();
        if (e1 instanceof Literal && e2 instanceof PropertyName) {
            e1 = filter.getExpression2();
            e2 = filter.getExpression1();
        }
        if (e1 instanceof PropertyName && e2 instanceof Literal) {
            return this.visitBinaryTemporalOperator(filter, (PropertyName)e1, (Literal)e2, filter.getExpression1() instanceof Literal, extraData);
        }
        return this.visitBinaryTemporalOperator(filter, e1, e2, extraData);
    }

    protected Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, PropertyName property, Literal temporal, boolean swapped, Object extraData) {
        Class typeContext = null;
        AttributeDescriptor attType = (AttributeDescriptor)property.evaluate((Object)this.featureType);
        if (attType != null) {
            typeContext = attType.getType().getBinding();
        }
        Period period = null;
        if (temporal.evaluate(null) instanceof Period) {
            period = (Period)temporal.evaluate(null);
        }
        if ((filter instanceof Begins || filter instanceof BegunBy || filter instanceof Ends || filter instanceof EndedBy || filter instanceof During || filter instanceof TContains) && period == null) {
            throw new IllegalArgumentException("Filter requires a time period");
        }
        if (filter instanceof TEquals && period != null) {
            throw new IllegalArgumentException("TEquals filter does not accept time period");
        }
        if ((filter instanceof Begins || filter instanceof Ends || filter instanceof During) && swapped) {
            throw new IllegalArgumentException("Time period must be second argument of Filter");
        }
        if ((filter instanceof BegunBy || filter instanceof EndedBy || filter instanceof TContains) && !swapped) {
            throw new IllegalArgumentException("Time period must be first argument of Filter");
        }
        try {
            if (filter instanceof After || filter instanceof Before) {
                String inv;
                String op = filter instanceof After ? " > " : " < ";
                String string = inv = filter instanceof After ? " < " : " > ";
                if (period != null) {
                    this.out.write("(");
                    property.accept((ExpressionVisitor)this, extraData);
                    this.out.write(swapped ? inv : op);
                    this.visitBegin(period, extraData);
                    this.out.write(" AND ");
                    property.accept((ExpressionVisitor)this, extraData);
                    this.out.write(swapped ? inv : op);
                    this.visitEnd(period, extraData);
                    this.out.write(")");
                } else {
                    if (swapped) {
                        temporal.accept((ExpressionVisitor)this, (Object)typeContext);
                    } else {
                        property.accept((ExpressionVisitor)this, extraData);
                    }
                    this.out.write(op);
                    if (swapped) {
                        property.accept((ExpressionVisitor)this, extraData);
                    } else {
                        temporal.accept((ExpressionVisitor)this, (Object)typeContext);
                    }
                }
            } else if (filter instanceof Begins || filter instanceof Ends || filter instanceof BegunBy || filter instanceof EndedBy) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(" = ");
                if (filter instanceof Begins || filter instanceof BegunBy) {
                    this.visitBegin(period, extraData);
                } else {
                    this.visitEnd(period, extraData);
                }
            } else if (filter instanceof During || filter instanceof TContains) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(" BETWEEN ");
                this.visitBegin(period, extraData);
                this.out.write(" AND ");
                this.visitEnd(period, extraData);
            } else if (filter instanceof TEquals) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(" = ");
                temporal.accept((ExpressionVisitor)this, (Object)typeContext);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding temporal filter", e);
        }
        return extraData;
    }

    void visitBegin(Period p, Object extraData) {
        filterFactory.literal((Object)p.getBeginning().getPosition().getDate()).accept((ExpressionVisitor)this, extraData);
    }

    void visitEnd(Period p, Object extraData) {
        filterFactory.literal((Object)p.getEnding().getPosition().getDate()).accept((ExpressionVisitor)this, extraData);
    }

    protected Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, Expression e1, Expression e2, Object extraData) {
        if (!(filter instanceof After || filter instanceof Before || filter instanceof TEquals)) {
            throw new IllegalArgumentException("Unsupported filter: " + filter + ". Only After,Before,TEquals supported");
        }
        String op = filter instanceof After ? ">" : (filter instanceof Before ? "<" : "=");
        try {
            e1.accept((ExpressionVisitor)this, extraData);
            this.out.write(" " + op + " ");
            e2.accept((ExpressionVisitor)this, extraData);
        }
        catch (IOException e) {
            return new RuntimeException("Error encoding temporal filter", e);
        }
        return extraData;
    }

    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    public Object visit(PropertyName expression, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyName");
        Class target = null;
        if (extraData instanceof Class) {
            target = (Class)extraData;
        }
        try {
            SimpleFeatureType featureType = this.featureType;
            if (expression instanceof JoinPropertyName) {
                this.out.write(this.escapeName(((JoinPropertyName)expression).getAlias()));
                this.out.write(".");
            }
            AttributeDescriptor attribute = null;
            EnumMapping mapping = null;
            try {
                attribute = (AttributeDescriptor)expression.evaluate((Object)featureType);
                if (attribute != null) {
                    mapping = (EnumMapping)attribute.getUserData().get("org.geotools.jdbc.enumMap");
                }
            }
            catch (Exception e) {
                String msg = "Error occurred mapping " + expression + " to feature type";
                LOGGER.log(Level.WARNING, msg, e);
            }
            if (mapping != null) {
                this.out.write("CASE ");
            }
            this.writeEncodedField(target, expression, attribute);
            if (mapping != null) {
                this.out.write("\n ");
                for (Map.Entry<String, String> entry : mapping.keyToValueMap().entrySet()) {
                    this.out.write("WHEN " + entry.getKey() + " THEN '" + entry.getValue() + "'\n");
                }
                this.out.write("END");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing attribute exp", ioe);
        }
        return extraData;
    }

    private void writeEncodedField(Class<?> target, PropertyName expression, AttributeDescriptor attribute) throws IOException {
        String encodedField;
        if (attribute != null) {
            encodedField = this.fieldEncoder.encode(this.escapeName(attribute.getLocalName()));
            if (target != null && target.isAssignableFrom(attribute.getType().getBinding())) {
                target = null;
            }
        } else {
            encodedField = this.fieldEncoder.encode(this.escapeName(expression.getPropertyName()));
        }
        if (target != null) {
            this.out.write(this.cast(encodedField, target));
        } else {
            this.out.write(encodedField);
        }
    }

    protected String cast(String encodedProperty, Class target) throws IOException {
        return encodedProperty;
    }

    public Object visit(Literal expression, Object context) throws RuntimeException {
        LOGGER.finer("exporting LiteralExpression");
        Class target = null;
        if (context instanceof Class) {
            target = (Class)context;
        }
        try {
            Object literal = this.evaluateLiteral(expression, target);
            if (literal instanceof Geometry) {
                this.visitLiteralGeometry(filterFactory.literal(literal));
            } else if (literal instanceof Envelope) {
                this.visitLiteralGeometry(filterFactory.literal((Object)BBOXImpl.boundingPolygon((Envelope)literal)));
            } else {
                this.writeLiteral(literal);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO problems writing literal", e);
        }
        return context;
    }

    public Object evaluateLiteral(Literal expression, Class<?> target) {
        Number number;
        Object literal = null;
        if (target != null) {
            if (Number.class.isAssignableFrom(target)) {
                literal = this.safeConvertToNumber((Expression)expression, target);
                if (literal == null) {
                    literal = this.safeConvertToNumber((Expression)expression, Number.class);
                }
            } else {
                literal = expression.evaluate(null, target);
            }
        }
        if (target == null && (number = this.safeConvertToNumber((Expression)expression, Number.class)) != null) {
            literal = number;
        }
        if (literal == null) {
            literal = expression.evaluate(null);
        }
        if (literal == null) {
            literal = expression.getValue();
        }
        return literal;
    }

    Number safeConvertToNumber(Expression expression, Class<?> target) {
        Object evaluated = expression.evaluate(null);
        if (evaluated != null && evaluated.getClass().isArray()) {
            return null;
        }
        return (Number)Converters.convert((Object)evaluated, target, (Hints)new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)true));
    }

    protected void writeLiteral(Object literal) throws IOException {
        if (literal == null) {
            this.out.write("NULL");
        } else if (literal instanceof Number || literal instanceof Boolean) {
            this.out.write(String.valueOf(literal));
        } else if (literal instanceof java.sql.Date || literal instanceof Timestamp) {
            this.out.write("'" + literal + "'");
        } else if (literal instanceof Date) {
            Timestamp ts = new Timestamp(((Date)literal).getTime());
            this.out.write("'" + ts + "'");
        } else if (literal instanceof Instant) {
            Date date = ((Instant)literal).getPosition().getDate();
            Timestamp ts = new Timestamp(date.getTime());
            this.out.write("'" + ts + "'");
        } else if (literal.getClass().isArray()) {
            this.out.write("ARRAY[");
            int length = Array.getLength(literal);
            for (int i = 0; i < length; ++i) {
                this.writeLiteral(Array.get(literal, i));
                if (i >= length - 1) continue;
                this.out.write(", ");
            }
            this.out.write("]");
        } else {
            String encoding = (String)Converters.convert((Object)literal, String.class, null);
            if (encoding == null) {
                encoding = literal.toString();
            }
            String escaped = this.escapeLiteral(encoding);
            this.out.write("'" + escaped + "'");
        }
    }

    public String escapeLiteral(String literal) {
        return EscapeSql.escapeLiteral(literal, this.escapeBackslash, false);
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    protected void visitLiteralTimePeriod(Period expression) {
        throw new RuntimeException("Time periods not supported, subclasses must implement this method to support encoding timeperiods");
    }

    public Object visit(Add expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "+", extraData);
    }

    public Object visit(Divide expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "/", extraData);
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "*", extraData);
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "-", extraData);
    }

    protected Object visit(BinaryExpression expression, String operator, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting Expression Math");
        try {
            this.encodeBinaryExpressionChild(expression.getExpression1(), extraData);
            this.out.write(" " + operator + " ");
            this.encodeBinaryExpressionChild(expression.getExpression2(), extraData);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing expression", ioe);
        }
        return extraData;
    }

    private void encodeBinaryExpressionChild(Expression expression, Object extraData) throws IOException {
        boolean needsParens = expression instanceof BinaryExpression;
        if (needsParens) {
            this.out.write("(");
        }
        expression.accept((ExpressionVisitor)this, extraData);
        if (needsParens) {
            this.out.write(")");
        }
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        if (this.inEncodingEnabled && InFunction.isInFunction((Expression)function)) {
            this.visitInFunction(function, true, false, extraData);
        } else {
            try {
                List parameters = function.getParameters();
                this.encodingFunction = true;
                this.out.write(this.getFunctionName(function));
                this.out.write("(");
                List arguments = function.getFunctionName().getArguments();
                Parameter lastArgument = arguments.isEmpty() ? null : (Parameter)arguments.get(arguments.size() - 1);
                for (int i = 0; i < parameters.size(); ++i) {
                    Expression e = (Expression)parameters.get(i);
                    Class context = arguments.size() <= i && (lastArgument.getMaxOccurs() > 0 || lastArgument.getMaxOccurs() == -1) ? lastArgument.getType() : ((Parameter)arguments.get(i)).getType();
                    e.accept((ExpressionVisitor)this, (Object)context);
                    if (i >= parameters.size() - 1) continue;
                    this.out.write(",");
                }
                this.out.write(")");
                this.encodingFunction = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return extraData;
    }

    protected void visitInFunction(Function function, boolean encodeAsExpression, boolean negate, Object extraData) {
        try {
            if (encodeAsExpression) {
                this.out.write("(");
            }
            List parameters = function.getParameters();
            Class context = function.getParameters().stream().filter(p -> p instanceof PropertyName).map(p -> p.evaluate((Object)this.featureType)).filter(o -> o instanceof AttributeDescriptor).map(o -> ((AttributeDescriptor)o).getType().getBinding()).findFirst().orElse(null);
            ((Expression)function.getParameters().get(0)).accept((ExpressionVisitor)this, (Object)context);
            if (negate) {
                this.out.write(" NOT IN (");
            } else {
                this.out.write(" IN (");
            }
            int size = parameters.size();
            for (int i = 1; i < size; ++i) {
                Expression e = (Expression)function.getParameters().get(i);
                e.accept((ExpressionVisitor)this, (Object)context);
                if (i >= size - 1) continue;
                this.out.write(", ");
            }
            this.out.write(")");
            if (encodeAsExpression) {
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Expression getParameter(Function function, int idx, boolean mandatory) {
        List params = function.getParameters();
        if (params == null || params.size() <= idx) {
            if (mandatory) {
                throw new IllegalArgumentException("Missing parameter number " + (idx + 1) + " for function " + function.getName() + ", cannot encode in SQL");
            }
            return null;
        }
        return (Expression)params.get(idx);
    }

    protected String getFunctionName(Function function) {
        return function.getName();
    }

    public Object visit(NilExpression expression, Object extraData) {
        try {
            this.out.write(" ");
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing expression", ioe);
        }
        return extraData;
    }

    public Object visit(After after, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)after, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)anyInteracts, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)before, extraData);
    }

    public Object visit(Begins begins, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begins, extraData);
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begunBy, extraData);
    }

    public Object visit(During during, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)during, extraData);
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)endedBy, extraData);
    }

    public Object visit(Ends ends, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)ends, extraData);
    }

    public Object visit(Meets meets, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)meets, extraData);
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)metBy, extraData);
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)overlappedBy, extraData);
    }

    public Object visit(TContains contains, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData);
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)equals, extraData);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData);
    }

    public void setSqlNameEscape(String escape) {
        this.sqlNameEscape = escape;
    }

    public String getSqlNameEscape() {
        return this.sqlNameEscape;
    }

    public String escapeName(String name) {
        int escapeOffset;
        if (this.sqlNameEscape.isEmpty()) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.sqlNameEscape);
        int offset = 0;
        while ((escapeOffset = name.indexOf(this.sqlNameEscape, offset)) != -1) {
            sb.append(name.substring(offset, escapeOffset));
            sb.append(this.sqlNameEscape);
            sb.append(this.sqlNameEscape);
            offset = escapeOffset + this.sqlNameEscape.length();
        }
        sb.append(name.substring(offset));
        sb.append(this.sqlNameEscape);
        return sb.toString();
    }

    public void setFieldEncoder(FieldEncoder fieldEncoder) {
        this.fieldEncoder = fieldEncoder;
    }

    protected double getDistanceInNativeUnits(DistanceBufferOperator operator) {
        return DistanceBufferUtil.getDistanceInNativeUnits(operator, this.currentSRID);
    }

    public Object visit(NativeFilter filter, Object data) {
        try {
            this.out.write("(" + filter.getNative() + ")");
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error encoding native filter '%s'.", filter.getNative()), exception);
        }
        return data;
    }

    private static class DefaultFieldEncoder
    implements FieldEncoder {
        public static DefaultFieldEncoder DEFAULT_FIELD_ENCODER = new DefaultFieldEncoder();

        private DefaultFieldEncoder() {
        }

        @Override
        public String encode(String s) {
            return s;
        }
    }

    public static interface FieldEncoder {
        public String encode(String var1);
    }
}

