/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.AbstractProcessorDecoratorSupport;

public class ProcessorDecorator
extends AbstractProcessorDecoratorSupport<ResourcePreProcessor> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorDecorator.class);

    public ProcessorDecorator(Object processor) {
        super(ProcessorDecorator.transform(processor));
    }

    private static ResourcePreProcessor transform(Object processor) {
        Validate.notNull((Object)processor);
        if (processor instanceof ResourcePreProcessor) {
            return (ResourcePreProcessor)processor;
        }
        if (processor instanceof ResourcePostProcessor) {
            return ProcessorDecorator.toPreProcessor((ResourcePostProcessor)processor);
        }
        throw new IllegalArgumentException("Invalid processor: " + processor);
    }

    private static ResourcePreProcessor toPreProcessor(final ResourcePostProcessor postProcessor) {
        return new AbstractProcessorDecoratorSupport<ResourcePostProcessor>(postProcessor){

            @Override
            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                postProcessor.process(reader, writer);
            }

            @Override
            protected boolean isMinimizeInternal() {
                return this.isMinimizeForProcessor(postProcessor);
            }

            @Override
            protected SupportedResourceType getSupportedResourceTypeInternal() {
                return this.getSupportedResourceTypeForProcessor(postProcessor);
            }

            @Override
            public String toString() {
                return postProcessor.toString();
            }
        };
    }

    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        if (this.isEnabled(resource)) {
            LOG.debug("Applying processor: {}", (Object)this.toString());
            ((ResourcePreProcessor)this.getDecoratedObject()).process(resource, reader, writer);
        } else {
            LOG.debug("Skipping processor: {}", this.getDecoratedObject());
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
    }

    public final boolean isEligible(boolean minimize, ResourceType searchedType) {
        Validate.notNull((Object)((Object)searchedType));
        SupportedResourceType supportedType = this.getSupportedResourceType();
        boolean isTypeSatisfied = supportedType == null || supportedType != null && searchedType == supportedType.value();
        boolean isMinimizedSatisfied = minimize || !this.isMinimize();
        return isTypeSatisfied && isMinimizedSatisfied;
    }

    protected boolean isEnabled(Resource resource) {
        return true;
    }

    @Override
    public String toString() {
        return ((ResourcePreProcessor)this.getDecoratedObject()).toString();
    }
}

