/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.wildcard;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.wildcard.DefaultWildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardContext;

public class JarWildcardStreamLocator
extends DefaultWildcardStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(JarWildcardStreamLocator.class);
    private static final List<String> SUPPORTED_EXTENSIONS = Arrays.asList(".jar");
    private static final String EMBEDDED_JAR_PREFIX = "!" + File.separatorChar;
    private static final String PREFIX_FILE = "file:";

    @Override
    public InputStream locateStream(String uri, File folder) throws IOException {
        Validate.notNull((Object)folder);
        File jarPath = this.getJarFile(folder);
        if (this.isSupported(jarPath)) {
            return this.locateStreamFromJar(uri, jarPath);
        }
        return super.locateStream(uri, folder);
    }

    private boolean isSupported(File jarPath) {
        LOG.debug("jarPath: {}", (Object)jarPath);
        for (String supportedExtension : SUPPORTED_EXTENSIONS) {
            if (!jarPath.getPath().endsWith(supportedExtension) || jarPath.getPath().contains(EMBEDDED_JAR_PREFIX)) continue;
            return true;
        }
        return false;
    }

    File getJarFile(File folder) {
        return new File(StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)folder.getPath(), (String)"!"), (String)PREFIX_FILE));
    }

    private boolean accept(String entryName, String wildcard) {
        return FilenameUtils.wildcardMatch((String)entryName, (String)wildcard);
    }

    JarFile open(File jarFile) throws IOException {
        Validate.isTrue((boolean)jarFile.exists(), (String)"The JAR file must exists.", (Object[])new Object[0]);
        return new JarFile(jarFile);
    }

    private InputStream locateStreamFromJar(String uri, File jarPath) throws IOException {
        LOG.debug("Locating stream from jar: {}", (Object)jarPath);
        WildcardContext wildcardContext = new WildcardContext(uri, jarPath);
        String classPath = FilenameUtils.getPath((String)uri);
        if (classPath.startsWith(ClasspathUriLocator.PREFIX)) {
            classPath = StringUtils.substringAfter((String)classPath, (String)ClasspathUriLocator.PREFIX);
        }
        try (JarFile jarFile = this.open(jarPath);){
            ArrayList<JarEntry> jarEntryList = Collections.list(jarFile.entries());
            ArrayList<JarEntry> filteredJarEntryList = new ArrayList<JarEntry>();
            ArrayList<File> allFiles = new ArrayList<File>();
            for (JarEntry entry : jarEntryList) {
                String entryName = entry.getName();
                boolean isSupportedEntry = entryName.startsWith(classPath) && !entryName.equals(classPath) && this.accept(entryName, wildcardContext.getWildcard());
                if (!isSupportedEntry) continue;
                allFiles.add(new File(entryName));
                LOG.debug("\tfound jar entry: {}", (Object)entryName);
                filteredJarEntryList.add(entry);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.triggerWildcardExpander(allFiles, wildcardContext);
            for (JarEntry entry : filteredJarEntryList) {
                InputStream is = jarFile.getInputStream(entry);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
            return bufferedInputStream;
        }
    }
}

