/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeVisitor;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;

public class Node_Triple
extends Node {
    private final Triple triple;

    public Node_Triple(Node s, Node p, Node o) {
        this(Triple.create(s, p, o));
    }

    public Node_Triple(Triple triple) {
        super(triple);
        this.triple = triple;
    }

    @Override
    public Triple getTriple() {
        return this.triple;
    }

    @Override
    public boolean isConcrete() {
        return this.getTriple().isConcrete();
    }

    @Override
    public boolean isNodeTriple() {
        return true;
    }

    @Override
    public Object visitWith(NodeVisitor v) {
        return v.visitTriple(this, this.triple);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.label);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node_Triple other = (Node_Triple)obj;
        return Objects.equals(this.label, other.label);
    }

    @Override
    public String toString(PrefixMapping pm, boolean quoting) {
        return "<< " + this.label.toString() + " >>";
    }
}

