/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.MarcXmlParserThread;
import org.marc4j.RecordStack;
import org.marc4j.marc.Record;
import org.xml.sax.InputSource;

public class MarcXmlReader
implements MarcReader {
    private RecordStack queue = new RecordStack();

    public MarcXmlReader(InputStream input) {
        this(new InputSource(input));
    }

    public MarcXmlReader(InputSource input) {
        MarcXmlParserThread producer = new MarcXmlParserThread(this.queue, input);
        producer.start();
    }

    public MarcXmlReader(InputStream input, String stylesheetUrl) {
        this(new InputSource(input), (Source)new StreamSource(stylesheetUrl));
    }

    public MarcXmlReader(InputStream input, Source stylesheet) {
        this(new InputSource(input), stylesheet);
    }

    public MarcXmlReader(InputSource input, Source stylesheet) {
        MarcXmlParserThread producer = new MarcXmlParserThread(this.queue, input);
        TransformerFactory factory = TransformerFactory.newInstance();
        SAXTransformerFactory stf = (SAXTransformerFactory)factory;
        TransformerHandler th = null;
        try {
            th = stf.newTransformerHandler(stylesheet);
        }
        catch (TransformerConfigurationException e) {
            throw new MarcException("Error creating TransformerHandler", e);
        }
        producer.setTransformerHandler(th);
        producer.start();
    }

    public MarcXmlReader(InputStream input, TransformerHandler th) {
        this(new InputSource(input), th);
    }

    public MarcXmlReader(InputSource input, TransformerHandler th) {
        MarcXmlParserThread producer = new MarcXmlParserThread(this.queue, input);
        producer.setTransformerHandler(th);
        producer.start();
    }

    public boolean hasNext() {
        return this.queue.hasNext();
    }

    public Record next() {
        return this.queue.pop();
    }
}

