/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.comp;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.comp.ASTBuiltinType;
import org.jzkit.a2j.codec.comp.ASTChoiceType;
import org.jzkit.a2j.codec.comp.ASTClassNumber;
import org.jzkit.a2j.codec.comp.ASTDefinedType;
import org.jzkit.a2j.codec.comp.ASTEnumeratedType;
import org.jzkit.a2j.codec.comp.ASTSetOrSequenceOfType;
import org.jzkit.a2j.codec.comp.ASTSetOrSequenceType;
import org.jzkit.a2j.codec.comp.ASTSizeConstraint;
import org.jzkit.a2j.codec.comp.ASTTag;
import org.jzkit.a2j.codec.comp.ASTTaggedType;
import org.jzkit.a2j.codec.comp.ASTType;
import org.jzkit.a2j.codec.comp.BitStringTypeInfo;
import org.jzkit.a2j.codec.comp.BuiltinTypeInfo;
import org.jzkit.a2j.codec.comp.ChoiceTypeInfo;
import org.jzkit.a2j.codec.comp.DefinedTypeInfo;
import org.jzkit.a2j.codec.comp.EnumTypeInfo;
import org.jzkit.a2j.codec.comp.IntegerTypeInfo;
import org.jzkit.a2j.codec.comp.ModuleInfo;
import org.jzkit.a2j.codec.comp.NullTypeInfo;
import org.jzkit.a2j.codec.comp.OIDTypeInfo;
import org.jzkit.a2j.codec.comp.OctetStringTypeInfo;
import org.jzkit.a2j.codec.comp.SequenceOfTypeInfo;
import org.jzkit.a2j.codec.comp.SequenceTypeInfo;
import org.jzkit.a2j.codec.comp.TypeInfo;

public class CodecBuilderInfo {
    private static Logger log = Logger.getLogger(CodecBuilderInfo.class.getName());
    public static String[][] builtinTypeInfo = new String[][]{{"java.math.BigInteger", null}, {"org.jzkit.a2j.codec.runtime.AsnBitString", null}, {null, null}, {"java.util.ArrayList", null}, {null, null}, {null, null}, {null, null}, {null, null}, {"java.math.BigInteger", null}, {"byte[]", null}, {"int[]", null}, {"java.math.BigDecimal", null}, {"java.lang.Boolean", null}, {"org.jzkit.a2j.codec.runtime.AsnNull", null}};
    private static int inline_codec_counter = 0;
    private static CodecBuilderInfo self = null;
    String pkg_name = null;
    String pkg_dir = null;
    private Vector import_list = new Vector();
    private Hashtable modules = new Hashtable();
    boolean default_tagging_is_explicit = true;
    String current_module_name = null;

    public static synchronized CodecBuilderInfo getInfo() {
        if (self == null) {
            self = new CodecBuilderInfo();
        }
        return self;
    }

    public CodecBuilderInfo() {
        this.registerModule("Builtin", true, false, null, null);
        ModuleInfo bim = this.lookupModule("Builtin");
        bim.registerType("Integer", new BuiltinTypeInfo("Integer", true, 0, 2, false, null, "BigInteger", bim));
        bim.registerType("BitString", new BuiltinTypeInfo("BitString", true, 0, 3, false, null, "AsnBitString", bim));
        bim.registerType("OID", new BuiltinTypeInfo("OID", true, 0, 6, false, null, "int[]", bim));
        bim.registerType("OctetString", new BuiltinTypeInfo("OctetString", true, 0, 4, false, null, "byte[]", bim));
        bim.registerType("BOOL", new BuiltinTypeInfo("BOOL", true, 0, 1, false, null, "Boolean", bim));
        bim.registerType("SetOrSequenceOf", new BuiltinTypeInfo("SetOrSequenceOf", true, 0, 16, false, null, "java.util.ArrayList", bim));
        bim.registerType("Any", new BuiltinTypeInfo("Any", true, 0, 100, false, null, "Object", bim));
        bim.registerType("Enumerated", new BuiltinTypeInfo("Enumerated", true, 0, 10, false, null, "BigInteger", bim));
        bim.registerType("NULL", new BuiltinTypeInfo("NULL", true, 0, 5, false, null, "org.jzkit.a2j.codec.runtime.AsnNull", bim));
        this.registerModule("AsnUseful", false, false, "org.jzkit.a2j.gen.AsnUseful", null);
        ModuleInfo uim = this.lookupModule("AsnUseful");
        uim.registerType("ObjectDescriptor", new DefinedTypeInfo("ObjectDescriptor", true, 0, 7, true, "OctetString", "java.lang.String", uim));
        uim.registerType("NumericString", new DefinedTypeInfo("NumericString", true, 0, 18, true, "OctetString", "java.lang.String", uim));
        uim.registerType("PrintableString", new DefinedTypeInfo("PrintableString", true, 0, 19, true, "OctetString", "java.lang.String", uim));
        uim.registerType("TeletexString", new DefinedTypeInfo("TeletexString", true, 0, 20, true, "OctetString", "java.lang.String", uim));
        uim.registerType("T61String", new DefinedTypeInfo("T61String", true, 0, 20, true, "OctetString", "java.lang.String", uim));
        uim.registerType("VideotexString", new DefinedTypeInfo("VideotexString", true, 0, 21, true, "OctetString", "java.lang.String", uim));
        uim.registerType("IA5String", new DefinedTypeInfo("IA5String", true, 0, 22, true, "OctetString", "java.lang.String", uim));
        uim.registerType("GraphicString", new DefinedTypeInfo("GraphicString", true, 0, 25, true, "OctetString", "java.lang.String", uim));
        uim.registerType("VisibleString", new DefinedTypeInfo("VisibleString", true, 0, 26, true, "OctetString", "java.lang.String", uim));
        uim.registerType("ISO646String", new DefinedTypeInfo("ISO646String", true, 0, 26, true, "OctetString", "java.lang.String", uim));
        uim.registerType("GeneralString", new DefinedTypeInfo("GeneralString", true, 0, 26, true, "OctetString", "java.lang.String", uim));
        uim.registerType("UTCTime", new DefinedTypeInfo("UTCTime", true, 0, 23, true, "OctetString", "java.lang.String", uim));
        uim.registerType("GeneralizedTime", new DefinedTypeInfo("GeneralizedTime", true, 0, 24, true, "OctetString", "java.lang.String", uim));
        uim.registerType("EXTERNAL", new SequenceTypeInfo("EXTERNAL", true, 0, 8, true, "SetOrSequenceOf", null, uim));
        uim.registerType("encoding_inline0", new ChoiceTypeInfo("encoding_inline0", true, -1, -1, false, "ChoiceType", null, uim));
    }

    public static int getNextInlineCounter() {
        return inline_codec_counter++;
    }

    public ModuleInfo lookupModule(String module_name) {
        return (ModuleInfo)this.modules.get(module_name);
    }

    public String getInternalClass(int index) {
        return builtinTypeInfo[index][0];
    }

    public String getCurrentModuleName() {
        return this.current_module_name;
    }

    public ModuleInfo getCurrentModule() {
        return this.lookupModule(this.current_module_name);
    }

    public void setCurrentModuleName(String s) {
        this.current_module_name = s;
    }

    public void registerModule(String module_reference, boolean default_explicit_tagging, boolean create_java, String package_name, String output_dir) {
        log.fine("      registerModule(" + module_reference + "," + default_explicit_tagging + ")");
        ModuleInfo mi = (ModuleInfo)this.modules.get(module_reference);
        if (mi == null) {
            this.modules.put(module_reference, new ModuleInfo(module_reference, default_explicit_tagging, create_java, package_name, output_dir));
        } else {
            mi.setDefaultExplicitTagging(default_explicit_tagging);
            mi.setCreateJava(create_java);
        }
    }

    public void registerType(String module, String type, TypeInfo ti) {
        log.fine("registerType(" + module + "," + type + ",...)");
        ModuleInfo mi = (ModuleInfo)this.modules.get(module);
        if (null != mi) {
            mi.registerType(type, ti);
        } else {
            log.fine("Unknown module reference");
            System.exit(1);
        }
    }

    public void setCurrentPackageName(String pkg_name) {
        this.pkg_name = pkg_name;
    }

    public void setCurrentPackageDir(String pkg_dir) {
        this.pkg_dir = pkg_dir;
    }

    public void defaultTaggingIsImplicit() {
        this.default_tagging_is_explicit = false;
    }

    public void defaultTaggingIsExplicit() {
        this.default_tagging_is_explicit = true;
    }

    public String getCurrentPackageName() {
        return this.pkg_name;
    }

    public String getCurrentPackageDir() {
        return this.pkg_dir;
    }

    public boolean defaultTagModeIsExplicit() {
        return this.default_tagging_is_explicit;
    }

    public void resetImportList() {
        this.import_list.clear();
    }

    public void addImport(String imp) {
        log.fine("Adding import..." + imp);
        this.import_list.add(imp);
    }

    String getFullyQualifiedClassName(String classname) {
        Enumeration e = this.import_list.elements();
        while (e.hasMoreElements()) {
            String current = (String)e.nextElement();
            if (!current.endsWith("." + classname)) continue;
            return current;
        }
        return null;
    }

    public void writeModuleImports(FileWriter codec_writer) {
        try {
            Enumeration e = this.import_list.elements();
            while (e.hasMoreElements()) {
                codec_writer.write("import " + e.nextElement() + ";\n");
            }
        }
        catch (IOException ioe) {
            log.fine(ioe.toString());
        }
    }

    public void create() {
        log.fine("Processing Modules.............");
        Enumeration e = this.modules.elements();
        while (e.hasMoreElements()) {
            inline_codec_counter = 0;
            ModuleInfo mi = (ModuleInfo)e.nextElement();
            log.fine("Processing " + mi.getModulePackageName() + " " + mi.createJava());
            if (mi.createJava()) {
                mi.createCode();
                continue;
            }
            log.fine("Skipping module......" + mi.getModulePackageName());
        }
    }

    public void registerImport(String module_reference, String type_reference) {
        log.fine("Registering import of " + module_reference + "." + type_reference + " in module " + this.getCurrentModuleName());
        this.getCurrentModule().registerImport(module_reference, type_reference);
    }

    public void createTypeInfoFor(String type_reference, ASTType t) {
        CodecBuilderInfo info = CodecBuilderInfo.getInfo();
        log.fine("createTypeInfoFor(" + type_reference + ")");
        boolean has_tagging = false;
        int tag_class = -1;
        int tag_number = -1;
        boolean is_implicit = !info.default_tagging_is_explicit;
        Object base_type = null;
        if (t.which == 1) {
            ASTBuiltinType bit = (ASTBuiltinType)t.jjtGetChild(0);
            if (bit.which == 6) {
                has_tagging = true;
                ASTTaggedType tt = (ASTTaggedType)bit.jjtGetChild(0);
                is_implicit = tt.isImplicit();
                t = tt.getType();
                ASTTag tag = tt.getTag();
                tag_class = tag.hasTagClass ? tag.getTagClass().tag_class : 128;
                ASTClassNumber cn = tag.getClassNumber();
                if (cn.which == 1) {
                    tag_number = cn.getNumber().getNumber();
                } else {
                    log.log(Level.WARNING, "Unhandled tag number type");
                    System.exit(0);
                }
            }
        }
        TypeInfo ti = null;
        if (t.which == 1) {
            ASTBuiltinType bit = (ASTBuiltinType)t.jjtGetChild(0);
            switch (bit.which) {
                case 0: {
                    ti = new IntegerTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    break;
                }
                case 1: {
                    ti = new BitStringTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    break;
                }
                case 2: {
                    ASTSetOrSequenceType sos = (ASTSetOrSequenceType)bit.jjtGetChild(0);
                    if (sos.which == 1) {
                        log.log(Level.WARNING, "Set not yet handled");
                        System.exit(1);
                        break;
                    }
                    ti = new SequenceTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    sos.getSequenceMembers((SequenceTypeInfo)ti);
                    break;
                }
                case 3: {
                    log.fine("Processing SetOrSequenceOf Type");
                    ASTSetOrSequenceOfType soso = (ASTSetOrSequenceOfType)bit.jjtGetChild(0);
                    ASTType sot = null;
                    ASTSizeConstraint sc = null;
                    if (soso.has_size_constraint) {
                        sc = (ASTSizeConstraint)soso.jjtGetChild(0);
                        sot = (ASTType)soso.jjtGetChild(1);
                    } else {
                        sot = (ASTType)soso.jjtGetChild(0);
                    }
                    String subtype_reference = null;
                    if (sot.which == 1) {
                        ASTBuiltinType sub_bit = (ASTBuiltinType)sot.jjtGetChild(0);
                        log.fine("SEQUENCEOF Built in type (" + sub_bit.which + ")");
                        switch (sub_bit.which) {
                            case 2: {
                                log.fine("SEQUENCEOF SEQUENCE " + info.getInternalClass(bit.which));
                                subtype_reference = type_reference + "Item" + CodecBuilderInfo.getNextInlineCounter();
                                this.createTypeInfoFor(subtype_reference, sot);
                                break;
                            }
                            case 4: {
                                log.fine("SEQUENCEOF CHOICE " + info.getInternalClass(bit.which));
                                subtype_reference = type_reference + "_choice" + CodecBuilderInfo.getNextInlineCounter();
                                this.createTypeInfoFor(subtype_reference, sot);
                                break;
                            }
                            default: {
                                log.fine("cbi SEQUENCEOF something ok.. " + sub_bit.which + " " + info.getInternalClass(sub_bit.which));
                                subtype_reference = sub_bit.getTypeName();
                                break;
                            }
                        }
                    } else {
                        ASTDefinedType sub_dt = (ASTDefinedType)sot.jjtGetChild(0);
                        log.fine("SEQUENCEOF defined type " + sub_dt.getTypeReference().typeref);
                        subtype_reference = sub_dt.getTypeReference().typeref;
                    }
                    if (soso.which == 1) {
                        log.fine("SetOf not yet handled");
                        System.exit(1);
                        break;
                    }
                    ti = new SequenceOfTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), "java.util.ArrayList", info.getCurrentModule(), subtype_reference);
                    break;
                }
                case 4: {
                    ti = new ChoiceTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    ((ASTChoiceType)bit.jjtGetChild(0)).getChoiceMembers((ChoiceTypeInfo)ti);
                    break;
                }
                case 5: {
                    System.out.println("Better add typeinfo for selection");
                    System.exit(1);
                    break;
                }
                case 6: {
                    log.fine("Fatal error: Can't have tagged type under a tagged type");
                    System.exit(0);
                    break;
                }
                case 7: {
                    System.out.println("Better add typeinfo for Any");
                    System.exit(1);
                    break;
                }
                case 8: {
                    ti = new EnumTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    ((ASTEnumeratedType)bit.jjtGetChild(0)).getEnumerations((EnumTypeInfo)ti);
                    break;
                }
                case 9: {
                    ti = new OctetStringTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    break;
                }
                case 10: {
                    ti = new OIDTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    break;
                }
                case 11: {
                    System.out.println("Better add typeinfo for Real");
                    System.exit(1);
                    break;
                }
                case 12: {
                    System.out.println("Better add typeinfo for Boolean");
                    System.exit(1);
                    break;
                }
                case 13: {
                    ti = new NullTypeInfo(type_reference, true, tag_class, tag_number, is_implicit, bit.getTypeName(), info.getInternalClass(bit.which), info.getCurrentModule());
                    break;
                }
                default: {
                    System.out.println("Unhandled internal type");
                    System.exit(1);
                }
            }
            info.registerType(info.getCurrentModuleName(), type_reference, ti);
        } else {
            ASTDefinedType dt = (ASTDefinedType)t.jjtGetChild(0);
            log.fine("Defined Type: ");
            ti = new DefinedTypeInfo(type_reference, false, tag_class, tag_number, is_implicit, dt.getTypeReference().typeref, null, info.getCurrentModule());
            info.registerType(info.getCurrentModuleName(), type_reference, ti);
        }
    }
}

