/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.bindings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs20.FeatureCollectionType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.referencing.CRS;
import org.geotools.wfs.CompositeFeatureCollection;
import org.geotools.xsd.EMFUtils;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Envelope;

public class WFSParsingUtils {
    public static EObject FeatureCollectionType_parse(EObject fct, ElementInstance instance, Node node) {
        SimpleFeature[] featureMembers;
        SimpleFeatureCollection fc = (SimpleFeatureCollection)node.getChildValue(FeatureCollection.class);
        if (fc == null) {
            fc = new DefaultFeatureCollection(null, null);
        }
        if ((featureMembers = (SimpleFeature[])node.getChildValue(SimpleFeature[].class)) != null) {
            Collection collection = DataUtilities.collectionCast((FeatureCollection)fc);
            for (SimpleFeature featureMember : featureMembers) {
                collection.add(featureMember);
            }
        } else {
            Collection collection = DataUtilities.collectionCast((FeatureCollection)fc);
            List featureMember = node.getChildValues(SimpleFeature.class);
            for (SimpleFeature f : featureMember) {
                collection.add(f);
            }
        }
        if (!fc.isEmpty()) {
            if (EMFUtils.has((EObject)fct, (String)"feature")) {
                EMFUtils.add((EObject)fct, (String)"feature", (Object)fc);
            } else {
                EMFUtils.add((EObject)fct, (String)"member", (Object)fc);
            }
        }
        return fct;
    }

    public static Object FeatureCollectionType_getProperty(EObject fc, QName name) {
        List<FeatureCollection> features = WFSParsingUtils.features(fc);
        FeatureCollection first = features.get(0);
        if ("boundedBy".equals(name.getLocalPart())) {
            ReferencedEnvelope bounds = null;
            bounds = features.size() == 1 ? first.getBounds() : WFSParsingUtils.aggregateEnvelopes(features, first);
            if ((bounds == null || bounds.isNull()) && "http://www.opengis.net/wfs/2.0".equals(name.getNamespaceURI())) {
                return null;
            }
            return bounds;
        }
        if ("featureMember".equals(name.getLocalPart()) || "member".equals(name.getLocalPart())) {
            Number n;
            if (features.size() == 1) {
                return first;
            }
            if ("featureMember".equals(name.getLocalPart())) {
                return new CompositeFeatureCollection(features);
            }
            int numberMatched = -1;
            if (EMFUtils.has((EObject)fc, (String)"numberMatched")) {
                n = (Number)EMFUtils.get((EObject)fc, (String)"numberMatched");
                numberMatched = n != null ? n.intValue() : -1;
            } else if (EMFUtils.has((EObject)fc, (String)"numberOfFeatures")) {
                n = (Number)EMFUtils.get((EObject)fc, (String)"numberOfFeatures");
                numberMatched = n != null ? n.intValue() : -1;
            }
            ArrayList<FeatureCollectionType> members = new ArrayList<FeatureCollectionType>(features.size());
            Iterator<FeatureCollection> it = features.iterator();
            while (it.hasNext()) {
                FeatureCollection featureCollection = it.next();
                FeatureCollectionType member = Wfs20Factory.eINSTANCE.createFeatureCollectionType();
                member.setTimeStamp((Calendar)EMFUtils.get((EObject)fc, (String)"timeStamp"));
                member.getMember().add((Object)featureCollection);
                members.add(member);
                if (numberMatched == -1) continue;
                int size = featureCollection.size();
                member.setNumberReturned(BigInteger.valueOf(size));
                if (it.hasNext()) {
                    numberMatched -= size;
                    member.setNumberMatched(BigInteger.valueOf(size));
                    continue;
                }
                member.setNumberMatched(BigInteger.valueOf(numberMatched));
            }
            return members;
        }
        return null;
    }

    private static ReferencedEnvelope aggregateEnvelopes(List<FeatureCollection> features, FeatureCollection first) {
        ReferencedEnvelope bounds;
        ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>(features.size());
        ReferencedEnvelope firstBounds = first.getBounds();
        envelopes.add(firstBounds);
        for (int i = 1; i < features.size(); ++i) {
            envelopes.add(features.get(i).getBounds());
        }
        boolean consistent = true;
        for (ReferencedEnvelope envelope : envelopes) {
            if (CRS.equalsIgnoreMetadata((Object)firstBounds.getCoordinateReferenceSystem(), (Object)envelope.getCoordinateReferenceSystem())) continue;
            consistent = false;
            break;
        }
        if (consistent) {
            bounds = ReferencedEnvelope.create((ReferencedEnvelope)((ReferencedEnvelope)envelopes.get(0)));
            for (int i = 1; i < envelopes.size(); ++i) {
                bounds.expandToInclude((Envelope)envelopes.get(i));
            }
        } else {
            try {
                CoordinateReferenceSystem wgs84 = CRS.decode((String)SrsSyntax.OGC_URN.getSRS("EPSG:4326"));
                bounds = ReferencedEnvelope.create((ReferencedEnvelope)((ReferencedEnvelope)envelopes.get(0)).transform(wgs84, true));
                for (int i = 1; i < envelopes.size(); ++i) {
                    bounds.expandToInclude((Envelope)((ReferencedEnvelope)envelopes.get(i)).transform(wgs84, true));
                }
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException("Failed to aggregate envelopes from multiple CRSs", e);
            }
        }
        return bounds;
    }

    public static List<FeatureCollection> features(EObject obj) {
        return (List)(EMFUtils.has((EObject)obj, (String)"feature") ? EMFUtils.get((EObject)obj, (String)"feature") : EMFUtils.get((EObject)obj, (String)"member"));
    }
}

