/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.HTTPMapReader;
import org.mapfish.print.map.readers.KaMapCacheMapReader;
import org.mapfish.print.map.readers.KaMapMapReader;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonObject;

public abstract class TileableMapReader
extends HTTPMapReader {
    protected TileCacheLayerInfo tileCacheLayerInfo;

    protected TileableMapReader(RenderingContext context, PJsonObject params) {
        super(context, params);
    }

    @Override
    protected void renderTiles(TileRenderer formatter, Transformer transformer, URI commonUri, ParallelMapTileLoader parallelMapTileLoader) throws IOException, URISyntaxException {
        double offsetY;
        double offsetX;
        long bitmapTileH;
        long bitmapTileW;
        ArrayList<URI> urls = new ArrayList<URI>(1);
        int nbTilesW = 0;
        double minGeoX = transformer.getRotatedMinGeoX();
        double minGeoY = transformer.getRotatedMinGeoY();
        double maxGeoX = transformer.getRotatedMaxGeoX();
        double maxGeoY = transformer.getRotatedMaxGeoY();
        if (this.tileCacheLayerInfo != null) {
            float tileMinGeoY;
            float tileMinGeoX;
            try {
                transformer = this.fixTiledTransformer(transformer);
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(TileableMapReader.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (transformer == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolution out of bounds.");
                }
                urls.add(null);
            }
            bitmapTileW = this.tileCacheLayerInfo.getWidth();
            bitmapTileH = this.tileCacheLayerInfo.getHeight();
            double tileGeoWidth = transformer.getResolution() * (double)bitmapTileW;
            double tileGeoHeight = transformer.getResolution() * (double)bitmapTileH;
            if (this instanceof KaMapCacheMapReader || this instanceof KaMapMapReader) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Kamap min geo x and y calculation used");
                }
                tileMinGeoX = (float)(Math.floor(minGeoX / tileGeoWidth) * tileGeoWidth);
                tileMinGeoY = (float)(Math.floor(minGeoY / tileGeoHeight) * tileGeoHeight);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Default min geo x and y calculation used");
                }
                tileMinGeoX = (float)(this.tileCacheLayerInfo.getOriginX() + Math.floor((minGeoX - this.tileCacheLayerInfo.getOriginX()) / tileGeoWidth) * tileGeoWidth);
                tileMinGeoY = (float)(this.tileCacheLayerInfo.getOriginY() + Math.floor((minGeoY - this.tileCacheLayerInfo.getOriginY()) / tileGeoHeight) * tileGeoHeight);
            }
            offsetX = (minGeoX - (double)tileMinGeoX) / transformer.getResolution();
            offsetY = (minGeoY - (double)tileMinGeoY) / transformer.getResolution();
            float geoY = tileMinGeoY;
            while ((double)geoY < maxGeoY) {
                nbTilesW = 0;
                float geoX = tileMinGeoX;
                while ((double)geoX <= maxGeoX) {
                    ++nbTilesW;
                    urls.add(this.getTileUri(commonUri, transformer, geoX, geoY, (double)geoX + tileGeoWidth, (double)geoY + tileGeoHeight, bitmapTileW, bitmapTileH));
                    geoX = (float)((double)geoX + tileGeoWidth);
                }
                geoY = (float)((double)geoY + tileGeoHeight);
            }
        } else {
            nbTilesW = 1;
            offsetX = 0.0;
            offsetY = 0.0;
            bitmapTileW = transformer.getRotatedBitmapW();
            bitmapTileH = transformer.getRotatedBitmapH();
            urls.add(this.getTileUri(commonUri, transformer, minGeoX, minGeoY, maxGeoX, maxGeoY, bitmapTileW, bitmapTileH));
        }
        formatter.render(transformer, urls, parallelMapTileLoader, this.context, this.opacity, nbTilesW, offsetX, offsetY, bitmapTileW, bitmapTileH);
    }

    private Transformer fixTiledTransformer(Transformer transformer) throws CloneNotSupportedException {
        double resolution;
        if (this.context.getCurrentPageParams().has("clientResolution")) {
            float clientResolution = this.context.getCurrentPageParams().getFloat("clientResolution");
            boolean hasServerResolution = false;
            for (double serverResolution : this.tileCacheLayerInfo.getResolutions()) {
                if (serverResolution != (double)clientResolution) continue;
                hasServerResolution = true;
            }
            if (!hasServerResolution) {
                return null;
            }
            resolution = clientResolution;
        } else {
            double targetResolution = transformer.getGeoW() / transformer.getStraightBitmapW();
            TileCacheLayerInfo.ResolutionInfo resolutionInfo = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
            resolution = resolutionInfo.value;
        }
        transformer = transformer.clone();
        transformer.setResolution(resolution);
        return transformer;
    }

    protected int[] handleWrapDateLine(int tileX, int tileY, TileCacheLayerInfo.ResolutionInfo resolution, int offsetY) {
        if (tileX < 0) {
            tileX = (int)Math.pow(2.0, resolution.index) + tileX;
        }
        tileX = (int)Math.round((double)tileX % Math.pow(2.0, resolution.index));
        return new int[]{tileX, tileY + offsetY};
    }

    protected abstract URI getTileUri(URI var1, Transformer var2, double var3, double var5, double var7, double var9, long var11, long var13) throws URISyntaxException, UnsupportedEncodingException;
}

