/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.utils.PJsonArray;

public class TileCacheLayerInfo {
    private List<String> versions;
    protected static final Pattern FORMAT_REGEXP = Pattern.compile("^[^/]+/([^/]+)$");
    protected static final Pattern RESOLUTIONS_REGEXP = Pattern.compile("(\\s+)|,");
    protected final int width;
    protected final int height;
    protected final double[] resolutions;
    protected final double minX;
    protected final double minY;
    protected final double maxX;
    protected final double maxY;
    protected final double originX;
    protected final double originY;
    protected String extension;

    public float getResolutionTolerance() {
        return 1.05f;
    }

    public TileCacheLayerInfo(String resolutions, int width, int height, double minX, double minY, double maxX, double maxY, String format, double originX, double originY) {
        String[] resolutionsTxt = RESOLUTIONS_REGEXP.split(resolutions);
        this.resolutions = new double[resolutionsTxt.length];
        for (int i = 0; i < resolutionsTxt.length; ++i) {
            this.resolutions[i] = Double.parseDouble(resolutionsTxt[i]);
        }
        this.sortResolutions();
        this.width = width;
        this.height = height;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.originX = originX;
        this.originY = originY;
        if (format != null) {
            Matcher formatMatcher = FORMAT_REGEXP.matcher(format);
            if (formatMatcher.matches()) {
                this.extension = formatMatcher.group(1).toLowerCase();
                if (this.extension.equals("jpg")) {
                    this.extension = "jpeg";
                }
            } else {
                throw new InvalidValueException("format", format);
            }
        }
    }

    public TileCacheLayerInfo(String resolutions, int width, int height, float minX, float minY, float maxX, float maxY, String format) {
        this(resolutions, width, height, (double)minX, (double)minY, (double)maxX, (double)maxY, format, (double)minX, (double)minY);
    }

    public TileCacheLayerInfo(PJsonArray resolutions, int width, int height, float minX, float minY, float maxX, float maxY, String extension, float originX, float originY) {
        this.resolutions = new double[resolutions.size()];
        for (int i = 0; i < resolutions.size(); ++i) {
            this.resolutions[i] = resolutions.getDouble(i);
        }
        this.sortResolutions();
        this.width = width;
        this.height = height;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.originX = originX;
        this.originY = originY;
        this.extension = extension;
    }

    public TileCacheLayerInfo(PJsonArray resolutions, int width, int height, float minX, float minY, float maxX, float maxY, String extension) {
        this(resolutions, width, height, minX, minY, maxX, maxY, extension, minX, minY);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResolutionInfo getNearestResolution(double targetResolution) {
        int pos = this.resolutions.length - 1;
        double result = this.resolutions[pos];
        float tolerance = this.getResolutionTolerance();
        for (int i = this.resolutions.length - 1; i >= 0; --i) {
            double cur = this.resolutions[i];
            double distance = Math.abs(targetResolution - cur);
            if (!(cur <= targetResolution * (double)tolerance)) break;
            if (!(distance <= Math.abs(targetResolution - result))) continue;
            result = cur;
            pos = i;
            if (distance < (double)1.0E-7f) break;
        }
        return new ResolutionInfo(pos, result);
    }

    public double[] getResolutions() {
        return this.resolutions;
    }

    public String getExtension() {
        return this.extension;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getOriginX() {
        return this.originX;
    }

    public double getOriginY() {
        return this.originY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TileCacheLayerInfo");
        sb.append("{width=").append(this.width);
        sb.append(", height=").append(this.height);
        sb.append(", minX=").append(this.minX);
        sb.append(", minY=").append(this.minY);
        sb.append(", maxX=").append(this.maxX);
        sb.append(", maxY=").append(this.maxY);
        sb.append(", originX=").append(this.originX);
        sb.append(", originY=").append(this.originY);
        sb.append(", extension='").append(this.extension).append('\'');
        sb.append(", resolutions=").append(this.resolutions == null ? "null" : "");
        for (int i = 0; this.resolutions != null && i < this.resolutions.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.resolutions[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean isVisible(double x1, double y1, double x2, double y2) {
        return x1 >= this.minX && x1 <= this.maxX && y1 >= this.minY && y1 <= this.maxY;
    }

    private void sortResolutions() {
        Arrays.sort(this.resolutions);
        int right = this.resolutions.length - 1;
        for (int left = 0; left < right; ++left, --right) {
            double temp = this.resolutions[left];
            this.resolutions[left] = this.resolutions[right];
            this.resolutions[right] = temp;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileCacheLayerInfo that = (TileCacheLayerInfo)o;
        if (this.height != that.height) {
            return false;
        }
        if (Double.compare(that.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(that.maxY, this.maxY) != 0) {
            return false;
        }
        if (Double.compare(that.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(that.minY, this.minY) != 0) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (!this.extension.equals(that.extension)) {
            return false;
        }
        return Arrays.equals(this.resolutions, that.resolutions);
    }

    public static class ResolutionInfo {
        public final int index;
        public final double value;

        public ResolutionInfo(int index, double value) {
            this.index = index;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolutionInfo that = (ResolutionInfo)o;
            return this.index == that.index && Double.compare(that.value, this.value) == 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ResolutionInfo");
            sb.append("{index=").append(this.index);
            sb.append(", result=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

