/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.uglify;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.Validate;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class UglifyJs {
    private static final Logger LOG = LoggerFactory.getLogger(UglifyJs.class);
    public static final String DEFAULT_UGLIFY_JS = "uglifyJs.min.js";
    private String invokeScript;
    private String defaultOptionsAsJson;
    private final boolean uglify;
    private String reservedNames;
    private ScriptableObject scope;

    private String getInvokeScript() throws IOException {
        if (this.invokeScript == null) {
            this.invokeScript = IOUtils.toString((InputStream)new AutoCloseInputStream(UglifyJs.class.getResourceAsStream("invoke.js")));
        }
        return this.invokeScript;
    }

    public UglifyJs(Type uglifyType) {
        Validate.notNull((Object)((Object)uglifyType));
        this.uglify = uglifyType == Type.UGLIFY;
    }

    public static UglifyJs uglifyJs() {
        return new UglifyJs(Type.UGLIFY);
    }

    public static UglifyJs beautifyJs() {
        return new UglifyJs(Type.BEAUTIFY);
    }

    public UglifyJs setReservedNames(String reservedNames) {
        this.reservedNames = reservedNames;
        return this;
    }

    private String getReservedNames() {
        return this.reservedNames == null ? "" : this.reservedNames;
    }

    private RhinoScriptBuilder initScriptBuilder() {
        RhinoScriptBuilder builder = null;
        try {
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().addJSON().evaluateChain(UglifyJs.class.getResourceAsStream("init.js"), "initScript").evaluateChain(this.getScriptAsStream(), DEFAULT_UGLIFY_JS);
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed initializing js", ex);
        }
    }

    protected InputStream getScriptAsStream() {
        return UglifyJs.class.getResourceAsStream(DEFAULT_UGLIFY_JS);
    }

    public String process(String filename, String code) throws IOException {
        StopWatch watch = new StopWatch();
        watch.start("init " + filename);
        RhinoScriptBuilder builder = this.initScriptBuilder();
        watch.stop();
        String originalCode = WroUtil.toJSMultiLineString((String)code);
        String optionsAsJson = this.createOptionsAsJson();
        Validate.notNull((Object)optionsAsJson);
        String scriptAsString = String.format(this.getInvokeScript(), originalCode, optionsAsJson);
        watch.start(this.uglify ? "uglify" : "beautify");
        Object result = builder.evaluate(scriptAsString, "uglifyIt");
        watch.stop();
        LOG.debug(watch.prettyPrint());
        return String.valueOf(result);
    }

    protected String createOptionsAsJson() throws IOException {
        return String.format(this.getDefaultOptions(), !this.uglify, this.getReservedNames());
    }

    private String getDefaultOptions() throws IOException {
        if (this.defaultOptionsAsJson == null) {
            this.defaultOptionsAsJson = IOUtils.toString((InputStream)new AutoCloseInputStream(UglifyJs.class.getResourceAsStream("options.js")));
        }
        return this.defaultOptionsAsJson;
    }

    public static enum Type {
        BEAUTIFY,
        UGLIFY;

    }
}

