/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.SupportAware;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.JS)
public class NodeCoffeeScriptProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
SupportAware {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCoffeeScriptProcessor.class);
    private static final String OPTION_COMPILE = "-cp";
    private static final String SHELL_COMMAND = "coffee";
    public static final String ALIAS = "nodeCoffeeScript";
    private final boolean isWindows;

    public NodeCoffeeScriptProcessor() {
        String osName = System.getProperty("os.name");
        LOG.debug("OS Name: {}", (Object)osName);
        this.isWindows = osName != null && osName.contains("Windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        LOG.debug("processing {} resource", (Object)resource);
        String content = IOUtils.toString((Reader)reader);
        String resourceUri = resource == null ? "unknown.coffee" : resource.getUri();
        try {
            writer.write(this.process(resourceUri, content));
        }
        catch (Exception e) {
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e, content);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private String process(String resourceUri, String content) {
        File temp = null;
        try {
            temp = WroUtil.createTempFile();
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(temp), (Charset)StandardCharsets.UTF_8);
            LOG.debug("absolute path: {}", (Object)temp.getAbsolutePath());
            Process process = this.createProcess(temp);
            String result = IOUtils.toString((InputStream)new AutoCloseInputStream(process.getInputStream()), (Charset)StandardCharsets.UTF_8);
            int exitStatus = process.waitFor();
            if (exitStatus != 0) {
                String compileError = result;
                LOG.error("exitStatus: {}", (Object)exitStatus);
                String errorMessage = MessageFormat.format("Error in CoffeeScript: \n{0}", compileError.replace(temp.getPath(), resourceUri));
                throw new WroRuntimeException(errorMessage);
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e);
        }
        finally {
            FileUtils.deleteQuietly((File)temp);
        }
    }

    protected void onException(Exception e, String content) {
        throw WroRuntimeException.wrap((Exception)e);
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    private Process createProcess(File sourceFile) throws IOException {
        Validate.notNull((Object)sourceFile);
        String[] commandLine = this.getCommandLine(sourceFile.getPath());
        LOG.debug("CommandLine arguments: {}", Arrays.asList(commandLine));
        return new ProcessBuilder(commandLine).redirectErrorStream(true).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupported() {
        File temp = null;
        try {
            temp = WroUtil.createTempFile();
            Process process = this.createProcess(temp);
            int exitValue = process.waitFor();
            LOG.debug("exitValue {}. ErrorMessage: {}", (Object)exitValue, (Object)IOUtils.toString((InputStream)process.getInputStream()));
            if (exitValue != 0) {
                throw new UnsupportedOperationException("Lessc is not a supported operation on this platform");
            }
            LOG.debug("The {} processor is supported.", (Object)this.getClass().getName());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.debug("The {} processor is not supported. Because: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.deleteQuietly((File)temp);
        }
    }

    protected String[] getCommandLine(String filePath) {
        return this.isWindows ? this.buildArgumentsForWindows(filePath) : this.buildArgumentsForUnix(filePath);
    }

    private String[] buildArgumentsForUnix(String filePath) {
        return this.buildCommonArguments(filePath);
    }

    private String[] buildCommonArguments(String filePath) {
        Object[] optionalArguments = this.buildOptionalArguments();
        Object[] arguments = (String[])ArrayUtils.addAll((Object[])new String[]{SHELL_COMMAND, OPTION_COMPILE}, (Object[])optionalArguments);
        return (String[])ArrayUtils.add((Object[])arguments, (Object)filePath);
    }

    protected String[] buildOptionalArguments() {
        return null;
    }

    private String[] buildArgumentsForWindows(String filePath) {
        Object[] optionalArguments = this.buildOptionalArguments();
        Object[] arguments = (String[])ArrayUtils.addAll((Object[])new String[]{"cmd", "/c", SHELL_COMMAND, OPTION_COMPILE}, (Object[])optionalArguments);
        return (String[])ArrayUtils.add((Object[])arguments, (Object)filePath);
    }
}

