/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class HttpServerUtil {
    private static File _tmpDir = null;
    private static DiskFileItemFactory _fileItemFactory = null;
    private static ServletFileUpload _fileUpload = null;

    private static ServletFileUpload _getServletFileUpload() {
        if (_fileUpload == null) {
            _fileItemFactory = new DiskFileItemFactory();
            if (_tmpDir != null) {
                _fileItemFactory.setRepository(_tmpDir);
            }
            _fileUpload = new ServletFileUpload((FileItemFactory)_fileItemFactory);
        }
        return _fileUpload;
    }

    public static void setTmpDir(File tmpDir) {
        _tmpDir = tmpDir;
        if (_fileItemFactory != null) {
            _fileItemFactory.setRepository(tmpDir);
        }
    }

    public static boolean isMultipartFormRequest(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public static String getParameter(HttpServletRequest request, String paramName) {
        return HttpServerUtil.getParameter(request, paramName, null);
    }

    public static String getParameter(HttpServletRequest request, String paramName, String defaultValue) {
        String result = request.getParameter(paramName);
        if (result == null) {
            result = defaultValue;
        } else if ((result = result.trim()).length() == 0) {
            result = defaultValue;
        }
        return result;
    }

    public static Map parseMultipartFormRequest(HttpServletRequest request) throws IOException {
        try {
            List fileItems = HttpServerUtil._getServletFileUpload().parseRequest(request);
            HashMap<String, FileItem> resultMap = new HashMap<String, FileItem>(fileItems.size() * 2);
            Iterator iter = fileItems.iterator();
            while (iter.hasNext()) {
                FileItem fileItem = (FileItem)iter.next();
                resultMap.put(fileItem.getFieldName(), fileItem);
            }
            return resultMap;
        }
        catch (FileUploadException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static String getParameter(Map fileItemMap, String paramName) {
        return HttpServerUtil.getParameter(fileItemMap, paramName, null);
    }

    public static String getParameter(Map fileItemMap, String paramName, String defaultValue) {
        String result = defaultValue;
        FileItem fileItem = (FileItem)fileItemMap.get(paramName);
        if (fileItem != null) {
            try {
                result = fileItem.getString("UTF-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 character encoding not supported on this platform");
            }
            if (result.length() == 0) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static byte[] getBinaryParameter(Map fileItemMap, String paramName) {
        byte[] result = null;
        FileItem fileItem = (FileItem)fileItemMap.get(paramName);
        if (fileItem != null) {
            result = fileItem.get();
        }
        return result;
    }

    public static InputStream getStreamParameter(Map fileItemMap, String paramName) throws IOException {
        InputStream result = null;
        FileItem fileItem = (FileItem)fileItemMap.get(paramName);
        if (fileItem != null) {
            result = fileItem.getInputStream();
        }
        return result;
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Cache-Control", "max-age=1");
        response.setHeader("Cache-Control", "no-cache");
        response.setIntHeader("Expires", 0);
        response.setHeader("Pragma", "no-cache");
    }

    public static boolean acceptsGZIPEncoding(HttpServletRequest request) {
        boolean result = false;
        String acceptEncoding = request.getHeader("accept-encoding");
        if (acceptEncoding != null) {
            boolean isInternetExplorer = false;
            String userAgent = request.getHeader("user-agent");
            if (userAgent != null) {
                isInternetExplorer = userAgent.indexOf("MSIE") != -1;
            }
            result = !isInternetExplorer && acceptEncoding.toLowerCase().indexOf("gzip") != -1;
        }
        return result;
    }

    public static OutputStream openGZIPOutputStream(HttpServletResponse response) throws IOException {
        response.setHeader("Content-Encoding", "gzip");
        return new GZIPOutputStream((OutputStream)response.getOutputStream(), 4096);
    }
}

