/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.api.style.ResourceLocator;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public class DefaultResourceLocator
implements ResourceLocator {
    URL sourceUrl;
    private static final Logger LOGGER = Logging.getLogger(DefaultResourceLocator.class);

    public void setSourceUrl(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public URL locateResource(String uri) {
        URL url;
        block5: {
            url = null;
            try {
                url = new URL(uri);
                File f = URLs.urlToFile((URL)url);
                if (f != null && !f.isAbsolute() && !f.exists() && this.sourceUrl != null) {
                    URL validated;
                    String query = this.getQueryPart(url);
                    URL relativeUrl = this.makeRelativeURL(f.getPath(), query);
                    if (relativeUrl != null && (validated = this.validateRelativeURL(relativeUrl)) != null) {
                        url = validated;
                    }
                }
            }
            catch (MalformedURLException mfe) {
                LOGGER.fine("Looks like " + uri + " is a relative path..");
                if (this.sourceUrl != null) {
                    url = this.makeRelativeURL(uri, null);
                }
                if (url != null || (url = this.getClass().getResource(uri)) != null) break block5;
                LOGGER.warning("can't parse " + uri + " as a java resource present in the classpath");
            }
        }
        return url;
    }

    private String getQueryPart(URL url) {
        String external = url.toExternalForm();
        int idx = external.indexOf(63);
        if (idx == -1 || idx == external.length() - 1) {
            return null;
        }
        return external.substring(idx + 1);
    }

    protected URL validateRelativeURL(URL relativeUrl) {
        File f = URLs.urlToFile((URL)relativeUrl);
        if (f != null && f.exists()) {
            return relativeUrl;
        }
        return null;
    }

    protected URL makeRelativeURL(String uri, String query) {
        try {
            if (query != null) {
                return new URL(this.sourceUrl, uri + "?" + query);
            }
            return new URL(this.sourceUrl, uri);
        }
        catch (MalformedURLException e) {
            LOGGER.warning("can't parse " + uri + " as relative to" + this.sourceUrl.toExternalForm());
            return null;
        }
    }
}

